package com.ejie.y41e.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41e.model.Y41eArea;
import com.ejie.y41e.utils.Y41eSqlUtils;

/**
 * AreaDaoImpl
 *  
 */

@Repository
@Transactional
public class Y41eAreaDaoImpl extends Y41eGenericoDaoImpl<Y41eArea> implements Y41eAreaDao {

    public static final String TABLA="Y41E07S01";
    public static final String SECUENCIA="Y41E07Q00";
    public static final String ID_AREA_007="ID_AREA_007";
    public static final String DESC_ES_007="DESC_ES_007";
    public static final String DESC_EU_007="DESC_EU_007";
    public static final String ACTIVA_007="ACTIVA_007";
    protected static final String[] ORDER_BY_WHITE_LIST = new String[] { ID_AREA_007, DESC_ES_007, DESC_EU_007, ACTIVA_007};

    /**
     * Y41eAreaDaoImpl
     */
    public Y41eAreaDaoImpl() {
        super(Y41eArea.class);
    }

    /*
     * ROW_MAPPERS
     */
    private final RowMapper<Y41eArea> rwMap = new RowMapper<Y41eArea>() {
        @Override
        public Y41eArea mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return new Y41eArea(
                    resultSet.getInt(ID_AREA_007), resultSet.getString(DESC_ES_007), resultSet.getString(DESC_EU_007), resultSet.getString(ACTIVA_007)
                    ); 
        } 
    };

    private final RowMapper<Y41eArea> rwMapPK = new RowMapper<Y41eArea>() {
        @Override
        public Y41eArea mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            return new Y41eArea(
                    resultSet.getInt(ID_AREA_007)
                    ); 
        }
    };


    /*
     * OPERACIONES CRUD
     */

    /**
     * Inserts a single row in the Area table.
     *
     * @param area Area
     * @return Area
     */
    @Override
    public Y41eArea add(Y41eArea area) {
        StringBuilder insert = new StringBuilder(Y41eSqlUtils.INSERT)
                .append(TABLA).append(" (")
                .append(ID_AREA_007).append(",")
                .append(DESC_ES_007).append(",")
                .append(DESC_EU_007).append(",")
                .append(ACTIVA_007).append(")")
                .append("VALUES (")
                .append(SECUENCIA)
                .append(".NEXTVAL,?,?,?)");
        this.getJdbcTemplate().update(insert.toString(), area.getDescEs(), area.getDescEu(), area.getActiva());
        return area;
    }

    /**
     * Updates a single row in the Area table.
     *
     * @param area Area
     * @return Area
     */
    @Override
    public Y41eArea update(Y41eArea area) {
        StringBuilder update = new StringBuilder(Y41eSqlUtils.UPDATE)
                .append(TABLA).append(" SET ")
                .append(DESC_ES_007).append("=?,")
                .append(DESC_EU_007).append("=?,")
                .append(ACTIVA_007).append("=? ")
                .append(Y41eSqlUtils.WHERE)
                .append(ID_AREA_007).append("=?");
        this.getJdbcTemplate().update(update.toString(), area.getDescEs(), area.getDescEu(), area.getActiva(), area.getIdArea());
        return area;
    }

    /**
     * Removes a single row in the Area table.
     *
     * @param area Area
     * @return
     */
    @Override
    public void remove(Y41eArea area) {
        StringBuilder delete = new StringBuilder(Y41eSqlUtils.DELETE).append(TABLA).append(Y41eSqlUtils.WHERE).append(ID_AREA_007).append("=?");
        this.getJdbcTemplate().update(delete.toString(), area.getIdArea());
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getSelect()
     */
    @Override
    protected String getSelect() {
        StringBuilder select = new StringBuilder("SELECT ")
                .append(ID_AREA_007).append(",")
                .append(DESC_ES_007).append(",")
                .append(DESC_EU_007).append(",")
                .append(ACTIVA_007);
        return select.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getFrom()
     */
    @Override
    protected String getFrom() {
        StringBuilder from = new StringBuilder(" FROM ").append(TABLA);
        return from.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMap()
     */
    @Override
    protected RowMapper<Y41eArea> getRwMap() {
        return this.rwMap;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getPK()
     */
    @Override
    protected String getPK() {
        return ID_AREA_007;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getRwMapPK()
     */
    @Override
    protected RowMapper<Y41eArea> getRwMapPK() {
        return this.rwMapPK;
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWherePK(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWherePK(Y41eArea bean, List<Object> params) {
        StringBuilder wherePK = new StringBuilder();
        wherePK.append(Y41eSqlUtils.WHERE).append(ID_AREA_007).append("=?");
        params.add(bean.getIdArea());
        return wherePK.toString();

    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhere(java.lang.Object, java.util.List)
     */
    @Override
    protected String getWhere(Y41eArea bean, List<Object> params) {
        StringBuilder where = new StringBuilder(Y41eAreaDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_AREA_007, bean.getIdArea(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_ES_007, bean.getDescEs(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(DESC_EU_007, bean.getDescEu(), params));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_007, bean.getActiva(), params));
        }

        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getWhereLike(java.lang.Object, java.lang.Boolean, java.util.List, java.lang.Boolean)
     */
    @Override
    protected String getWhereLike(Y41eArea bean, Boolean startsWith, List<Object> params, Boolean search) {
        StringBuilder where = new StringBuilder(Y41eAreaDaoImpl.STRING_BUILDER_INIT);

        if (bean  != null){
            where.append(Y41eSqlUtils.generarWhereIgual(ID_AREA_007, bean.getIdArea(), params));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_ES_007, bean.getDescEs(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereLikeNormalizado(DESC_EU_007, bean.getDescEu(), params, startsWith));
            where.append(Y41eSqlUtils.generarWhereIgual(ACTIVA_007, bean.getActiva(), params));
        }
        return where.toString();
    }

    /* (non-Javadoc)
     * @see com.ejie.y41e.dao.Y41eGenericoDaoImpl#getOrderBy()
     */
    @Override
    protected String[] getOrderBy() {
        return Y41eAreaDaoImpl.ORDER_BY_WHITE_LIST;
    }

    /**
     * StringBuilder initilization value
     */
    public static final int STRING_BUILDER_INIT = 4096;

}

