/*!
 *  
 */

/**
 * Presenta los elementos que presenta una tabla rup_table en formato listado. Pensado para movilidad.
 *
 * @summary Componente RUP List.
 * @module rup_list
 */
(function(factory) {
    if (typeof define === "function" && define.amd) {

        // AMD. Register as an anonymous module.
        define(["jquery", "./rup.base"], factory);
    } else {

        // Browser globals
        factory(jQuery);
    }
}(function($) {

    $.widget("$.rup_sortable", $.ui.sortable, {
        options: {
        	filterForm: null, // el objeto para el filtrado
            action: null,
            feedback: null,
            key: null,
            nextListId : null,
            colNames: {source: [], value: null},
            sord: 'asc',
            sidx: null,
    		sortorder: 'asc',
    		placeholder: '',
    		load: function(){}
        },
        
        _validateSkeleton: function(){
        	var id = this.element.attr('id');
        	return $('#'+id+'-content').length
    			&& $('#'+id+'-itemTemplate').length;
        },
        
        _create: function() {
            var self = this;
            
            if(!self._validateSkeleton()){
            	alert('El esqueleto HTML sobre el que montar el listado no es correcto');
            	return;
            }
        	
        	var opciones = self.options;
        	opciones._idContent = self.element.attr('id') + '-content';
        	opciones.content = $('#' + opciones._idContent);
        	opciones._idItemTemplate = self.element.attr('id') + '-itemTemplate';
        	opciones.itemTemplate = $('#' + opciones._idItemTemplate);

            // Asociación de eventos
            self.element.on('load', opciones.load);
            
            $('#' + opciones._idItemTemplate).hide();
            
            this._super();
            
            delete opciones;
            delete self;
        },

        _lock: function(){
        	var opciones = this.options;
        	
        	opciones.content.css('opacity','0.3');
        	var overlay
        	if($('#'+this.element.attr('id')+'-overlay').length>0){
        		overlay = $('#'+this.element.attr('id')+'-overlay');
        	} else {
        		overlay = jQuery('<div id="'+this.element.attr('id')+'-overlay"> </div>');
        		overlay.prependTo(opciones.content);
        	}
        	overlay.width(opciones.content.width());
        	overlay.height(opciones.content.height());
        	
        	delete opciones;
        },
        
        _unlock: function(){
        	var opciones = this.options;
        	
        	opciones.content.css('opacity','1');
        	$('#'+this.element.attr('id')+'-overlay').remove();
        	
        	delete opciones;
        },

        destroy: function() {
            var opciones = this.options;
            // TODO: Eliminar el componente.
            delete opciones;
            $.Widget.prototype.destroy.apply(this, arguments);
        },

        _doFilter: function(){
        	var self = this;
            var opciones = this.options;
            var $itemTemplate = opciones.itemTemplate;
            // Componer el filtro
        	var filter = {
                filter: opciones.filterForm,
                sidx: opciones.sidx,
                sord: opciones.sord
            }
            
//            if(opciones.feedback!=null){
//            	$('#' + opciones.feedback).rup_feedback('hide');
//            	$('#' + opciones.feedback).rup_feedback('destroy').rup_feedback({gotoTop: false}); //FIXME: Pendiente de corrección UDA
//            }
            
        	jQuery.rup_ajax({
                url: opciones.action,
                type: "POST",
                dataType: "json",
                data: JSON.stringify(filter),
                contentType: 'application/json',
                success: function(xhr, b, c) {
                    if (xhr === null || xhr.length === 0) {
                		self.element.hide();
                		if(opciones.feedback!=null){
                			$('#' + opciones.feedback).rup_feedback('set', $.rup.i18n.base.rup_table.errors.errorOnGet, 'error');
                		}
                		opciones.content.slideDown();
                    	self.element.trigger('load');
                    	self._unlock();
                    } else {
                    	if(xhr.rows.length>0){
	                        $.each(xhr.rows, function(index, elem) {
	                            var $item = $itemTemplate.clone(true, true);
	                            $item.attr('id', $item.attr('id') + '_' + elem[opciones.key]);
	                            
	                            //Todos los elementos del template tendrán el id dentro de un data
		                        $item.find('*').data('id', elem[opciones.key]);
	                            
	                            var elemArr = $.rup_utils.jsontoarray(elem);
	                            var elemArrKeys = Object.keys($.rup_utils.jsontoarray(elem));
	                            
	                            for (i = 0; i < elemArrKeys.length; ++i){
	                                $item.find('[id="' + elemArrKeys[i] + '_label"]')
	                                    .text(opciones.colNames[elemArrKeys[i]] ? opciones.colNames[elemArrKeys[i]] : elemArrKeys[i])
	                                    .attr('id', elemArrKeys[i] + '_label_' + elem[opciones.key]);
	                                $item.find('[id="' + elemArrKeys[i] + '_value"]')
	                                    .text(elemArr[elemArrKeys[i]])
	                                    .attr('id', elemArrKeys[i] + '_value_' + elem[opciones.key]);
	                            }
	                            //asociar id a los botones
	                            $item.find("button").each(function(i,e){
	                            	e.id = e.id + "-" +elem[opciones.key];
	                    		});
	                            
	                            if(opciones.nextListId!=null){
	                            	$item.find('#' +opciones.nextListId).attr('id', opciones.nextListId + '_' + elem[opciones.key]);
	                            	$item.find('#' +opciones.nextListId + '-toggle').attr('id', opciones.nextListId + '_' + elem[opciones.key] + '-toggle');
	                            	$item.find('#' +opciones.nextListId + '-content').attr('id', opciones.nextListId + '_' + elem[opciones.key] + '-content');
	                            	$item.find('#' +opciones.nextListId + '-itemTemplate').attr('id', opciones.nextListId + '_' + elem[opciones.key] + '-itemTemplate');
	                            }
	                            
	                            self.element.append($item);
	                        });
	                        
	                        // si ha resultados se muestran cabecera/pie y listado
                    		self.element.show();
	                        
                    		// Si no se está mostrando el content se despliega
	                        opciones.content.slideDown();
                    	} else {
                    		// Si no se devuelven resultados
                    		self.element.hide();
                    		opciones.content.slideDown();
                    		if(opciones.feedback!=null){
                    			$('#' + opciones.feedback).rup_feedback('set', $.rup.i18n.base.rup_table.defaults.emptyrecords, 'alert');
                    		}
                    	}
                    }
                    
                    self.element
	                	.children().each(function(i,e){
	                		setTimeout(function(){
	                			$(e).show('drop', {}, 200, function(){
	                				if($(e).next().length==0){
	                    				self.element.css('height','auto');
	                				}
	                			});
	                		}, 50 + ( i * 50 ));
	                	});
                    
                    self.element.trigger('load');
                    self._unlock();
                },
                error: function(XMLHttpResponse, textStatus, errorThrown){
                	if(opciones.feedback!=null){
                		$('#' + opciones.feedback).rup_feedback('set',XMLHttpResponse.responseText,'error');
                	}
            		self.element.hide();
            		opciones.content.slideDown();
                	
                	self.element.trigger('load');
                	self._unlock();
                }
            });
        	
        	delete self;
            delete opciones;
            delete $itemTemplate;
        },
        
        reload: function(){
        	var self = this;
            self._lock();
            if(self.element.children().length>0){
	            // Eliminar el listado actual y buscar el nuevo
	            self.element
	            	.css('height',self.element.outerHeight()+16)
	            	.children().each(function(i,e){
	            		setTimeout(function(){
	            			$(e).hide('drop', {}, 200, function(){
	                   			$(this).remove();
	                   			
	                   			// Si hemos llegado al último elemento procedemos a buscar el nuevo listado
	                			if(self.element.children().length==0){
	                				self._doFilter();
	                			}
	                		})
	            		}, 50 + ( i * 50 ));
	            	});
            } else {
            	self._doFilter();
            }
            
            delete self;
        },
        
        filter: function() {
            var self = this;
            var opciones = this.options;
            self._lock();

            if(self.element.children().length>0){            
	            // Eliminar el listado actual y buscar el nuevo
	            self.element
	            	.css('height',self.element.outerHeight()+16)
	            	.children().each(function(i,e){
	            		setTimeout(function(){
	            			$(e).hide('drop', {}, 200, function(){
	                   			$(this).remove();
	                   			
	                   			// Si hemos llegado al último elemento procedemos a buscar el nuevo listado
	                			if(self.element.children().length==0){
	                				self._doFilter();
	                			}
	                		})
	            		}, 50 + ( i * 50 ));
	            	});
            } else {
            	self._doFilter();
            }
            
            delete opciones;
            delete self;
        },

        _init: function(message, type, imgClass) {
        	this._super();
        }
    });
}));
