function fncCargarDetalle(){
	if(!$("#resulEncuesta").rup_table("isSelected")) {
		alert($.rup.i18n.app.comun.warningSeleccion);
		return false;
	}else{
		$("#resulEncuestaGraf_filter_form").validate().resetForm();
		bloquearPantalla();
		var idEncuesta = $('#resulEncuesta').rup_table("getActiveRowId");
		var data = $('#resulEncuesta').rup_table("getRowData", idEncuesta);
		if($.rup.lang==="es"){
			$("#descIntGraf").val(data["descIntEs"]);
			$("#descPublGraf").val(data["descPublEs"]);
			$("#areaGraf").val(data["area.descEs"]);
			$("#origenGraf").val(data["origen.descEs"]);
		}else{
			$("#descIntGraf").val(data["descIntEu"]);
			$("#descPublGraf").val(data["descPublEu"]);
			$("#areaGraf").val(data["area.descEu"]);
			$("#origenGraf").val(data["origen.descEu"]);
		}
		$("#activaGraf").val(data["activa"]);
		$("#numEnviosGraf").val(data["numEnvios"]);
		$("#numRespuestasGraf").val(data["numRespuestas"]);
		$("#numSinResponderGraf").val(data["numSinRespuestas"]);
		
		$('#divResulEncuesta').removeClass('in');
		setTimeout(function() {
			$('#divResulEncuesta').addClass('collapsed');
			$('#divEncuestaGrafico').removeClass('collapsed');
			$('#divEncuestaGrafico').removeClass('d-none');
			$('#divEncuestaGrafico').addClass('in');
		}, 500);
		
		cargarGraficos();
		desbloquearPantalla();
	}
}

jQuery(function($){

	$("#resulEncuesta").rup_table({
		
		url: "/y41egGestionWar/resultados/encuesta",
		toolbar: {
			 id: "resulEncuesta_toolbar"
				 ,defaultButtons:{}
				 ,newButtons : [
						{obj : {
							i18nCaption: $.rup.i18n.app.boton.resultados
							,css: "fa fa-list"
							,index: 1
						 }
						 ,json_i18n : $.rup.i18n.app.simpelMaint
						 ,click : 
							function(){
							 fncCargarDetalle();
							}
						}
					]
		},
		colNames: [
			'',
			$.rup.i18nParse($.rup.i18n.app,"tabla.descInterna"),
			$.rup.i18nParse($.rup.i18n.app,"comun.area"),
			$.rup.i18nParse($.rup.i18n.app,"comun.origen"),
			$.rup.i18nParse($.rup.i18n.app,"comun.activa"),
			'',
			'',
			'',
			'',
		],
		colModel: [
			{ 	name: "idEncuesta", 
				hidden: true
			},
			{ 	name: "descInt" + $.rup.lang.capitalize(), 
				align: "", 
				width: 100, 
				index: "DESC_INT_" + $.rup.lang.capitalize().toUpperCase() + "_001"
			},
			{ 	name: "area.desc" + $.rup.lang.capitalize(),
				align: "", 
				width: 50, 
				index: "DESC_" + $.rup.lang.capitalize().toUpperCase() + "_007"
			},
			{ 	name: "origen.desc" + $.rup.lang.capitalize(),
				align: "", 
				width: 50, 
				index: "DESC_" + $.rup.lang.capitalize().toUpperCase() + "_006"
			},
			{ 	name: "activa",
				align: "", 
				width: 20, 
				index: "ACTIVA_001",
				formatter: formatterSiNo
			},
			{ 	name: "descPubl" + $.rup.lang.capitalize(), 
				hidden: true
			},
			{ 	name: "numEnvios", 
				hidden: true
			},
			{ 	name: "numRespuestas", 
				hidden: true
			},
			{ 	name: "numSinRespuestas", 
				hidden: true
			},
        ],
        model:"Y41eEncuesta",
        usePlugins:[
        	"responsive",
			"toolbar",
        	"filter",
        	"fluid",
         	],
		primaryKey: "idEncuesta",
		sortname: "ID_ENCUESTA_001",
		sortorder: "asc",
		loadOnStartUp: true,
		filter : {
			clearSearchFormMode:"reset",
			validate : {
				feedback:""
				, liveCheckingErrors: false
				, showErrorsInFeedback: false
				, showFieldErrorsInFeedback: true
				, ignore: "hidden"
				, rules:{
					"fecEnvioInicio": {date:true},
					"fecEnvioFin": {date: true, fechaMayor:"fecEnvioInicio"}
				}
			}
		},
		loadComplete:function(){
        	$("#resulEncuesta_filter_summary").remove();
			$("#resulEncuesta").rup_table("setSelection", $("#resulEncuesta").rup_table("getDataIDs")[0], false);
		}
	});
	
	jQuery('#area_filter').rup_combo({
		source: "/y41egGestionWar/otrosMant/area"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idArea"
		 }
		,blank: ""
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#area_filter-menu').width(jQuery('#area_filter-button').innerWidth());
		}
	});
	
	jQuery('#origen_filter').rup_combo({
		source: "/y41egGestionWar/otrosMant/origen"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idOrigen"
		 }
		,blank: ''
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#origen_filter-menu').width(jQuery('#origen_filter-button').innerWidth());
		}
	});
	
	jQuery.rup_date({
		from : "fecResulEncuestaInicio_filter",
		to : "fecResulEncuestaFin_filter"
	});
	
	$("span.cursor_pointer").remove();
	$("#resulEncuesta_filter_toggle_icon1").remove();
	$("#resulEncuesta_filter_fieldset").toggle();
	
	$('body').addClass('in');
	
});