jQuery(function($){

	$("#resultDest").rup_table({
		url: "/y41egGestionWar/resultados/destinatario",
		toolbar: {
			 id: "resultDest_toolbar"
				 ,defaultButtons:{
				 }
				,newButtons : []
		},
		colNames: [
			'',
			$.rup.i18nParse($.rup.i18n.app,"tabla.descPublica"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descInterna"),
			$.rup.i18nParse($.rup.i18n.app,"comun.area"),
			$.rup.i18nParse($.rup.i18n.app,"comun.origen"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.destinatario"),
			$.rup.i18nParse($.rup.i18n.app,"comun.fechaEnvio"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.fechaRespuesta")
		],
		colModel: [
			{ 	name: "idEnvio", 
				hidden: true
			},
			{ 	name: "encuesta.descPubl" + $.rup.lang.capitalize(), 
				align: "", 
				width: 100, 
				index: "DESC_PUBL_" + $.rup.lang.capitalize().toUpperCase() + "_001"
			},
			{ 	name: "encuesta.descInt" + $.rup.lang.capitalize(), 
				align: "", 
				width: 100, 
				index: "DESC_INT_" + $.rup.lang.capitalize().toUpperCase() + "_001"
			},
			{ 	name: "encuesta.area.desc" + $.rup.lang.capitalize(),
				align: "", 
				width: 50, 
				index: "DESC_" + $.rup.lang.capitalize().toUpperCase() + "_007"
			},
			{ 	name: "encuesta.origen.desc" + $.rup.lang.capitalize(),
				align: "", 
				width: 50, 
				index: "DESC_" + $.rup.lang.capitalize().toUpperCase() + "_006"
			},
			{ 	name: "idUsuario",
				align: "", 
				width: 50, 
				index: "ID_USUARIO_010"
			},
			{ 	name: "encuesta.fecEnvio",
				align: "", 
				width: 30, 
				index: "FEC_ENVIO_001"
			},
			{ 	name: "fecRespuesta",
				align: "", 
				width: 40, 
				index: "FEC_RESPUESTA_010"
			},
        ],
        model:"Y41eEnvio",
        usePlugins:[
        	"responsive",
        	"filter",
        	"fluid",
        	"toolbar",
        	"report"
         	],
		primaryKey: "idEnvio",
		sortname: "ID_ENVIO_010",
		sortorder: "asc",
		loadOnStartUp: true,
		filter : {
			clearSearchFormMode:"reset",
			validate : {
				feedback:""
				, liveCheckingErrors: false
				, showErrorsInFeedback: false
				, showFieldErrorsInFeedback: true
				, ignore: "hidden"
				, rules:{
					"encuesta.fecEnvioInicio": {date:true},
					"encuesta.fecEnvioFin": {date: true, fechaMayor:"encuesta.fecEnvioInicio"},
					"fecRespuestaInicio": {date:true},
					"fecRespuestaFin": {date: true, fechaMayor:"fecRespuestaInicio"}
				}
			}
		},
		report:{
			buttons:[
				{id : "exportar",
					detalleFila: true,
					i18nCaption:$.rup.i18n.app.boton.excel, 
					modo:"noGenerico",
					grid:"resultDest",
		        	css:"fa fa-file-excel-o",
		        	url: "/y41egGestionWar/resultados/destinatario/excel"
		        }
			]
		},
        loadComplete:function(){
        	jQuery("#resultDest_filter_summary").remove();
        }
	});
	
	jQuery('#area_filter').rup_combo({
		source: "/y41egGestionWar/otrosMant/area"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idArea"
		 }
		,blank: ""
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#area_filter-menu').width(jQuery('#area_filter-button').innerWidth());
		}
	});
	
	jQuery('#origen_filter').rup_combo({
		source: "/y41egGestionWar/otrosMant/origen"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idOrigen"
		 }
		,blank: ''
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#origen_filter-menu').width(jQuery('#origen_filter-button').innerWidth());
		}
	});
	
	jQuery.rup_date({
		from : "fecEnvioInicio_filter",
		to : "fecEnvioFin_filter"
	});
	
	jQuery.rup_date({
		from : "fecRespuestaInicio_filter",
		to : "fecRespuestaFin_filter"
	});
	
	$("span.cursor_pointer").remove();
	$("#resultDest_filter_toggle_icon1").remove();
	$("#resultDest_filter_fieldset").toggle();
	
	$('body').addClass('in');
	
});