var optionsBar = {
	legend : {
		display : false
	},
	scales:{yAxes:[{ticks:{beginAtZero:true}}]}
}

var optionsDonuts = {
		legend : {
			display : false
		}
	}

function obtenerOptions(tipoGrafico){
	if(tipoGrafico==="B"){
		return optionsBar;
	}else{
		return optionsDonuts;
	}
}

function obtenerBackGroundColor(resultados){
	var colorPar = "#0099cc";
	var colorImpar = "#666";
	var arrayColor = [];
	for(var i=0; i<resultados.length;i++){
		arrayColor.push((i%2)?colorImpar:colorPar);
	}
	return arrayColor;
}

function obtenerLabels(resultados){
	var arrayLabels = [];
	for(var i=0; i<resultados.length;i++){
		arrayLabels.push(resultados[i].respuesta.descLocale);
	}
	return arrayLabels;
}

function obtenerData(resultados){
	var arrayData = [];
	for(var i=0; i<resultados.length;i++){
		arrayData.push(resultados[i].numRespuestas);
	}
	return arrayData;
}

jQuery(function($){
	bloquearPantalla();
	for(var i=0; i<listGraficoJson.length;i++){
		var grafico = listGraficoJson[i];
		if(isNotEmpty(grafico.pregunta.tipoPregunta.tipoGrafico)){
			$("#grafico_" + grafico.bloque.idBloque + "_" + grafico.pregunta.idPregunta).rup_chart({
				type : formatterGrafico(grafico.pregunta.tipoPregunta.tipoGrafico),
				data : {
					labels : obtenerLabels(grafico.resultados),
					datasets : [ {
						data : obtenerData(grafico.resultados),
						backgroundColor : obtenerBackGroundColor(grafico.resultados),
					} ]
				},
				options : obtenerOptions(grafico.pregunta.tipoPregunta.tipoGrafico)
			});
		}
	}
	desbloquearPantalla();
	
});