var tipo="";

function validarEncuestaPregunta(){
	var idPregunta = $("#pregunta").rup_table("getSelectedRows")[0];
	var result="";
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/pregunta/validarPregunta/'+ idPregunta,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(data) {
			result = data;
		}
	});
	return result;
}

jQuery(function($){
	
	$('#pregunta_feedback').rup_feedback({
		block : false
	});

	$("#pregunta").rup_table({
		
		url: "/y41egGestionWar/pregunta",
		toolbar: {
			 id: "pregunta_toolbar"
				 ,defaultButtons:{
					add : true,
					edit : true,
					cancel : true,
					save : false,
					clone : true,
					delete: true
				 }
		},
		colNames: [
			$.rup.i18nParse($.rup.i18n.app,"tabla.id"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descPublica"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descInterna"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.tipoPregunta"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.obligatorio"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.activa")
		],
		colModel: [
			{ 	name: "idPregunta", 
				align: "", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true,
				index: "ID_PREGUNTA_004"
			},
			{ 	name: "descPubl" + $.rup.lang.capitalize(), 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_PUBL_" + $.rup.lang.capitalize().toUpperCase() + "_004"
			},
			{ 	name: "descInt" + $.rup.lang.capitalize(), 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_INT_" + $.rup.lang.capitalize().toUpperCase() + "_004"
			},
			{ 	name: "tipoPregunta.desc" + $.rup.lang.capitalize(),
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_" + $.rup.lang.capitalize().toUpperCase() + "_008"
			},
			{ 	name: "obligatorio",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "OBLIGATORIO_004",
				formatter: formatterSiNo
			},
			{ 	name: "activa",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "ACTIVA_004",
				formatter: formatterSiNo
			}
        ],
        model:"Y41ePregunta",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"responsive",
        	"filter",
        	"fluid",
         	],
		primaryKey: "idPregunta",
		sortname: "ID_PREGUNTA_004",
		sortorder: "asc",
		loadOnStartUp: true,
        formEdit:{
        	detailForm: "#pregunta_detail_div",
			fillDataMethod: "clientSide",
    		addEditOptions:{
      			 fillDataMethod: "serverSide",
      			 reloadAfterSubmit: true
      		}
        },
        loadComplete:function(){
        	jQuery("#pregunta_filter_summary").remove();
        }
	});
	
	$("#pregunta_detail_form").rup_validate({
 		ignore: "",
		showErrorsInFeedback: false,
		showFieldErrorsInFeedback: false,
	});
		
	jQuery("#pregunta").on("jqGridAddEditBeforeShowForm.rupTable.formEditing", function(){
		if(tipo==="add"){
			$("#obligatorio_detail_table").bootstrapSwitch("setState", true);
			$("#aviso_detail_table").bootstrapSwitch("setState", false);
		}
	});
	
	$("#pregunta").on("rupTable_beforeAddRow", function(deleteOptions, selectedRow){
		tipo = "add";
		respuestasAvisoStr="";
		$("div.error").remove();
		contCombo=0;
	});
	
	$("#pregunta").on("rupTable_beforeEditRow", function(deleteOptions, selectedRow){
		tipo = "edit";
		$("div.error").remove();
		contCombo=0;
	});
	
	$("#pregunta").on("rupTable_beforeCloneRow", function(deleteOptions, selectedRow){
		tipo = "clone";
		$("div.error").remove();
		contCombo=0;
	});
	
	$("#pregunta").on("rupTable_afterFormFillDataServerSide", function(options, selectedRow, e, t){
		$("div.error").remove();
		respuestasAvisoStr=selectedRow.respuestasAviso;
		if(tipo==="clone"){
			$("#descPublEs_detail_table").val(selectedRow.descPublEs +  SUFIJO_COPIA);
			$("#descPublEu_detail_table").val(selectedRow.descPublEu +  SUFIJO_COPIA);
			$("#descIntEs_detail_table").val(selectedRow.descIntEs +  SUFIJO_COPIA);
			$("#descIntEu_detail_table").val(selectedRow.descIntEu +  SUFIJO_COPIA);
		}
		if(selectedRow.obligatorio===NO){
			$("#obligatorio_detail_table").bootstrapSwitch("setState", false);
		}else{
			$("#obligatorio_detail_table").bootstrapSwitch("setState", true);
		}
		if(selectedRow.aviso===NO){
			$("#aviso_detail_table").bootstrapSwitch("setState", false);
		}else{
			$("#aviso_detail_table").bootstrapSwitch("setState", true);
		}
		if($("#tipoPregunta_detail_table").val()==TIPO_RESPUESTA_TEXTO){
			if(!jQuery("#aviso_detail_table").is(':disabled')){
				jQuery("#aviso_detail_table").bootstrapSwitch('toggleDisabled');
			}
		}else{
			if(jQuery("#aviso_detail_table").is(':disabled')){
				jQuery("#aviso_detail_table").bootstrapSwitch('toggleDisabled');
			}
		}
	});
	
	$("#pregunta").on("rupTable_beforeDeleteRow", function(deleteOptions, selectedRow){
		//mirar si la encuesta ya ha sido enviada o ha sido respondida
		var resultado = validarEncuestaPregunta();
		if(resultado=="EE"){
			alert($.rup.i18n.app.mensaje.borrarPreguntaEnviada);
			return false;
		}else if(resultado=="TE"){
			jQuery.rup_messages("msgConfirm", {
				message: $.rup.i18n.app.mensaje.borrarPreguntaEncuesta,
				title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
				OKFunction: function() {
					var idPregunta = $("#pregunta").rup_table("getSelectedRows")[0];
					jQuery.ajax({
						type: 'DELETE',
						url: '/y41egGestionWar/pregunta/'+ idPregunta,
						dataType:"json",
						contentType: "application/json",
						async: false,
						success : function(data) {
							$("#pregunta").rup_table("showFeedback", $("#pregunta_feedback"), $.rup.i18nParse($.rup.i18n.base,"rup_table.deletedOK"), "ok");
							$("#pregunta").rup_table("reloadGrid");
						}
					});
				}
			});
			return false;
		}
	});	
	
	jQuery("#pregunta").on("jqGridAddEditBeforeSubmit", function(event, object, form, method){
		if(jQuery("#pregunta_detail_form").valid()){
			if(method==='edit'){
				var resultado = validarEncuestaPregunta();
				if(resultado=="EE"){
					jQuery.rup_messages("msgConfirm", {
						message: $.rup.i18n.app.mensaje.editarBloquePregunta,
						title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
						OKFunction: function() {
							$("#pregunta_detail_form").rup_form("ajaxSubmit", {type: "PUT"});
							$("#pregunta_detail_div").rup_dialog("close");
							$("#pregunta").rup_table("showFeedback", $("#pregunta_feedback"), $.rup.i18nParse($.rup.i18n.base,"rup_table.modifyOK"), "ok");
							$("#pregunta").rup_table("reloadGrid");
						}
					});
					return false;
				}
			}
		}else{
			return false;
		}
	});

	$('#activa_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#activa_filter-menu').width(jQuery('#activa_filter-button').innerWidth());
		}
	});
	
	$('#obligatorio_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#obligatorio_filter-menu').width(jQuery('#obligatorio_filter-button').innerWidth());
		}
	});
	
	jQuery('#tipoPregunta_filter').rup_combo({
		source: "/y41egGestionWar/tipoPregunta"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idTipoPregunta"
		 }
		,blank: ""
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#tipoPregunta_filter-menu').width(jQuery('#tipoPregunta_filter-button').innerWidth());
		}
	});
	
	$("[name='my-checkbox']").bootstrapSwitch();
	
	$("span.cursor_pointer").remove();
	$("#pregunta_filter_toggle_icon1").remove();
	$("#pregunta_filter_fieldset").toggle();
	
	$('body').addClass('in');
	
});