var sortablePregunta ="";

function asociarPreguntas(){
	var datos = { 	 selectedIds: [], selectedAll: false};
	$.extend(true, datos, $('#asociarPregunta').rup_table("getSelectedIds"));
	datos.filter = $('#asociarPregunta').rup_table("getFilterParams");
	bloquearPantalla();
	$.ajax({
		type: 'POST',
		url: '/y41egGestionWar/pregunta/asosiarPreguntas',
		dataType: 'json',
		contentType: 'application/json',
		data : $.toJSON(datos),
		success:function(){
			desbloquearPantalla();
			feedback.rup_feedback("set", $.rup.i18nParse($.rup.i18n.app,"feedback.asociarPreguntasOK"), "ok");
			sortablePregunta.rup_sortable("filter");
			$("#divAsociarPregunta").dialog("close"); 
		},
		error: function(data){
			feedback.rup_feedback("set", $.rup.i18nParse($.rup.i18n.app,"feedback.asociarPreguntasError"), "error");
			desbloquearPantalla();
			$("#divAsociarPregunta").dialog("close"); 
		}
	});	
}

jQuery(function($){
	
	$("#divAsociarPregunta").rup_dialog({
        type: $.rup.dialog.DIV,
        autoOpen: false,
        modal: true,
        resizable: true,
        width: "88%",
        title: $.rup.i18n.app.comun.asociarPregunta,
		open: function(a, b, c) {
			$("#asociarPregunta").rup_table("deselectAllRows");
			$("#asociarPregunta").rup_table("filter");
			if(!$("#asociarPregunta_filter_fieldset").is(":hidden")){
				$("#asociarPregunta_filter_fieldset").toggle();
			}
		},
		buttons: [
			{
				text: $.rup.i18nParse($.rup.i18n.base,"rup_global.aceptar"),
				click: function () {
					if(!$("#asociarPregunta").rup_table("isSelected")) {
						alert($.rup.i18n.app.comun.warningSeleccion);
						return false;
					}else{
						asociarPreguntas();
					}
				}
			},
			{
            text: $.rup.i18n.base.rup_global.cancelar,
            click: function () {
            	$("#divAsociarPregunta").dialog("close"); 
            },
            btnType: $.rup.dialog.LINK
        }
		]
	});

	$("#asociarPregunta").rup_table({
		
		url: "/y41egGestionWar/pregunta",
		toolbar: {
			 id: "asociarPregunta_toolbar",
			defaultButtons:{}
		},
		colNames: [
			$.rup.i18nParse($.rup.i18n.app,"tabla.id"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descPublica"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descInterna"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.tipoPregunta"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.obligatorio"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.activa")
		],
		colModel: [
			{ 	name: "idPregunta", 
				hidden: true
			},
			{ 	name: "descPubl" + $.rup.lang.capitalize(), 
				align: "", 
				width: "30%",
				index: "DESC_PUBL_" + $.rup.lang.capitalize().toUpperCase() + "_004"
			},
			{ 	name: "descInt" + $.rup.lang.capitalize(), 
				align: "", 
				width: "30%",
				index: "DESC_INT_" + $.rup.lang.capitalize().toUpperCase() + "_004"
			},
			{ 	name: "tipoPregunta.desc" + $.rup.lang.capitalize(),
				align: "", 
				width: "30%",
				index: "DESC_" + $.rup.lang.capitalize().toUpperCase() + "_008"
			},
			{ 	name: "obligatorio",
				align: "", 
				width: "15%",
				index: "OBLIGATORIO_004",
				formatter: formatterSiNo
			},
			{ 	name: "activa",
				align: "", 
				width: "15%",
				index: "ACTIVA_004",
				formatter: formatterSiNo
			}
        ],

        model:"Y41ePregunta",
        usePlugins:[
        	"filter",
        	"multiselection",
        	"fluid"
         	],
		primaryKey: "idPregunta",
		sortname: "ID_PREGUNTA_004",
		sortorder: "asc",
		loadOnStartUp: false,
        loadComplete:function(){
        	jQuery("#asociarPregunta_filter_summary").remove();
        }
		
	});
	
	$('#obligatorioAsocPre_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		open : function() {
			jQuery('#obligatorioAsocPre_filter-menu').width(jQuery('#obligatorioAsocPre_filter-button').innerWidth());
		}
	});
	
	jQuery('#tipoPreguntaAsocPre_filter').rup_combo({
		source: "/y41egGestionWar/tipoPregunta"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idTipoPregunta"
		 }
		,blank: ""
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#tipoPreguntaAsocPre_filter-menu').width(jQuery('#tipoPreguntaAsocPre_filter-button').innerWidth());
		}
	});
	
	jQuery('#descPublAsocPre_filter').rup_autocomplete({
		source : "/y41egGestionWar/pregunta/suggest",
		sourceParam : {
			label : "descPubl" + jQuery.rup_utils.capitalizedLang()
		},
		extraParams: {
			idBloque: function() {
				return jQuery('#idBloqueAsociar').val();
			},
			tipo : function() {
				return "P";
			}
		},
		getText: true,
		open : function(event, object, arg) {
			 var tam = parseFloat(jQuery('#descPublAsocPre_filter').css("padding-left"))+ parseFloat(jQuery('#descPublAsocPre_filter').css("padding-right"));
			jQuery('.ui-autocomplete.ui-menu.ui-widget.ui-widget-content.ui-corner-all:visible').css("min-width", jQuery('#descPublAsocPre_filter').innerWidth());
		}
	});
	
	jQuery('#descIntAsocPre_filter').rup_autocomplete({
		source : "/y41egGestionWar/pregunta/suggest",
		sourceParam : {
			label : "descInt" + jQuery.rup_utils.capitalizedLang()
		},
		extraParams: {
			idBloque: function() {
				return jQuery('#idBloqueAsociar').val();
			},
			tipo : function() {
				return "I";
			}
		},
		getText: true,
		open : function(event, object, arg) {
			 var tam = parseFloat(jQuery('#descIntAsocPre_filter').css("padding-left"))+ parseFloat(jQuery('#descIntAsocPre_filter').css("padding-right"));
			jQuery('.ui-autocomplete.ui-menu.ui-widget.ui-widget-content.ui-corner-all:visible').css("min-width", jQuery('#descIntAsocPre_filter').innerWidth());
		}
	});
	
	$("#asociarPregunta_filter_cleanLink").off('click');
	$("#asociarPregunta_filter_cleanLink").on('click', function(e){
		e.preventDefault();
		$('#asociarPregunta').rup_table("cleanFilterForm").rup_table('clearGridData',true);
		$("#idBloqueAsociar").val(idBloque);
		$("#idActivaPregAsociar").val(SI);
		$("#asociarPregunta").rup_table("deselectAllRows");
		$("#asociarPregunta").rup_table("filter");
	});
	
	$("span.cursor_pointer").remove();
	$("#asociarPregunta_filter_toggle_icon1").remove();
	
});