jQuery(function($){
	
	$('#origen_feedback').rup_feedback({
		block : false
	});

	$("#origen").rup_table({
		
		url: "/y41egGestionWar/otrosMant/origen",
		toolbar: {
			 id: "origen_toolbar"
				 ,defaultButtons:{
					add : true,
					edit : true,
					cancel : true,
					save : false,
					clone : false,
					delete: true
				 }
		},
		colNames: [
			$.rup.i18nParse($.rup.i18n.app,"tabla.id"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descEu"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descEs"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.activa")
		],
		colModel: [
			{ 	name: "idOrigen", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "ID_ORIGEN_006"
			},
			{ 	name: "descEu", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_EU_006"
			},
			{ 	name: "descEs", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_ES_006"
			},
			{ 	name: "activa", 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "ACTIVA_006",
				formatter: formatterSiNo
			}
        ],

        model:"Y41eOrigen",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"responsive",
        	"filter",
        	"fluid",
         	],
		primaryKey: "idOrigen",
		sortname: "ID_ORIGEN_006",
		sortorder: "asc",
		loadOnStartUp: true,
        formEdit:{
        	detailForm: "#origen_detail_div",
			fillDataMethod: "clientSide",
         	validate:{
        		showErrorsInFeedback: false,
        		showFieldErrorsInFeedback: false,
    			rules:{
    				"idOrigen":{
						required: false
    					},
    				"descEs":{
						required: true
    					},
    				"descEu":{
						required: true
    					},
    				"activa":{
						required: true
    					}
    				}
    		},
    		addEditOptions:{
      			 fillDataMethod: "serverSide",
      			 reloadAfterSubmit: true
      		}
        },
        filter:{
	    	validate:{
	    		rules:{
					"idOrigen":{number:true}
				}
	    	}
		},
        loadComplete:function(){
        	jQuery("#origen_filter_summary").remove();
        }
	});
	
	$('#activa_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#activa_filter-menu').width(jQuery('#activa_filter-button').innerWidth());
		}
	});
	
	$('#activa_detail_table').rup_combo({
		source : [
		{
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#activa_detail_table-menu').width(jQuery('#activa_detail_table-button').innerWidth());
		}
	});
	
	
	$("span.cursor_pointer").remove();
	$("#origen_filter_toggle_icon1").remove();
	$("#origen_filter_fieldset").toggle();
	
	$('body').addClass('in');
	
});