var configForm = {
	type: "POST"
	, feedback: $("#configuracion_feedback")
	, dataType: 'json'
	, contentType: 'application/json'
	, success: function(xhr) {
		$("#configuracion_feedback").rup_feedback('option',{delay:5000, gotoTop:true});
		$("#configuracion_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app, "mensajes.guardadoCorrecto"), 'ok');
	}
	, error: function() {
		$("#configuracion_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app, "mensajes.errorGuardandoDatos"), 'error');
	}
};

function fncCancelar(){
	bloquearPantalla();
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/otrosMant/configuracion/cancelar/',
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(xhr){
			$("#configuracion_form").validate().resetForm();
			var xhrArray = $.rup_utils.jsontoarray(xhr);
			$.rup_utils.populateForm(xhrArray, $("#datosGenerales_form"));
			$("#configuracion_feedback").hide();
			desbloquearPantalla();
		}
	});
}

jQuery(function($){

	$("#configuracion_feedback").rup_feedback({
		block: false,
		closeLink: true,
		gotoTop: true
	});
		
	$("#configuracion_toolbar").rup_toolbar({
		buttons: [
			{
				id : "guardarConfig",
				i18nCaption : $.rup.i18nParse($.rup.i18n.base, "rup_global.save"),
				css : "fa fa-save",
				click : function(event) {
					event.preventDefault();
					event.stopImmediatePropagation();
					$('textarea[id^=texto]').each(function(){
						$(this).tinymce().save();
					});
					if ($("#configuracion_form").valid()) {
						$("#configuracion_form").submit();
					}
				}
			},
			{
				id : "cancelarConfig",
				i18nCaption : $.rup.i18nParse($.rup.i18n.base, "rup_global.cancel"),
				css : "fa fa-ban",
				click : function(event) {
					event.preventDefault();
					event.stopImmediatePropagation();
					fncCancelar();
				}
			}
		]
	});
	
	$("#configuracion_form").rup_form({
		feedback: $("#configuracion_feedback"),
		url: "/y41egGestionWar/otrosMant/configuracion/edit",
		type: "POST",
		dataType: 'json',
		contentType: 'application/json',
		success: function(xhr) {
			desbloquearPantalla();
			$("#configuracion_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app, "mensaje.guardadoCorrecto"), 'ok');
		},
		error: function() {
			desbloquearPantalla();
			$("#configuracion_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app, "mensajes.errorGuardandoDatos"), 'error');
		},
		validate: {
			showErrorsInFeedback: false,
			showFieldErrorAsDefault: false,
			showFieldErrorsInFeedback: false,
			ignore: "hidden",
			rules: {
			},
			showErrors: function(errorMap, errorList) {
				if(errorList.length){
					var idConfig = errorList[0].element.id.split("_")[1];
					$("#enlace_"+idConfig).click();
					this.defaultShowErrors();
				}
			}
		}, 
		beforeSubmit: function() {
			bloquearPantalla();
			$('textarea[id^=texto]').each(function(){
				$(this).tinymce().save();
			});
		}
	});
	
	tinyMCE.init({
		selector : 'textarea:not(#configPerfilSolicitante_declaracionResponsableEs,#configPerfilSolicitante_declaracionResponsableEu)'
		, menubar: false
		, toolbar: [
			"undo redo | styleselect | bold italic underline | alignleft aligncenter alignright alignjustify | outdent indent"
		]
	});
	 
	
	$('#list-tab a').on('click', function (e) {
		e.preventDefault();
		$(this).tab('show');
		$(".list-group .list-group-item").removeClass("active");
		$(e.target).addClass("active");
	});
	
	$('#list-tab a:first').tab('show');
	
	// Mostrar la pantalla
	$('body').addClass('in');
});