var modificado = false;

function deshabilitarBotones(){
	deshabilitarPestania(1);
	$("#bntSiguiente").attr("disabled", "true");
}

function habilitarBotones(){
	habilitarPestania(1);
	$("#bntSiguiente").removeAttr("disabled");
}

function fncCargarDetalle(idEncuesta){
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/encuesta/'+ idEncuesta,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(xhr){
			if(xhr.respondida===SI){
				$("#mensajeRespondida").removeClass("d-none");
			}else{
				$("#mensajeRespondida").addClass("d-none");
			}
			$("#datosGenerales_form").validate().resetForm();
			var xhrArray = $.rup_utils.jsontoarray(xhr);
			$.rup_utils.populateForm(xhrArray, $("#datosGenerales_form"));
			$('#divBusqEncuestas').removeClass('in');
			setTimeout(function() {
				$('#divBusqEncuestas').addClass('collapsed');
				$('#divDetalleEncuestas').removeClass('collapsed');
				$('#divDetalleEncuestas').removeClass('d-none');
				$('#divDetalleEncuestas').addClass('in');
				cargarPestania(0);
				modificado = false;
			}, 500);
			habilitarBotones();
			$("#idEnviadaDG").show();
			$("#datosGenerales_feedback").hide();
			$("#bloques_feedback").hide();
			desbloquearPantalla();
		}
	});
}

function guardarEncuesta(feedback){
	bloquearPantalla();
	modificado = false;
	var encuesta = new Object();
	encuesta=jQuery("#datosGenerales_form").rup_form().formToJson();
	encuesta.idEncuesta=$("#idEncuestaDG").val();
	var type ="POST";
	if(isNotEmpty(encuesta.idEncuesta)){
		type="PUT"
	}
	
	jQuery.ajax({
		type: type,
		url: "/y41egGestionWar/encuesta",
		dataType:"json",
		contentType: "application/json",
		data: $.toJSON(encuesta),
		async: true,
		success : function(encuesta) {
			$("#idEncuestaDG").val(encuesta.idEncuesta);
			$("#urlDG").val(encuesta.url);
			if(type ==="POST"){
				feedback.rup_feedback("set", $.rup.i18nParse($.rup.i18n.base,"rup_table.insertOK"), "ok");
			}else{
				feedback.rup_feedback("set", $.rup.i18nParse($.rup.i18n.base,"rup_table.modifyOK"), "ok");
			}
			habilitarBotones();
			desbloquearPantalla();
		}
		, error: function() {
			feedback.rup_feedback("set", $.rup.i18nParse($.rup.i18n.base,"rup_table.insertError"), "error");
			desbloquearPantalla();
		}
	});
}

$(function() {
	
	jQuery("#btnGuardarEncuesta").click(function(){
		if(jQuery("#datosGenerales_form").valid()){
			guardarEncuesta($("#datosGenerales_feedback"));
		}
	});
	
	$('#btnCancelarEncuesta').on('click', function(){
		if(isEmpty($("#idEncuestaDG").val())){
			$('#idAreaDG').rup_combo("clear");
			$('#idOrigenDG').rup_combo("clear");
			$("#datosGenerales_form").validate().resetForm();
			deshabilitarBotones();
		}else{
			fncCargarDetalle($("#idEncuestaDG").val());
		}
	});
	
	$('#bntSiguiente').on('click', function(){
		// VALIDAR SI SE HA MODIFICADO EL FORMULARIO
		if(jQuery("#datosGenerales_form").valid()){
			if(modificado){
				$("#dialogoConfirm").rup_dialog('open');
			}else{
				cargarPestania(1);
			}
		}
	});
	
	jQuery("#btnVolverBusqueda").click(function(){
		$('#divDetalleEncuestas').removeClass('in');
		$('#rup-list').rup_list('filter');
		setTimeout(function() {
			$('#divDetalleEncuestas').addClass('collapsed');
			$('#divBusqEncuestas').removeClass('collapsed');
			$('#divBusqEncuestas').removeClass('d-none');
			$('#divBusqEncuestas').addClass('in');
		}, 500);
	});
	
	
	$("#dialogoConfirm").rup_dialog({
		type: $.rup.dialog.TEXT,
		autoOpen: false,
		modal: true,
		resizable: false,
		minWidth: 350,
		message: $.rup.i18nParse($.rup.i18n.app, "dialogo.guardarEncuesta"),
		buttons: [{
			text: $.rup.i18nParse($.rup.i18n.base,"rup_global.aceptar"),
			click: function (e) {
				e.preventDefault();
				e.stopImmediatePropagation();
				$("#dialogoConfirm").rup_dialog('close');
				guardarEncuesta($("#bloques_feedback"));
				mostrarBloquesPreguntas();
			}
		},
		{
			text: $.rup.i18nParse($.rup.i18n.base,"rup_global.cancelar"),
			click: function () { 
				$("#dialogoConfirm").rup_dialog('close');
			},
			btnType: $.rup.dialog.LINK
		}]
	});
	
	jQuery.rup_date({
		from : "fecVigInicioDG",
		to : "fecVigFinDG"
	});
	
	$("#datosGenerales_feedback").rup_feedback({
		block: false,
		closeLink: true,
		gotoTop: true
	});
	
	$("#datosGenerales_form").rup_validate({
		feedback:$("#datosGenerales_feedback")
		, liveCheckingErrors: false
		, showErrorsInFeedback: false
		, showFieldErrorsInFeedback: true
		, ignore: "hidden"
		, rules:{
			"fecVigInicio": {date:true},
			"fecVigFin": {date: true, fechaMayor:"fecVigInicio"}
		}
	});
	
	jQuery('#idAreaDG').rup_combo({
		source: "/y41egGestionWar/otrosMant/area"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idArea"
		 }
		,blank: ""
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#idAreaDG-menu').width(jQuery('#idAreaDG-button').innerWidth());
		}
		,select: function(){
			modificado = true;
		}
	});
	
	jQuery('#idOrigenDG').rup_combo({
		source: "/y41egGestionWar/otrosMant/origen"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idOrigen"
		 }
		,blank: ''
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#idOrigenDG-menu').width(jQuery('#idOrigenDG-button').innerWidth());
		}
		,select: function(){
			modificado = true;
		}
		
	});
	
	jQuery("#activaDG").bootstrapSwitch().bootstrapSwitch('setSizeClass', 'switch-small')
		.bootstrapSwitch('setOnLabel', $.rup.i18n.app.comun.si.toUpperCase())
		.bootstrapSwitch('setOffLabel', $.rup.i18n.app.comun.no.toUpperCase());
	
	jQuery("#enviadaDG").bootstrapSwitch().bootstrapSwitch('setSizeClass', 'switch-small')
		.bootstrapSwitch('setOnLabel', $.rup.i18n.app.comun.si.toUpperCase())
		.bootstrapSwitch('setOffLabel', $.rup.i18n.app.comun.no.toUpperCase());
	
	$("#datosGenerales_form input:enabled").change(function(e,a) {
		modificado = true;
	});
	
	if(isEmpty($("#idEncuestaDG").val())){
		$("#idEnviadaDG").hide();
		deshabilitarBotones();
	}
});