function fncDetalleEncuesta(idEncuesta){
	bloquearPantalla();
	fncCargarDetalle(idEncuesta);
}

function validarEncuesta(idEncuesta){
	bloquearPantalla
	var result="";
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/encuesta/validarEncuesta/'+ idEncuesta,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(data) {
			desbloquearPantalla();
			result = data;
		}
	});
	return result;
}

function fncEliminarEncuesta(idBoton){
	var idEncuesta = idBoton.split("_")[1];	
	var cont = validarEncuesta(idEncuesta);
	if(cont>0){
		jQuery.rup_messages("msgAlert", {
			message: $.rup.i18n.app.mensaje.avisoEliminarEncuesta,
			title: $.rup.i18nParse($.rup.i18n.base.rup_message,"alert"),
		});
		return false;
	}else{
		//mensaje confirmación eliminar
		jQuery.rup_messages("msgConfirm", {
			message: $.rup.i18n.base.rup_table.del.msg,
			title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
			OKFunction: function() {
				fncEliminarEncuestaOK(idEncuesta);
			}
		});
	}	
}

function fncCopiarEncuesta(idBoton){
	$("#"+idBoton).parent().parent().removeClass('show');
	var idEncuesta = idBoton.split("_")[1];	
	bloquearPantalla();
	var data = new Object();
	data.idEncuesta = idEncuesta;
	jQuery.ajax({
		type: 'POST',
		url: '/y41egGestionWar/encuesta/copiarEncuesta',
		dataType:"json",
		contentType: "application/json",
		data: JSON.stringify(data),
		async: false,
		success : function(encuesta) {
			fncCargarDetalle(encuesta.idEncuesta);
			$("#datosGenerales_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app,"feedback.copiarOK"), "ok");
			desbloquearPantalla();
		},
		error:function() {
			desbloquearPantalla();
		}
	});
}

function fncEliminarEncuestaOK(idEncuesta){
	bloquearPantalla();
	jQuery.ajax({
		type: 'DELETE',
		url: '/y41egGestionWar/encuesta/'+ idEncuesta,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function() {
			$('#rup-list').rup_list("reload");
			$("#busqEncuesta_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.base,"rup_table.deletedOK"), "ok");
			desbloquearPantalla();
		},
		error:function() {
			desbloquearPantalla();
		}
	});
}

function fncExportarEncuesta(idBoton){
	var idEncuesta = idBoton.split("_")[1];	
	var url = "/y41egGestionWar/encuesta/excel/";
	var data = {};
	data["id"]= idEncuesta;
	
    var $preparingFileModal = $("#reportFileWait");
    $preparingFileModal.dialog({ modal: true });
    $.fileDownload(url, {
    	httpMethod: "POST",
    	data: jQuery.rup_utils.unnestjson(data),
        successCallback: function (url) {
            $preparingFileModal.dialog('close');
        },
        failCallback: function (responseHtml, url) {
            $preparingFileModal.dialog('close');
            $("#reportFileError").dialog({ modal: true });
        }
    });
    return false;
}

function toggleFilterForm(){
	if ($('#busqEncuesta_filter_fieldset').is(":hidden")) {
		//MOSTRAR
		$('#busqEncuesta_filter_fieldset').show("slow");
		$('#busqEncuesta_filter_toggle_icon2').removeClass("ui-icon-circle-triangle-s").addClass("ui-icon-circle-triangle-n");
		$('#busqEncuesta_filter_toggle_icon1').removeClass("ui-icon-triangle-1-e").addClass("ui-icon-triangle-1-s");
		
	}else{
		// OCULTAR
		$('#busqEncuesta_filter_fieldset').hide("slow");
		$('#busqEncuesta_filter_toggle_icon2').removeClass("ui-icon-circle-triangle-n").addClass("ui-icon-circle-triangle-s");
		$('#busqEncuesta_filter_toggle_icon1').removeClass("ui-icon-triangle-1-s").addClass("ui-icon-triangle-1-e");
	}
}

function fncCreateList() {
	  $('#rup-list').rup_list({
	    filterForm: 'busqEncuesta_filter_form',
	    action: './filter',
	    feedback: 'rup-list-feedback',
	    key: 'idEncuesta',
	    colNames: {
	    	'idEncuesta': $.rup.i18n.app.tabla.id.toUpperCase(),
	        'area.descEs': $.rup.i18n.app.comun.area.toUpperCase(),
	        'area.descEu': $.rup.i18n.app.comun.area.toUpperCase(),
	        'origen.descEs': $.rup.i18n.app.comun.origen.toUpperCase(),
	        'origen.descEu': $.rup.i18n.app.comun.origen.toUpperCase(),
	        'activa': $.rup.i18n.app.comun.activa.toUpperCase(),
	        'enviada': $.rup.i18n.app.comun.enviada.toUpperCase(),
	        'fecAlta': $.rup.i18n.app.comun.fechaAlta.toUpperCase(),
	        'fecEnvio': $.rup.i18n.app.comun.fechaEnvio.toUpperCase(),
	        'respondida':$.rup.i18n.app.comun.conRepuestasAsociadas.toUpperCase()
	    },
	    sidx: {
	      source: [{
		    value: 'FEC_ALTA_001',
		    i18nCaption: $.rup.i18n.app.comun.fechaAlta  
	      }, {
	    	value: 'FEC_ENVIO_001',
		    i18nCaption: $.rup.i18n.app.comun.fechaEnvio
	      }, {
	        value: 'ENVIADA_001',
	        i18nCaption: $.rup.i18n.app.comun.enviada
	      }, {	  
	        value: 'ACTIVA_001',
	        i18nCaption: $.rup.i18n.app.comun.activa
	      }, {
	        value: 'DESC_INT_' + $.rup.lang.capitalize().toUpperCase() + '_001',
	        i18nCaption: $.rup.i18n.app.comun.titulo
	      }],
	      value: 'FEC_ALTA_001'
	    },
	    sord: 'asc',
	    visiblePages: 3,
	    load: function() {
	    	$('[id^="activa_value_"], [id^="enviada_value_"]').each(function(i,e){
	    		$(e).text($(e).text()===SI?$.rup.i18n.app.comun.si:$.rup.i18n.app.comun.no);
	    	});
	    	$('[id^="respondida_value_"]').each(function(i,e){
	    		$(e).text($(e).text()===SI?$.rup.i18n.app.comun.si:$.rup.i18n.app.comun.no);
	    	});
	    	
	    	$('[id^="verDetalle_"]').each(function(i,e){
	    		$(e).on('click',function(event){
	    			event.preventDefault();
		 			event.stopImmediatePropagation();
		 			fncDetalleEncuesta($(e).data('id'));
				})
	    	});
	    	
	    	$('#rup-list .item-menu').on('click', function(event) {
	    		event.preventDefault();
	 			event.stopImmediatePropagation();
				$(this).parent().parent().parent().parent().siblings().find('.y41e-item-actions').removeClass('show');
				$(this).parent().parent().parent().parent().find('.y41e-item-actions').toggleClass('show');
			});
	    	
	    	$('#rup-list a.cerrar').on('click', function() {
				$(this).parent().toggleClass('show');
			});
	    	
	    	$('[id^="copiar_"]').each(function(i,e){	
	    		$(e).on('click',function(event){
	    			event.preventDefault();
		 			event.stopImmediatePropagation();
		 			fncCopiarEncuesta(e.id);
				})
	    	});
	    	
	    	$('[id^="eliminar_"]').each(function(i,e){	
	    		$(e).on('click',function(event){
	    			event.preventDefault();
		 			event.stopImmediatePropagation();
		 			fncEliminarEncuesta(e.id);
				})
	    	});
	    	
	    	$('[id^="exportar_"]').each(function(i,e){	
	    		$(e).on('click',function(event){
	    			event.preventDefault();
		 			event.stopImmediatePropagation();
		 			fncExportarEncuesta(e.id);
				})
	    	});
	    }
	    
	  });
}

function avisoError(error){
	$(document).rup_dialog({
			 type: $.rup.dialog.TEXT,
			 autoOpen: true,
			 modal: true,
			 resizable: false,
			 minWidth: 350,
			 title:  $.rup.i18nParse($.rup.i18n.base,"rup_message.error"),
			 message: error,
			 buttons: [{
					text: $.rup.i18nParse($.rup.i18n.base,"rup_global.aceptar"),
					click: function () { 
						$("#rup_textDialogDIV").rup_dialog('destroy');
					}
			 }]
	 });
}

function buscarEncuestas() {
	if($('#busqEncuesta_filter_form').valid()){
		$('#rup-list').rup_list('filter');
	}
}
function limpiar() {
	  $('#area_filter').rup_combo("clear");
	  $('#origen_filter').rup_combo("clear");
	  $('#periodoRespuesta_filter').rup_combo("clear");
	  $('#activa_filter').rup_combo("clear");
	  $('#enviada_filter').rup_combo("clear");
	  $("#busqEncuesta_filter_form").resetForm();
	  buscarEncuestas();
}

$(function() {
	$("#busqEncuesta_feedback").rup_feedback({
		block: false,
		closeLink: true,
		gotoTop: true
	});
	
	$("#busqEncuesta_filter_form").rup_validate({
		feedback:$("#busqEncuesta_feedback")
		, liveCheckingErrors: false
		, showErrorsInFeedback: false
		, showFieldErrorsInFeedback: true
		, ignore: "hidden"
		, rules:{
			"fecEnvioInicio": {date:true},
			"fecEnvioFin": {date: true, fechaMayor:"fecEnvioInicio"},
			"fecVigInicio": {date:true},
			"fecVigFin": {date: true, fechaMayor:"fecVigInicio"}
		}
	});
	
	$('#botBuscar').button();
	
	jQuery('#area_filter').rup_combo({
		source: "/y41egGestionWar/otrosMant/area"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idArea"
		 }
		,blank: ""
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#area_filter-menu').width(jQuery('#area_filter-button').innerWidth());
		}
	});
	
	jQuery('#origen_filter').rup_combo({
		source: "/y41egGestionWar/otrosMant/origen"
		,sourceParam: {
			 label:"desc"+jQuery.rup_utils.capitalizedLang()
			,value:"idOrigen"
		 }
		,blank: ''
		,width: "98%"
		,rowStriping: true
		,ordered: false
		,open: function(){
			jQuery('#origen_filter-menu').width(jQuery('#origen_filter-button').innerWidth());
		}
	});
	
	$('#periodoRespuesta_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#periodoRespuesta_filter-menu').width(jQuery('#periodoRespuesta_filter-button').innerWidth());
		}
	});
	
	$('#activa_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#activa_filter-menu').width(jQuery('#activa_filter-button').innerWidth());
		}
	});
	
	$('#enviada_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#enviada_filter-menu').width(jQuery('#enviada_filter-button').innerWidth());
		}
	});
	
	jQuery.rup_date({
		from : "fecEnvioInicio_filter",
		to : "fecEnvioFin_filter"
	});
	
	jQuery.rup_date({
		from : "fecVigInicio_filter",
		to : "fecVigFin_filter"
	});
	
	fncCreateList();

	$('#botBuscar').on('click', buscarEncuestas);
	$('#botLimpiar').on('click', limpiar);
	
	$('#busqEncuesta_filter_toolbar').on('click', toggleFilterForm);
	
	$('#botBuscar').click();
	$('#busqEncuesta_filter_toolbar').click();
	
	$('body').addClass('in');
	$('#divDetalleEncuestas').addClass('d-none');
	
});