function validarDesasociar(idBloque){
	var result="";
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/pregunta/validarDesasociar/'+ idBloque,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(data) {
			result = data;
		}
	});
	return result;
}

function actualizarOrden() {
	var orden = $('#sortablePregunta').rup_sortable("toArray").join(';');
	var data = {};
	data.orden = orden;
	data.idBloque = idBloque;
	
	jQuery.ajax({
		type: "POST",
		url: "/y41egGestionWar/relbloquepregunta/moverPregunta",
		dataType:"json",
		contentType: "application/json",
		data: JSON.stringify(data),
		async: true,
		success : function() {
		}
	});
}

function fncEliminarPregunta(idBoton){
	var idBloque = idBoton.split("-")[1].split("___")[0];
	var resultado = validarDesasociar(idBloque);
	if(resultado=="EE"){
		alert($.rup.i18n.app.mensaje.borrarPreguntaEnviada);
		return false;
	}else if(resultado=="TE"){
		jQuery.rup_messages("msgConfirm", {
			message: $.rup.i18n.app.mensaje.borrarPreguntaEncuesta,
			title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
			OKFunction: function() {
				fncEliminarPreguntaOK(idBoton);
			}
		});
		return false;
	}else {
		jQuery.rup_messages("msgConfirm", {
			message: $.rup.i18nParse($.rup.i18n.app.mensaje,"avisoBorrarPregunta"),
			title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
			OKFunction: function() {
				fncEliminarPreguntaOK(idBoton);
			}
		});
	}
}



function fncEliminarPreguntaOK(idBoton){
	bloquearPantalla();
	var idEncuesta = "0";
	var idBloque = idBoton.split("-")[1].split("___")[0];
	var idPregunta = idBoton.split("-")[1].split("___")[1];
	jQuery.ajax({
		type: 'DELETE',
		url: '/y41egGestionWar/relbloquepregunta/'+ idEncuesta + "/" + idBloque + "/" + idPregunta,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function() {
			$('#preguntas_feedback').rup_feedback("set", $.rup.i18nParse($.rup.i18n.base,"rup_table.deletedOK"), "ok");
			$('#sortablePregunta').rup_sortable("reload");
			desbloquearPantalla();
		}
	});
}

function fncDetallePregunta(idBoton){
	bloquearPantalla();
	var idPregunta = idBoton.split("-")[1].split("___")[1];
	$("#pregunta_detail_form").validate().resetForm();
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/pregunta/'+ idPregunta,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(xhr){
			//método a ejecutar
			tipo="edit";
			contCombo = 0;
			$("div.error").remove();
			respuestasAvisoStr=xhr.respuestasAviso;
			var xhrArray = $.rup_utils.jsontoarray(xhr);
			$.rup_utils.populateForm(xhrArray, $("#pregunta_detail_form"));
			$("#idBloquePreguntaDet").val(idBloque);
			jQuery("#pregunta_detail_div").rup_dialog("open");
			desbloquearPantalla();
		}
	});
}

function fncCreatePreguntasSortable() {
	var relBloquePregunta = new Object();
	var bloque = new Object();
	bloque.idBloque = idBloque;
	bloque.idEncuesta = "";
	relBloquePregunta.bloque=bloque;
	$('#sortablePregunta').rup_sortable({
		filterForm : relBloquePregunta,
		feedback : "preguntas_feedback",
	    action: '/y41egGestionWar/relbloquepregunta/filter',
	    key: 'codigoPK',
	    sord: 'asc',
	    placeholder:"espacio-disponible",
	    sidx: 'ORDEN_PREG_005',
	    colNames: {
	        'pregunta.tipoPregunta.descEs': $.rup.i18n.app.tabla.tipoPregunta.toUpperCase(),
	        'pregunta.tipoPregunta.descEu': $.rup.i18n.app.tabla.tipoPregunta.toUpperCase(),
	        'pregunta.obligatorio': $.rup.i18n.app.tabla.obligatorio.toUpperCase(),
	        'pregunta.aviso': $.rup.i18n.app.tabla.aviso.toUpperCase()
	    },
	    load: function() {
	    	$('button.verDetalle').each(function(i,e){
	    		$(e).attr('title', $.rup.i18n.app.boton.editarPregunta);
	    		$(e).on('click',function(event){
	    			event.preventDefault();
		 			event.stopImmediatePropagation();
		 			fncDetallePregunta(e.id);
				})
	    	});
	    	
	    	$('button.eliminar').each(function(i,e){
	    		$(e).attr('title', $.rup.i18n.app.boton.desasociarPregunta);
	    		$(e).on('click',function(event){
	    			event.preventDefault();
		 			event.stopImmediatePropagation();
					fncEliminarPregunta(e.id);
				})
	    	});
	    	
	    	$('[id^="pregunta.obligatorio_value"]').each(function(i,e){
	    		$(e).text(formatterSiNo($(e).text()));
	    	});
	    	
	    	$('[id^="pregunta.aviso_value"]').each(function(i,e){
	    		$(e).text(formatterSiNo($(e).text()));
	    	});
	    	
	    	$('[id^="pregunta.tipoPregunta.idTipoPregunta_value"]').each(function(i,e){
	    		var id = $(e).attr('id').split('_value_')[1];
	    		if($(e).text()!=TIPO_RESPUESTA_SI_NO){
	    			$("#enlazar-"+ id).remove();
	    		}
	    	});
	    },
	    distance: 5,
	    delay: 300,
	    opacity: 0.6,
	    cursor: 'move',
	    update: function() {
	    	actualizarOrden();
	    }
	  }).disableSelection();
	  
	  $('#sortablePregunta').rup_sortable("filter");
}

jQuery(function($){
		
    $('#preguntas_feedback').rup_feedback({
		block: false,
		closeLink: true,
		gotoTop: true
	});
	
	$("#preguntas_toolbar").rup_toolbar({
		buttons : [ 
			{
				id : "volver",
				i18nCaption : $.rup.i18n.app.boton.volver,
				css : "fa fa-arrow-circle-o-left",
				click : function(e) {
					$('#divPreguntas').removeClass('in');
					setTimeout(function() {
						$('#divPreguntas').addClass('collapsed');
						$('#divPreguntas').addClass('d-none');
						$('#divBloque').removeClass('collapsed');
						$('#divBloque').addClass('in');
					}, 500);
				}
			}, 
			{
				id : "nuevo",
				i18nCaption :  $.rup.i18n.app.boton.nuevaPregunta,
				css : "fa fa-plus",
				click : function(e) {
					tipo="add";
					jQuery('#respuestasAvisoId').val("");
					respuestasAvisoStr="";
					contCombo = 0;
					$('#tipoPregunta_detail_table').rup_combo("clear");
					$('#respuestasAviso_detail_table').rup_combo("clear");
					$("#pregunta_detail_form").validate().resetForm();
					$("#idBloquePreguntaDet").val(idBloque);
					$("#obligatorio_detail_table").bootstrapSwitch("setState", true);
					$("#aviso_detail_table").bootstrapSwitch("setState", false);
					jQuery("#pregunta_detail_div").rup_dialog("open");
				}
			}
			, 
			{
				id : "asociar",
				i18nCaption :  $.rup.i18n.app.boton.asociarPregunta,
				css : "fa fa-link",
				click : function(e) {
					$('#asociarPregunta').rup_table("cleanFilterForm").rup_table('clearGridData',true);
					$("#idBloqueAsociar").val(idBloque);
					$("#idActivaPregAsociar").val(SI);
					jQuery("#divAsociarPregunta").rup_dialog("open");
				}
			}
		]
	});
	
	feedback = $('#preguntas_feedback');
	sortablePregunta = $('#sortablePregunta');
});