var idBloque = "";
var tipo="";

function validarEncuestaBloque(){
	var idBloque = $("#bloque").rup_table("getSelectedRows")[0];
	var result="";
	jQuery.ajax({
		type: 'GET',
		url: '/y41egGestionWar/bloque/validarBloque/'+ idBloque,
		dataType:"json",
		contentType: "application/json",
		async: false,
		success : function(data) {
			result = data;
		}
	});
	return result;
}

function cargarPreguntas(){
	if(!$("#bloque").rup_table("isSelected")) {
		alert($.rup.i18n.app.comun.warningSeleccion);
		return false;
	}else{
		idBloque = $("#bloque").rup_table("getSelectedRows")[0];
		var data = $('#bloque').rup_table("getRowData", idBloque);
		fncCreatePreguntasSortable();
		$("#divPreguntas h2").html(data["descInt"+ $.rup.lang.capitalize()]);
		$('#divBloque').removeClass('in');
		setTimeout(function() {
			$('#divBloque').addClass('collapsed');
			$('#divPreguntas').removeClass('collapsed');
			$('#divPreguntas').removeClass('d-none');
			$('#divPreguntas').addClass('in');
		}, 500);
	}
}

jQuery(function($){
	
	$('#bloque_feedback').rup_feedback({
		okFeedbackConfig: {delay: null},
		block : false
	});

	$("#bloque").rup_table({
		url: "/y41egGestionWar/bloque",
		toolbar: {
			 id: "bloque_toolbar"
				 ,defaultButtons:{
					add : true,
					edit : true,
					cancel : true,
					save : false,
					clone : true,
					delete: true
				 }
				 ,newButtons : [
						{obj : {
							i18nCaption: $.rup.i18n.app.boton.preguntasBloque
							,css: "fa fa-question"
							,index: 1
						 }
						 ,json_i18n : $.rup.i18n.app.simpelMaint
						 ,click : 
							function(){
								cargarPreguntas();
							}
						}
					]
		},
		colNames: [
			$.rup.i18nParse($.rup.i18n.app,"tabla.id"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descPublica"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descInterna"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.obligatorio"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.activa")
		],
		colModel: [
			{ 	name: "idBloque", 
				align: "", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true,
				index: "ID_PREGUNTA_002"
			},
			{ 	name: "descPubl" + $.rup.lang.capitalize(), 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_PUBL_" + $.rup.lang.capitalize().toUpperCase() + "_002"
			},
			{ 	name: "descInt" + $.rup.lang.capitalize(), 
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "DESC_INT_" + $.rup.lang.capitalize().toUpperCase() + "_002"
			},
			{ 	name: "obligatorio",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "OBLIGATORIO_002",
				formatter: formatterSiNo
			},
			{ 	name: "activa",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				index: "ACTIVA_002",
				formatter: formatterSiNo
			}
        ],

        model:"Y41eBloque",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"responsive",
        	"filter",
        	"fluid",
         	],
		primaryKey: "idBloque",
		sortname: "ID_BLOQUE_002",
		sortorder: "asc",
		loadOnStartUp: true,
        formEdit:{
        	detailForm: "#bloque_detail_div",
			fillDataMethod: "clientSide",
         	validate:{
        		showErrorsInFeedback: false,
        		showFieldErrorsInFeedback: false,
    			rules:{
    			}
    		},
    		addEditOptions:{
      			 fillDataMethod: "serverSide",
      			 reloadAfterSubmit: true
      		}
        },
        loadComplete:function(){
        	jQuery("#bloque_filter_summary").remove();
        }
	});
			
	$("#bloque").on("rupTable_beforeDeleteRow", function(deleteOptions, selectedRow){
		//mirar si la encuesta ya ha sido enviada o ha sido respondida
		var resultado = validarEncuestaBloque();
		if(resultado=="EE"){
			alert($.rup.i18n.app.mensaje.borrarBloque);
			return false;
		}else if(resultado=="TE"){
			jQuery.rup_messages("msgConfirm", {
				message: $.rup.i18n.app.mensaje.borrarBloqueEncuesta,
				title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
				OKFunction: function() {
					var idBloque = $("#bloque").rup_table("getSelectedRows")[0];
					jQuery.ajax({
						type: 'DELETE',
						url: '/y41egGestionWar/bloque/'+ idBloque,
						dataType:"json",
						contentType: "application/json",
						async: false,
						success : function(data) {
							$("#bloque").rup_table("showFeedback", $("#bloque_feedback"), $.rup.i18nParse($.rup.i18n.base,"rup_table.deletedOK"), "ok");
							$("#bloque").rup_table("reloadGrid");
						}
					});
				}
			});
			return false;
		}
	});
			
	$("#bloque").on("rupTable_beforeEditRow", function(deleteOptions, selectedRow){
		tipo = "edit";
	});
	
	$("#bloque").on("rupTable_beforeCloneRow", function(deleteOptions, selectedRow){
		tipo = "clone";
	});
	
	jQuery("#bloque").on("jqGridAddEditBeforeShowForm.rupTable.formEditing", function(){
		if(tipo==="add"){
			$("#obligatorioBloque_detail_table").bootstrapSwitch("setState", true);
		}
	});
	
	$("#bloque").on("rupTable_beforeAddRow", function(deleteOptions, selectedRow){
		tipo = "add";
		
	});
	
	$("#bloque").on("rupTable_afterFormFillDataServerSide", function(options, selectedRow, e, t, r){
		if(tipo==="clone"){
			$("#descPublEsBloque_detail_table").val(selectedRow.descPublEs +  SUFIJO_COPIA);
			$("#descPublEuBloque_detail_table").val(selectedRow.descPublEu +  SUFIJO_COPIA);
			$("#descIntEsBloque_detail_table").val(selectedRow.descIntEs +  SUFIJO_COPIA);
			$("#descIntEuBloque_detail_table").val(selectedRow.descIntEu +  SUFIJO_COPIA);
		}
		if(selectedRow.obligatorio===NO){
			$("#obligatorioBloque_detail_table").bootstrapSwitch("setState", false);
		}else{
			$("#obligatorioBloque_detail_table").bootstrapSwitch("setState", true);
		}
	});
	
	jQuery("#bloque").on("jqGridAddEditBeforeSubmit", function(event, object, form, method){
		if(method==='edit'){
			if(jQuery("#bloque_detail_form").valid()){
				var resultado = validarEncuestaBloque();
				if(resultado=="EE"){
					jQuery.rup_messages("msgConfirm", {
						message: $.rup.i18n.app.mensaje.editarBloqueEncuesta,
						title: $.rup.i18nParse($.rup.i18n.base.rup_message,"confirmacion"),
						OKFunction: function() {
							$("#bloque_detail_form").rup_form("ajaxSubmit", {type: "PUT"});
							$("#bloque_detail_div").rup_dialog("close");
							$("#bloque").rup_table("showFeedback", $("#bloque_feedback"), $.rup.i18nParse($.rup.i18n.base,"rup_table.modifyOK"), "ok");
							$("#bloque").rup_table("reloadGrid");
						}
					});
					return false;
				}
			}
		}
	});

	$('#activa_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		open : function() {
			jQuery('#activa_filter-menu').width(jQuery('#activa_filter-button').innerWidth());
		}
	});
	
	$('#obligatorio_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		open : function() {
			jQuery('#obligatorio_filter-menu').width(jQuery('#obligatorio_filter-button').innerWidth());
		}
	});
		
	$('#activaBloque_detail_table').rup_combo({
		source : [
		{
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		ordered: false,
		open : function() {
			jQuery('#activaBloque_detail_table-menu').width(jQuery('#activaBloque_detail_table-button').innerWidth());
		}
	});
		
	jQuery("#obligatorioBloque_detail_table").bootstrapSwitch().bootstrapSwitch('setSizeClass', 'switch-small')
		.bootstrapSwitch('setOnLabel', $.rup.i18n.app.comun.si.toUpperCase())
		.bootstrapSwitch('setOffLabel', $.rup.i18n.app.comun.no.toUpperCase());
	
	$("span.cursor_pointer").remove();
	$("#bloque_filter_toggle_icon1").remove();
	$("#bloque_filter_fieldset").toggle();
	
	$('body').addClass('in');
	
});