function asociarBloques(){
	var datos = { 	 selectedIds: [], selectedAll: false};
	$.extend(true, datos, $('#asociarBloque').rup_table("getSelectedIds"));
	datos.filter = $('#asociarBloque').rup_table("getFilterParams");
	bloquearPantalla();
	$.ajax({
		type: 'POST',
		url: '/y41egGestionWar/bloque/asosiarBloques',
		dataType: 'json',
		contentType: 'application/json',
		data : $.toJSON(datos),
		success:function(){
			desbloquearPantalla();
			$("#bloques_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app,"feedback.asociarBloquesOK"), "ok");
			$("#sortableBloque").rup_sortable("filter");
			$("#divAsociarBloque").dialog("close"); 
		},
		error: function(data){
			$("#bloques_feedback").rup_feedback("set", $.rup.i18nParse($.rup.i18n.app,"feedback.asociarBloquesError"), "error");
			desbloquearPantalla();
			$("#divAsociarBloque").dialog("close"); 
		}
	});	
}

jQuery(function($){
	
	$("#divAsociarBloque").rup_dialog({
        type: $.rup.dialog.DIV,
        autoOpen: false,
        modal: true,
        resizable: true,
        width: "90%",
        title: $.rup.i18n.app.comun.asociarBloque,
		open: function(a, b, c) {
			$("#asociarBloque").rup_table("deselectAllRows");
			$("#asociarBloque").rup_table("filter");
			$("#asociarPregunta").rup_table("filter");
			if(!$("#asociarBloque_filter_fieldset").is(":hidden")){
				$("#asociarBloque_filter_fieldset").toggle();
			}
		},
		buttons: [
			{
				text: $.rup.i18nParse($.rup.i18n.base,"rup_global.aceptar"),
				click: function () {
					if(!$("#asociarBloque").rup_table("isSelected")) {
						alert($.rup.i18n.app.comun.warningSeleccion);
						return false;
					}else{
						asociarBloques();
					}
				}
			},
			{
            text: $.rup.i18n.base.rup_global.cancelar,
            click: function () {
            	$("#divAsociarBloque").dialog("close"); 
            },
            btnType: $.rup.dialog.LINK
        }
		]
	});

	$("#asociarBloque").rup_table({
		
		url: "/y41egGestionWar/bloque",
		toolbar: {
			 id: "asociarBloque_toolbar",
			defaultButtons:{}
		},
		colNames: [
			$.rup.i18nParse($.rup.i18n.app,"tabla.id"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descPublica"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.descInterna"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.obligatorio"),
			$.rup.i18nParse($.rup.i18n.app,"tabla.activa")
		],
		colModel: [
			{ 	name: "idBloque", 
				hidden: true
			},
			{ 	name: "descPubl" + $.rup.lang.capitalize(), 
				align: "", 
				width: "30%",
				index: "DESC_PUBL_" + $.rup.lang.capitalize().toUpperCase() + "_002"
			},
			{ 	name: "descInt" + $.rup.lang.capitalize(), 
				align: "", 
				width: "30%",
				index: "DESC_INT_" + $.rup.lang.capitalize().toUpperCase() + "_002"
			},
			{ 	name: "obligatorio",
				align: "", 
				width: "15%",
				index: "OBLIGATORIO_002",
				formatter: formatterSiNo
			},
			{ 	name: "activa",
				align: "", 
				width: "15%",
				index: "ACTIVA_002",
				formatter: formatterSiNo
			}
        ],

        model:"Y41eBloque",
        usePlugins:[
        	"filter",
        	"multiselection",
        	"fluid"
         	],
		primaryKey: "idBloque",
		sortname: "ID_BLOQUE_002",
		sortorder: "asc",
		loadOnStartUp: false,
        loadComplete:function(){
        	jQuery("#asociarBloque_filter_summary").remove();
        }
	});
	
	$('#obligatorioAsociarBloque_filter').rup_combo({
		source : [ {
			label : $.rup.i18n.app.comun.todos,
			value : ''
		}, {
			label :  $.rup.i18n.app.comun.si.toUpperCase(),
			value : SI
		}, {
			label :  $.rup.i18n.app.comun.no.toUpperCase(),
			value : NO
		} ],
		width: "98%",
		open : function() {
			jQuery('#obligatorioAsociarBloque_filter-menu').width(jQuery('#obligatorioAsociarBloque_filter-button').innerWidth());
		}
	});
	
	jQuery('#descPublAsociarBloque_filter').rup_autocomplete({
		source : "/y41egGestionWar/bloque/suggest",
		sourceParam : {
			label : "descPubl" + jQuery.rup_utils.capitalizedLang()
		},
		extraParams: {
			idEncuesta: function() {
				return jQuery('#idEncuestaAsociar').val();
			},
			tipo : function() {
				return "P";
			}
		},
		getText: true,
		open : function(event, object, arg) {
			 var tam = parseFloat(jQuery('#descPublAsociarBloque_filter').css("padding-left"))+ parseFloat(jQuery('#descPublAsociarBloque_filter').css("padding-right"));
			jQuery('.ui-autocomplete.ui-menu.ui-widget.ui-widget-content.ui-corner-all:visible').css("min-width", jQuery('#descPublAsociarBloque_filter').innerWidth());
		}
	});
	
	jQuery('#descIntAsociarBloque_filter').rup_autocomplete({
		source : "/y41egGestionWar/bloque/suggest",
		sourceParam : {
			label : "descInt" + jQuery.rup_utils.capitalizedLang()
		},
		extraParams: {
			idEncuesta: function() {
				return jQuery('#idEncuestaAsociar').val();
			},
			tipo : function() {
				return "I";
			}
		},
		getText: true,
		open : function(event, object, arg) {
			 var tam = parseFloat(jQuery('#descIntAsociarBloque_filter').css("padding-left"))+ parseFloat(jQuery('#descIntAsociarBloque_filter').css("padding-right"));
			jQuery('.ui-autocomplete.ui-menu.ui-widget.ui-widget-content.ui-corner-all:visible').css("min-width", jQuery('#descIntAsociarBloque_filter').innerWidth());
		}
	});
	
	$("#asociarBloque_filter_cleanLink").off('click');
	$("#asociarBloque_filter_cleanLink").on('click', function(e){
		e.preventDefault();
		$('#asociarBloque').rup_table("cleanFilterForm").rup_table('clearGridData',true);
		$("#idEncuestaAsociar").val($("#idEncuestaDG").val());
		$("#idActivaAsociar").val(SI);
		$("#asociarBloque").rup_table("deselectAllRows");
		$("#asociarBloque").rup_table("filter");
	});
	
	$("span.cursor_pointer").remove();
	$("#asociarBloque_filter_toggle_icon1").remove();
	
});