/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){

	// Evitar conflictos entre Bootstrap y jQueryUI
	$.fn.bootstrapBtn = $.fn.button.noConflict();

	//rastro de migas
	$("#y41egGestionWar_migas").rup_breadCrumb({
		breadCrumb: {
			logOutUrl : "/y41egGestionWar/logout",
			"encuesta" : {
				"i18nCaption" : "gestionarEncuesta",
				"detalleEncuesta": {"i18nCaption":"nueva"},
				"busqEncuestas": {"i18nCaption":"busqEncuestas"},
				"envios" : {"i18nCaption" : "enviosRealizados"}
			 },
			"bloque" : {"i18nCaption" : "gestionarBloques"},
			"pregunta" : {"i18nCaption" : "gestionarPreguntas"},
			"area" : {"i18nCaption" : "area"},
			"origen" : {"i18nCaption" : "origenes"},
			"otrosMant" : {
				"i18nCaption" : "otrosMant",
				"area" : {
					"i18nCaption" : "area"
				},
				"origen":{
					"i18nCaption" : "origenes"
				},
				"configuracion":{
					"i18nCaption" : "configuracion"
				}
			},
			"resultados" : {
				"i18nCaption" : "resultados",
				"encuesta": {"i18nCaption":"encuesta"},
				"destinatario": {"i18nCaption":"destinatario"}
			 },
		}	
	});
	
	//idioma
	$("#y41egGestionWar_language").rup_language({languages: $.rup.AVAILABLE_LANGS_ARRAY, modo: "default"});
	
	//menu
	$("#y41egGestionWar_menu").rup_menu({
		display: ($.rup.LAYOUT === "vertical" ? 'vertical' : 'horizontal')
	});
	if ($.rup.LAYOUT === "mixto") {
		$("#y41egGestionWar_menu_mixto").rup_menu({
			display: 'vertical'
		});
	}
	
	//NAVBAR Menu
	$("#navbarResponsive").rup_navbar();
	
	//pie
	$(".footer [title]").rup_tooltip();
});

$(window).load(function() {
	$(window).off('scroll');
	
	// Suavizar transiciones en enlaces
	$('[data-href]').on('click', function(ev){
		ev.preventDefault();
		ev.stopImmediatePropagation();
		
		var el = $(this);
		$('body').removeClass('in');
		setTimeout(function(){ window.location.href=el.data('href') }, 500);
	});
});