/**
 * Función que devuelve un booleano informando si el parámetro no es vacío.
 * 
 * @param param El parámetro
 * @returns {Boolean} El resultado
 */
function isNotEmpty(param){
	return param != undefined && param != '' && param != null;
}

/**
 * Función que devuelve un booleano informando si el parámetro no es vacío.
 * 
 * @param param El parámetro
 * @returns {Boolean} El resultado
 */
function parseToEmpty(param){
	if(isNotEmpty(param)){
		return param;
	}else{
		return '';
	}
}

/**
 * Función que devuelve un booleano informando si el parámetro es vacío.
 * 
 * @param param El parámetro
 * @returns {Boolean} El resultado
 */
function isEmpty(param){
	return param == undefined || param == '' || param == null;
}

function formatterSiNo(value){
	if(value===SI){
		return $.rup.i18n.app.comun.si.toUpperCase();
	}else{
		return $.rup.i18n.app.comun.no.toUpperCase();
	}
}

function formatterGrafico(value){
	if(value==="B"){
		return "bar";
	}else{
		return "doughnut";
	}
}
