
(function(jQuery) {
	
	jQuery.validator.addMethod("validateVigencia", function(value, element) {
		var fechaInicio = $("#fecVigInicioDG").val();
		var fechaFin = $("#fecVigFinDG").val();
		var periodoResp = $("#periodoRespDG").val();
		
		if((isNotEmpty(fechaInicio)|| isNotEmpty(fechaFin)) && isNotEmpty(periodoResp)){
			return false;
		}
		return true;
	  }
	, $.rup.i18n.app.validaciones.vigencia);
	
	jQuery.validator.addMethod("fechaMayor", function(value, element, params) {
		var $formulario = $(element).parents("form");
		var fechaHasta = value.split("/");
		var fechaDesde = $("[name='"+params+"']", $formulario).val().split("/");
		if(jQuery.rup_utils.capitalizedLang()=="Es"){
			var fechaHastaFormat=new Date(fechaHasta[2],fechaHasta[1],fechaHasta[0]);
			var fechaDesdeFormat=new Date(fechaDesde[2],fechaDesde[1],fechaDesde[0]);
		}else{
			fechaHastaFormat=new Date(fechaHasta[0],fechaHasta[1],fechaHasta[2]);
			fechaDesdeFormat=new Date(fechaDesde[0],fechaDesde[1],fechaDesde[2]);
		}
		if(fechaHasta == ""  || fechaDesde == "" || fechaHastaFormat >= fechaDesdeFormat){
			return true;
		}else{
			return false;
		}
	}, function(params, element) {
		var $formulario = $(element).parents("form");
		var fechaDesde = $("[name='"+params+"']", $formulario).attr("id");
		var labelDesde = $.trim($("label[for='"+fechaDesde+"']", $formulario).text()).replace(/:+$/,'').replace(/^\*+/,'');
		var labelHasta = $.trim($("label[for='"+element.id+"']", $formulario).text()).replace(/:+$/,'').replace(/^\*+/,'');
		return $.validator.format($.rup.i18n.app.validaciones.fechaMayor, labelHasta, labelDesde);
	});
	
	jQuery.validator.addMethod("validateEmail", function(valor) {
		var regex  =/^[_A-Z0-9-]+(.[_A-Z0-9-]+)*@[A-Z0-9-]+(.[A-Z0-9-]+)*(.[A-Z]{2,4})$/i;
		if(valor!=""){
			var listEmail = valor.split(";");
			for(var i =0; i<listEmail.length;i++){
				if(!regex.test(listEmail[i])){
					return false;
				}
			}
			return true;
		} else {
			return true;
		}
	  }
	, $.rup.i18n.base.rup_validate.messages.email);
	
})(jQuery);