package com.ejie.y42b.forms.search;

import java.util.Date;
import java.util.List;

/**
 * SearchForm
 *  
 *
 */
public class SearchForm {

	private String showInactiveEntities;
	private List<String> groupIdList;
	private List<String> entityIdList;
	private String searchType;
	private String name;
	private boolean kontsumoGest;
	private boolean ofertaFormativa;
	private boolean kontsumoNet;
	private boolean consultaWeb;
	private String locationType;
	private String provinciaId;
	private String municipioId;
	private String localidadId;
	private String codigoPostal;
	private String paisId;
	private List<String> labels;
	private Date dateAfter;
	private Date dateBefore;

	/**
	 * Constructor.
	 */
	public SearchForm() {
	}

	/**
	 * Busqueda de items
	 * @param showInactiveEntities showInactiveEntities
	 * @param groupIdList grupo de ids de grupos seleccionados
	 * @param entityIdList grupo de ids de entidad seleccionados
	 * @param searchType Tipo de busqueda
	 * @param name Nombre
	 * @param kontsumoGest kontsumoGest 
	 * @param ofertaFormativa ofertaFormativa
	 * @param kontsumoNet kontsumoNet
	 * @param consultaWeb consultaWeb
	 * @param locationType locationType
	 * @param provinciaId Id de provincia
	 * @param municipioId Id de municipio
	 * @param localidadId Id de localidad
	 * @param codigoPostal Id de codigopostal
	 * @param paisId Id de pais
	 * @param labels Labels
	 * @param dateAfter Fecha despues
	 * @param dateBefore Fecha antes
	 */
	public SearchForm(String showInactiveEntities, List<String> groupIdList,
			List<String> entityIdList, String searchType, String name,
			boolean kontsumoGest, boolean ofertaFormativa, boolean kontsumoNet,
			boolean consultaWeb, String locationType, String provinciaId,
			String municipioId, String localidadId, String codigoPostal,
			String paisId, List<String> labels, Date dateAfter, Date dateBefore) {
		this.showInactiveEntities = showInactiveEntities;
		this.groupIdList = groupIdList;
		this.entityIdList = entityIdList;
		this.searchType = searchType;
		this.name = name;
		this.kontsumoGest = kontsumoGest;
		this.ofertaFormativa = ofertaFormativa;
		this.kontsumoNet = kontsumoNet;
		this.consultaWeb = consultaWeb;
		this.locationType = locationType;
		this.provinciaId = provinciaId;
		this.municipioId = municipioId;
		this.localidadId = localidadId;
		this.codigoPostal = codigoPostal;
		this.paisId = paisId;
		this.labels = labels;
		this.dateAfter = dateAfter;
		this.dateBefore = dateBefore;
	}

	/**
	 * 
	 * @return String
	 */
	public String getShowInactiveEntities() {
		return this.showInactiveEntities;
	}

	/**
	 * 
	 * @param showInactiveEntities String
	 */
	public void setShowInactiveEntities(String showInactiveEntities) {
		this.showInactiveEntities = showInactiveEntities;
	}

	/**
	 * 
	 * @return String
	 */
	public List<String> getGroupIdList() {
		return this.groupIdList;
	}

	/**
	 * 
	 * @param groupIdList String
	 */
	public void setGroupIdList(List<String> groupIdList) {
		this.groupIdList = groupIdList;
	}

	/**
	 * 
	 * @return String
	 */
	public List<String> getEntityIdList() {
		return this.entityIdList;
	}

	/**
	 * 
	 * @param entityIdList String
	 */
	public void setEntityIdList(List<String> entityIdList) {
		this.entityIdList = entityIdList;
	}

	/**
	 * 
	 * @return String
	 */
	public String getSearchType() {
		return this.searchType;
	}

	/**
	 * 
	 * @param searchType String
	 */
	public void setSearchType(String searchType) {
		this.searchType = searchType;
	}

	/**
	 * 
	 * @return String
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * 
	 * @param name String
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 
	 * @return boolean
	 */
	public boolean isKontsumoGest() {
		return this.kontsumoGest;
	}

	/**
	 * 
	 * @param kontsumoGest booean
	 */
	public void setKontsumoGest(boolean kontsumoGest) {
		this.kontsumoGest = kontsumoGest;
	}

	/**
	 * @return String 
	 */
	public boolean isOfertaFormativa() {
		return this.ofertaFormativa;
	}

	/**
	 * 
	 * @param ofertaFormativa boolean
	 */
	public void setOfertaFormativa(boolean ofertaFormativa) {
		this.ofertaFormativa = ofertaFormativa;
	}

	/**
	 * 
	 * @return boolean
	 */
	public boolean isKontsumoNet() {
		return this.kontsumoNet;
	}

	/**
	 * 
	 * @param kontsumoNet boolean
	 */
	public void setKontsumoNet(boolean kontsumoNet) {
		this.kontsumoNet = kontsumoNet;
	}

	/**
	 * 
	 * @return boolean
	 */
	public boolean isConsultaWeb() {
		return this.consultaWeb;
	}

	/**
	 * 
	 * @param consultaWeb boolean
	 */
	public void setConsultaWeb(boolean consultaWeb) {
		this.consultaWeb = consultaWeb;
	}

	/**
	 * 
	 * @return String
	 */
	public String getLocationType() {
		return this.locationType;
	}

	/**
	 * 
	 * @param locationType String
	 */
	public void setLocationType(String locationType) {
		this.locationType = locationType;
	}

	/**
	 * 
	 * @return String
	 */
	public String getProvinciaId() {
		return this.provinciaId;
	}

	/**
	 * 
	 * @param provinciaId String
	 */
	public void setProvinciaId(String provinciaId) {
		this.provinciaId = provinciaId;
	}

	/**
	 * 
	 * @return String
	 */
	public String getMunicipioId() {
		return this.municipioId;
	}

	/**
	 * 
	 * @param municipioId municipioId
	 */
	public void setMunicipioId(String municipioId) {
		this.municipioId = municipioId;
	}

	/**
	 * 
	 * @return String
	 */
	public String getLocalidadId() {
		return this.localidadId;
	}

	/**
	 * 
	 * @param localidadId localidadId
	 */
	public void setLocalidadId(String localidadId) {
		this.localidadId = localidadId;
	}

	/**
	 * 
	 * @return CodigoPostal
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * 
	 * @param codigoPostal String
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * 
	 * @return String
	 */
	public String getPaisId() {
		return this.paisId;
	}

	/**
	 * 
	 * @param paisId String
	 */
	public void setPaisId(String paisId) {
		this.paisId = paisId;
	}

	/**
	 * 
	 * @return String
	 */
	public List<String> getLabels() {
		return this.labels;
	}

	/**
	 * 
	 * @param labels String
	 */
	public void setLabels(List<String> labels) {
		this.labels = labels;
	}

	/**
	 * 
	 * @return String
	 */
	public Date getDateAfter() {
		return this.dateAfter;
	}

	/**
	 * 
	 * @param dateAfter String
	 */
	public void setDateAfter(Date dateAfter) {
		this.dateAfter = dateAfter;
	}

	/**
	 * 
	 * @return String
	 */
	public Date getDateBefore() {
		return this.dateBefore;
	}

	/**
	 * 
	 * @param dateBefore Date
	 */
	public void setDateBefore(Date dateBefore) {
		this.dateBefore = dateBefore;
	}

}
