package com.ejie.y42b.control;

import java.util.Properties;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.security.Credentials;
import com.ejie.y42b.UserPreferences;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.forms.mant.Y42bFormArbol;

/**
 * ConsultasServiceImpl  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/mant")
public class Y42bMantenimientosController {

	private static final Logger logger = LoggerFactory
			.getLogger(Y42bMantenimientosController.class);

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'showMantenimientos'.
	 * 
	 * @param mySession
	 *            HttpSession
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "vista", method = RequestMethod.GET)
	public ModelAndView showContactos(HttpSession mySession, Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));
		Y42bMantenimientosController.logger.debug("controler   /app/vista");

		UserPreferences userPreferences = (UserPreferences) mySession
				.getAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE);
		Y42bFormArbol arbolForm = new Y42bFormArbol();

		if (userPreferences == null) {
			// FIXME Migracion UDA V.2.4.4 (201504) - Cambio para dejar en
			// session atributo UserName
			String userID = (String) mySession.getAttribute("UserName");
			if (userID == null || "".equals(userID)) {
				Authentication authentication = SecurityContextHolder
						.getContext().getAuthentication();
				Credentials credentials = (Credentials) authentication
						.getCredentials();
				userID = credentials.getUserName();
				mySession.setAttribute("UserName", userID);
			}

			userPreferences = new UserPreferences();
			userPreferences.setUserId(userID);
			userPreferences.setUserNombreCompleto(userID);
			userPreferences.setMostrarEntidadesNoActivas(false);
			userPreferences.setNodeActive("G_ROOT");
			mySession.setAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE,
					userPreferences);

			arbolForm.setChkShowEntidadesNoActivas(userPreferences
					.isMostrarEntidadesNoActivas());
			arbolForm
					.setUrlTree("/y42bVistaWar/arbol/ajaxTree?mostrarEntidadesNoActivas=0");

		} else {
			arbolForm.setChkShowEntidadesNoActivas(userPreferences
					.isMostrarEntidadesNoActivas());
			if (userPreferences.isMostrarEntidadesNoActivas()) {
				arbolForm
						.setUrlTree("/y42bVistaWar/arbol/ajaxTree?mostrarEntidadesNoActivas=1");
			} else {
				arbolForm
						.setUrlTree("/y42bVistaWar/arbol/ajaxTree?mostrarEntidadesNoActivas=0");
			}

		}
		Y42bMantenimientosController.logger.debug("Nodo en session: "
				+ userPreferences.getNodeActive());

		arbolForm.setNodeId(userPreferences.getNodeActive());
		model.addAttribute("arbolForm", arbolForm);
		model.addAttribute("userPrefs", userPreferences);

		return new ModelAndView("mantenimientos", "model", model);
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 * 
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		Y42bMantenimientosController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 * 
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * 
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}