package com.ejie.y42b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.UserPreferences;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Y42bFormContacto;
import com.ejie.y42b.model.Y42bTree;
import com.ejie.y42b.service.ContactoService;
import com.ejie.y42b.service.EntidadService;
import com.ejie.y42b.service.EtiquetaService;
import com.ejie.y42b.service.Y42bArbolService;
import com.ejie.y42b.utils.Y42bContactEntityTree;
import com.ejie.y42b.utils.Y42bEtiquetasTree;
import com.ejie.y42b.utils.Y42bUtils;

/**
 * ConsultasServiceImpl  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/contactos")
@SessionAttributes(value = { "contactoForm" })
public class Y42bContactosController {

	private static final Logger logger = LoggerFactory
			.getLogger(Y42bContactosController.class);

	@Autowired()
	private EntidadService entidadService;

	@Autowired()
	private ContactoService contactoService;

	@Autowired()
	private Y42bArbolService arbolService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private EtiquetaService etiquetaService;

	/**
	 * Method 'newContact'.
	 * 
	 * @param entidadId
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/nuevo", method = RequestMethod.GET)
	public ModelAndView newContacto(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			Model model) {

		Y42bContactosController.logger.debug("/contactos/nuevo GET");

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		// Locale locale = LocaleContextHolder.getLocale();

		Y42bFormContacto formContacto = new Y42bFormContacto();
		formContacto.setContactoId("0");
		formContacto.setNombre("");
		formContacto.setCargo("");
		formContacto.setTelefono("");
		formContacto.setFax("");
		formContacto.setEmail("");
		formContacto.setUrl("");
		formContacto.setCalle("");
		formContacto.setPostCode("");
		formContacto.setCodigoPostal("");
		formContacto.setCompleDirec("");

		// Obtener localización de la entidad y asignarsela al contacto nuevo
		// por defecto

		Entidad entidad = new Entidad();
		entidad.setEntidadId(entidadId);
		entidad = this.entidadService.find(entidad);

		if (Y42bAgendaConstantes.SI.equals(entidad.getIsnacional())) {
			formContacto.setLocalizacionInternacional(Y42bAgendaConstantes.NO);
			formContacto.setProvinciaId(entidad.getNoraProvinciaId());
			formContacto.setMunicipioId(entidad.getNoraMunicipioId());
			formContacto.setLocalidadId(entidad.getNoraLocalidadId());
			formContacto.setLocalidad(Y42bUtils.normalizarVacio(entidad
					.getNombreLocalidad()));
			formContacto.setCodigoPostal(Y42bUtils.normalizarVacio(entidad
					.getNombreCp()));
			formContacto.setCalleId(Y42bUtils.normalizarVacio(entidad
					.getNoraCalleId()));
			formContacto.setCalle(Y42bUtils.normalizarVacio(entidad
					.getNombreCalle()));
			formContacto.setPortal(Y42bUtils.normalizarVacio(entidad
					.getNombrePortal()));
			formContacto.setPortalId(Y42bUtils.normalizarVacio(entidad
					.getNoraPortalId()));
			formContacto.setPaisId(Y42bAgendaConstantes.NORA_SPAIN);
		} else {
			formContacto.setLocalizacionInternacional(Y42bAgendaConstantes.SI);
			formContacto.setPaisId(entidad.getNoraPaisId());
			formContacto.setLocalidad(Y42bUtils.normalizarVacio(entidad
					.getNombreLocalidad()));
			formContacto.setCodigoPostal(Y42bUtils.normalizarVacio(entidad
					.getNombreCp()));
			formContacto.setCalle(Y42bUtils.normalizarVacio(entidad
					.getNombreCalle()));
		}

		formContacto.setEntidadId(entidadId);
		formContacto.setEntidades(entidadId);

		model.addAttribute("contactoForm", formContacto);

		return new ModelAndView("mantenimientos_contactos", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param contactoId
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/{contactoId}", method = RequestMethod.GET)
	public ModelAndView getById(@PathVariable() String contactoId, Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		Locale locale = LocaleContextHolder.getLocale();
		Contacto contacto = new Contacto();
		try {
			contacto.setContactoId(contactoId);
			contacto = this.contactoService.find(contacto);

			Etiqueta etiqueta = new Etiqueta();
			contacto = this.contactoService.findEtiquetaContacto(contacto,
					etiqueta, null);

			if (contacto == null) {
				throw new Exception(contactoId.toString());
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(contactoId.toString());
		}

		Y42bFormContacto formContacto = this.getY42bFormContacto(contacto,
				locale);
		model.addAttribute("contactoForm", formContacto);
		Y42bContactosController.logger.debug("controler   /app/mant/contactos");

		return new ModelAndView("mantenimientos_contactos", "model", model);
	}

	/**
	 * Method 'edit'. Guarda la info en base de datos
	 * 
	 * @param pContacto
	 *            Contacto
	 * @param req
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Contacto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Contacto add(@RequestBody() Contacto pContacto, HttpServletRequest req,
			HttpServletResponse response) {
		try {
			Y42bContactosController.logger.debug("/contacto POST");

			UserPreferences userPreferences = (UserPreferences) req
					.getSession().getAttribute(
							Y42bAgendaConstantes.SESSIONBEAN_NODE);
			String usuario = "";
			if (userPreferences != null) {
				usuario = userPreferences.getUserId();
			}
			Contacto contacto = pContacto;
			// Dar de alta
			contacto.setUsuultmod(usuario);
			Entidad entidad = new Entidad();
			entidad.setEntidadId(pContacto.getEntidadId());
			List<Entidad> entidads = new ArrayList<Entidad>();
			entidads.add(entidad);
			contacto.setEntidads(entidads);
			return this.contactoService.add(contacto);

			// response.setStatus(HttpServletResponse.SC_OK);

		} catch (ResourceNotFoundException er) {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(er.getMessage());

		} catch (Exception e) {
			if (e instanceof org.springframework.dao.DuplicateKeyException) {
				response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
				throw new MethodFailureException("Registro duplicado");
			} else {
				response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
				throw new MethodFailureException("Method failed");
			}

		}
	}

	/**
	 * Method 'edit'. Guarda contacto
	 * 
	 * @param etiquetasIds
	 *            String
	 * @param pContacto
	 *            Contacto
	 * @param req
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/{etiquetasIds}/{entidadesIds}", method = RequestMethod.PUT)
	public final void edit(@PathVariable() String etiquetasIds,
			@PathVariable() String entidadesIds,
			@RequestBody() Contacto pContacto, HttpServletRequest req,
			HttpServletResponse response) {

		UserPreferences userPreferences = (UserPreferences) req.getSession()
				.getAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE);
		String usuario = "";
		if (userPreferences != null) {
			usuario = userPreferences.getUserId();
		}

		Contacto contacto = pContacto;

		try {

			List<Etiqueta> etiqLst = new ArrayList<Etiqueta>();
			if (!(etiquetasIds.equalsIgnoreCase(""))) {
				// la lista de etiquetas de la entidad
				String[] etiqList = etiquetasIds.split(",");
				for (int g = 0; g < etiqList.length; g++) {
					Etiqueta etiqueta = new Etiqueta();
					etiqueta.setEtiquetaId(etiqList[g]);
					etiqLst.add(etiqueta);
				}
			}
			contacto.setEtiquetas(etiqLst);

			// lista de entidades + tratamiento para eliminar los ids repetidos
			// de entidad mediante hashmap
			List<Entidad> entidadLst = new ArrayList<Entidad>();
			if (!(entidadesIds.equalsIgnoreCase(""))) {
				// la lista de entidades del contacto
				String[] entidadList = entidadesIds.split(",");

				Map<Integer, String> mapaEntidades = new HashMap<Integer, String>();

				for (int g = 0; g < entidadList.length; g++) {
					if (!(mapaEntidades.containsValue(entidadList[g]))) {
						mapaEntidades.put(g, entidadList[g]);
					}
				}

				Iterator it = mapaEntidades.keySet().iterator();
				String valorEntidadId = "";

				while (it.hasNext()) {
					Integer key = (Integer) it.next();
					valorEntidadId = mapaEntidades.get(key);

					Entidad entidad = new Entidad();
					entidad.setEntidadId(valorEntidadId);
					entidadLst.add(entidad);
				}

			}
			contacto.setEntidads(entidadLst);

			Y42bContactosController.logger.debug("/contactos PUT");
			contacto.setUsuultmod(usuario);
			this.contactoService.update(contacto);
			Y42bContactosController.logger.info("Contact correctly modified!");
			response.setStatus(HttpServletResponse.SC_OK);

		} catch (ResourceNotFoundException er) {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(er.getMessage());

		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			if (e instanceof org.springframework.dao.DuplicateKeyException) {
				throw new ResourceNotFoundException("Registro duplicado");
			}

			throw new MethodFailureException("Method failed");
		}
		// return new ModelAndView("mantenimientos_contactos", "model", model);
	}

	/**
	 * @param entidadId
	 *            String
	 * @param contactoId
	 *            String
	 * @param response
	 *            String
	 */
	@RequestMapping(value = "/{contactoId}", method = RequestMethod.DELETE)
	public void remove(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@PathVariable() String contactoId, HttpServletResponse response) {

		Y42bContactosController.logger.debug("/contactos/{contactoId} DELETE");

		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Contacto contacto = new Contacto();
			contacto.setContactoId(contactoId);

			this.contactoService.removeEntidadContacto(contacto);

			this.contactoService.remove(contacto);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			Y42bContactosController.logger.error("Unable to delete "
					+ contactoId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Loading Main tree de la lista de etiquetas para un determinado contacto
	 * 
	 * @param contactoId
	 *            String
	 * @param etiquetasIdList
	 *            String
	 * @param response
	 *            Response
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "lista", method = RequestMethod.GET)
	public void showListaEtiquetas(
			@RequestParam(value = "contactoId", required = false) String contactoId,
			@RequestParam(value = "etiquetasIdList", required = false) String etiquetasIdList,
			HttpServletResponse response) throws IOException {
		response.setHeader("Cache-Control", "no-cache");
		PrintWriter out = response.getWriter();
		// String node = "";
		List<Etiqueta> lstEtiquetasContacto = null;
		List<String> selectedIdList = new ArrayList<String>();

		// Si contactoId = 0 se trata de un mantenimiento
		// Obtiene lista de etiquetas del sistema

		Pagination pagination = new Pagination();
		pagination.setSort("NOMBRE");
		pagination.setAscDsc("ASC");

		List<Etiqueta> lstEtiquetasCompletas = this.etiquetaService.findAll(
				null, pagination);
		if (!"0".equals(contactoId)) {
			Contacto contacto = new Contacto();

			if (!"-1".equals(contactoId) && !"-2".equals(contactoId)) {
				contacto.setContactoId(contactoId);
				contacto = this.contactoService.find(contacto);
			}

			this.contactoService.findEtiquetaContacto(contacto, new Etiqueta(),
					null);

			// rellenar la lista de etiquetas con las que ya vienen
			// seleccionadas
			if (!etiquetasIdList.equalsIgnoreCase("")) {
				String[] arrIdsEtiquetasSeleccionadas;
				String strDelimitador = ",";
				arrIdsEtiquetasSeleccionadas = etiquetasIdList
						.split(strDelimitador);
				for (int i = 0; i < arrIdsEtiquetasSeleccionadas.length; i++)
					selectedIdList.add(arrIdsEtiquetasSeleccionadas[i]);
			}

			// Obtiene lista de etiquetas de la contacto
			lstEtiquetasContacto = contacto.getEtiquetas();
			for (Etiqueta etiqueta : lstEtiquetasContacto) {
				selectedIdList.add(etiqueta.getEtiquetaId());
			}
		}

		String json = Y42bEtiquetasTree.obtieneJsonArbol(lstEtiquetasCompletas,
				selectedIdList);
		out.println(json);

	}

	/**
	 * Loading contact entity tree.
	 * 
	 * @param contactoId
	 *            contactoId
	 * @param mySession
	 *            Sesion
	 * @param response
	 *            Response
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/entityTree/{contactoId}", method = RequestMethod.GET)
	public void getEntityTree(@PathVariable() String contactoId,
			HttpSession mySession, HttpServletResponse response)
			throws IOException {
		response.setHeader("Cache-Control", "no-cache");
		response.setCharacterEncoding("ISO-8859-1");
		response.setContentType("text/html;charset=utf-8");

		List<String> entidadIdList = new ArrayList<String>();

		// Y42bTree arbol = this.arbolService.obtenerArbol(false);
		Y42bTree arbol = this.arbolService
				.obtenerArbol(Y42bAgendaConstantes.ESTADO_ACTIVAS);

		Contacto contacto = new Contacto();
		List<Entidad> entidadList = null;

		if (contactoId != null && !"0".equals(contactoId)) {
			try {

				contacto.setContactoId(contactoId);
				contacto = this.contactoService.find(contacto);
				contacto = this.contactoService.findEntidadContacto(contacto,
						new Entidad(), null);

				if (contacto == null) {
					throw new Exception(contactoId.toString());
				}
			} catch (Exception e) {
				throw new ResourceNotFoundException(contactoId.toString());
			}

			entidadList = contacto.getEntidads();
			for (Entidad entidad : entidadList) {
				entidadIdList.add(entidad.getEntidadId());
			}
		}

		String json = Y42bContactEntityTree.obtieneJsonArbol(arbol,
				entidadIdList);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param contactoId
	 *            String
	 * @param nombre
	 *            String
	 * @param cargo
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param isnacional
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param compleDirec
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "contactoId", required = false) String contactoId,
			@RequestParam(value = "nombre", required = false) String nombre,
			@RequestParam(value = "cargo", required = false) String cargo,
			@RequestParam(value = "telefono", required = false) String telefono,
			@RequestParam(value = "fax", required = false) String fax,
			@RequestParam(value = "email", required = false) String email,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "isnacional", required = false) String isnacional,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "noraProvinciaId", required = false) String noraProvinciaId,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "noraMunicipioId", required = false) String noraMunicipioId,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "noraLocalidadId", required = false) String noraLocalidadId,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			@RequestParam(value = "compleDirec", required = false) String compleDirec,
			HttpServletRequest request) {
		try {
			Contacto filterContacto = new Contacto(contactoId, nombre, cargo,
					telefono, fax, email, url, isnacional, usuultmod,
					fecultmod, nombrePais, noraProvinciaId, nombreProvincia,
					noraMunicipioId, nombreMunicipio, noraLocalidadId,
					nombreLocalidad, noraCalleId, nombreCalle, noraCpId,
					nombreCp, noraPortalId, nombrePortal, noraPaisId,
					compleDirec);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Contacto> contactos = this.contactoService.findAll(
						filterContacto, pagination);

				if (contactos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.getAllCount(filterContacto, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(contactos);
				return data;
			} else {
				List<Contacto> contactos = this.contactoService.findAll(
						filterContacto, pagination);
				if (contactos == null) {
					throw new Exception("No data Found.");
				}
				return contactos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterContacto
	 *            Contacto
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "contacto", required = false) Contacto filterContacto,
			HttpServletRequest request) {
		try {
			return this.contactoService
					.findAllCount(filterContacto != null ? filterContacto
							: new Contacto());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 * 
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		Y42bContactosController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 * 
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * 
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	// METODOS PRIVADOS //

	/**
	 * @param contactoBean
	 *            Contacto
	 * @param locale
	 *            Locale
	 * @return y42bFormContacto
	 */
	private Y42bFormContacto getY42bFormContacto(Contacto contactoBean,
			Locale locale) {
		Y42bFormContacto formContacto = new Y42bFormContacto();

		if (contactoBean != null) {
			formContacto.setContactoId(contactoBean.getContactoId());
			formContacto.setNombre(contactoBean.getNombre());
			formContacto.setCargo(Y42bUtils.normalizarVacio(contactoBean
					.getCargo()));
			formContacto.setTelefono(Y42bUtils.normalizarVacio(contactoBean
					.getTelefono()));
			formContacto
					.setFax(Y42bUtils.normalizarVacio(contactoBean.getFax()));
			formContacto.setCompleDirec(Y42bUtils.normalizarVacio(contactoBean
					.getCompleDirec()));
			formContacto.setEmail(Y42bUtils.normalizarVacio(contactoBean
					.getEmail()));
			formContacto
					.setUrl(Y42bUtils.normalizarVacio(contactoBean.getUrl()));
			formContacto.setFechaActualizacion(Y42bUtils.parseDateToString(
					contactoBean.getFecultmod(), locale.getLanguage()));
			formContacto.setUsuarioActualizacion(contactoBean.getUsuultmod());

			StringBuffer aux = new StringBuffer();
			String entidades = "";
			for (Entidad entidad : contactoBean.getEntidads()) {
				// entidadIdList.add(entidad.getEntidadId());
				aux.append(entidad.getEntidadId());
				aux.append(",");
			}
			entidades = aux.toString();
			if (entidades.length() > 0) {
				entidades = entidades.substring(0, entidades.length() - 1);
			}
			formContacto.setEntidades(entidades);

			if (Y42bAgendaConstantes.SI.equals(contactoBean.getIsnacional())) {
				formContacto
						.setLocalizacionInternacional(Y42bAgendaConstantes.NO);
				formContacto
						.setProvinciaId((contactoBean.getNoraProvinciaId() == null ? ""
								: contactoBean.getNoraProvinciaId()));
				formContacto
						.setMunicipioId((contactoBean.getNoraMunicipioId() == null ? ""
								: contactoBean.getNoraMunicipioId()));
				formContacto
						.setLocalidadId((contactoBean.getNoraLocalidadId() == null ? ""
								: contactoBean.getNoraLocalidadId()));
				formContacto.setLocalidad(Y42bUtils
						.normalizarVacio(contactoBean.getNombreLocalidad()));
				formContacto
						.setCalleId((contactoBean.getNoraCalleId() == null ? ""
								: contactoBean.getNoraCalleId()));
				formContacto
						.setCalle((contactoBean.getNombreCalle() == null ? ""
								: contactoBean.getNombreCalle()));

				formContacto.setPortal(Y42bUtils.normalizarVacio(contactoBean
						.getNombrePortal()));
				formContacto.setPortalId(Y42bUtils.normalizarVacio(contactoBean
						.getNoraPortalId()));

				formContacto.setCodigoPostal(Y42bUtils
						.normalizarVacio(contactoBean.getNombreCp()));
			} else {
				formContacto
						.setLocalizacionInternacional(Y42bAgendaConstantes.SI);
				formContacto
						.setPaisId((contactoBean.getNoraPaisId() == null ? ""
								: contactoBean.getNoraPaisId()));
				formContacto.setLocalidad(Y42bUtils
						.normalizarVacio(contactoBean.getNombreLocalidad()));
				formContacto.setPostCode(Y42bUtils.normalizarVacio(contactoBean
						.getNombreCp()));
				formContacto.setCodigoPostal(Y42bUtils
						.normalizarVacio(contactoBean.getNombreCp()));
				formContacto.setCalle(Y42bUtils.normalizarVacio(contactoBean
						.getNombreCalle()));
			}

			// Etiquetas
			StringBuffer lstEt = new StringBuffer(
					Y42bAgendaConstantes.BUFFER_50);

			StringBuffer lstEtIds = new StringBuffer(
					Y42bAgendaConstantes.BUFFER_50);

			for (Etiqueta et : contactoBean.getEtiquetas()) {
				lstEt.append(et.getNombre());
				lstEt.append(",");
				lstEtIds.append(et.getEtiquetaId());
				lstEtIds.append(",");

			}
			StringBuffer etiquetasBuff = new StringBuffer("");
			String etiquetas = lstEt.toString();
			if (etiquetas.length() > 0) {
				etiquetas = etiquetas.substring(0, etiquetas.length() - 1);
			}

			etiquetasBuff.append("[");
			etiquetasBuff.append(etiquetas);
			etiquetasBuff.append("]");

			if (lstEtIds.toString().equals("")) {
				formContacto.setEtiquetasIds(",");
			} else {
				formContacto.setEtiquetasIds(lstEtIds.toString());
			}

			formContacto.setEtiquetas(etiquetasBuff.toString());

		}

		return formContacto;
	}

	/**
	 * Method 'unBind' EtiquetaContacto
	 * 
	 * @param contactoId
	 *            String
	 * @param etiquetaEtiquetaId
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindEtiquetaContacto", method = RequestMethod.POST)
	public void unBindEtiquetaContacto(
			@RequestParam(value = "contactoId", required = false) String contactoId,
			@RequestParam(value = "etiquetaEtiquetaId", required = false) String etiquetaEtiquetaId) {
		Contacto contacto = new Contacto();
		Etiqueta etiqueta = new Etiqueta();
		if (contactoId != null) {
			contacto.setContactoId(contactoId);
		}
		if (etiquetaEtiquetaId != null) {
			etiqueta.setEtiquetaId(etiquetaEtiquetaId);
		}
		contacto.getEtiquetas().add(etiqueta);
		this.contactoService.removeEtiquetaContacto(contacto);
	}

	/**
	 * Method 'bind' EtiquetaContacto
	 * 
	 * @param contactoId
	 *            String
	 * @param etiquetaEtiquetaId
	 *            String
	 */
	@RequestMapping(value = "/bindEtiquetaContacto", method = RequestMethod.POST)
	public void bindEtiquetaContacto(
			@RequestParam(value = "contactoId", required = false) String contactoId,
			@RequestParam(value = "etiquetaEtiquetaId", required = false) String etiquetaEtiquetaId) {
		Contacto contacto = new Contacto();
		Etiqueta etiqueta = new Etiqueta();
		if (contactoId != null) {
			contacto.setContactoId(contactoId);
		}
		if (etiquetaEtiquetaId != null) {
			etiqueta.setEtiquetaId(etiquetaEtiquetaId);
		}
		contacto.getEtiquetas().add(etiqueta);
		this.contactoService.addEtiquetaContacto(contacto);
	}
}