package com.ejie.y42b.control;

import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.TipoOrganismo;
import com.ejie.y42b.service.TipoOrganismoService;

/**
 * * TipoOrganismoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tipoorganismo")
public class TipoOrganismoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoOrganismoController.class);

	@Autowired()
	private TipoOrganismoService tipoOrganismoService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getAll'.
	 * 
	 * @param torcodigo
	 *            String
	 * @param tornombre
	 *            String
	 * @param tornombree
	 *            String
	 * @param tornombrei
	 *            String
	 * @param tornombref
	 *            String
	 * @param tornombrea
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "torcodigo", required = false) String torcodigo,
			@RequestParam(value = "tornombre", required = false) String tornombre,
			@RequestParam(value = "tornombree", required = false) String tornombree,
			@RequestParam(value = "tornombrei", required = false) String tornombrei,
			@RequestParam(value = "tornombref", required = false) String tornombref,
			@RequestParam(value = "tornombrea", required = false) String tornombrea,
			HttpServletRequest request) {
		try {
			TipoOrganismo filterTipoOrganismo = new TipoOrganismo(torcodigo,
					tornombre, tornombree, tornombrei, tornombref, tornombrea);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipoOrganismo> listTipoOrganismo = this.tipoOrganismoService
						.findAll(filterTipoOrganismo, pagination);

				if (listTipoOrganismo == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.tipoOrganismoService
						.findAllCount(filterTipoOrganismo);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listTipoOrganismo);
				return data;
			} else {
				List<TipoOrganismo> listTipoOrganismo = this.tipoOrganismoService
						.findAll(filterTipoOrganismo, pagination);
				if (listTipoOrganismo == null) {
					throw new Exception("No data Found.");
				}
				return listTipoOrganismo;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param torcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{torcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	TipoOrganismo getById(@PathVariable() String torcodigo) {
		try {
			TipoOrganismo tipoOrganismo = new TipoOrganismo();
			tipoOrganismo.setTorcodigo(torcodigo);

			tipoOrganismo = this.tipoOrganismoService.find(tipoOrganismo);
			if (tipoOrganismo == null) {
				throw new Exception(torcodigo.toString());
			}
			return tipoOrganismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(torcodigo.toString());
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		TipoOrganismoController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
