package com.ejie.y42b.control;

import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.y42b.model.Entidad;

/**
 * * EntidadController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/sample")
public class SampleController {

	private static final Logger logger = LoggerFactory
			.getLogger(SampleController.class);

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));
		return new ModelAndView("sample", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "blob", method = RequestMethod.GET)
	public ModelAndView getCreateFormBlob(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		this.goBlob();
		return new ModelAndView("sample", "model", model);
	}

	/**
	 * 
	 * @param model
	 *            x
	 * @return x
	 */
	@RequestMapping(value = "sendMail", method = RequestMethod.GET)
	public ModelAndView getCreateFormJMail(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		return new ModelAndView("sample", "model", model);
	}

	/**
	 * 
	 * @param model
	 *            x
	 * @return x
	 */
	@RequestMapping(value = "sendMail", method = RequestMethod.POST)
	public ModelAndView getSendJMail(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		try {
			// this.envioService.procesoEnviosMail();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return new ModelAndView("sample", "model", model);
	}

	/**
	 * Method 'add'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Envio
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Entidad add(@RequestBody() Entidad entidad) {
		try {
			// Envio envioAux = this.envioService.add(envio);
			Entidad aux = entidad;
			aux.setEntidadId("9999");
			SampleController.logger.info("Entity correctly inserted!");
			return aux;

		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * 
	 */
	private void goBlob() {

		// Adjunto adjunto=new Adjunto();
		// byte[] object=null;
		// adjuntoDao.updateBlob(object, adjunto);

	}

}
