package com.ejie.y42b.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.security.Credentials;
import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.y42b.UserPreferences;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.forms.mant.Y42bFormArbol;
import com.ejie.y42b.model.Adjunto;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Envio;
import com.ejie.y42b.model.EnvioSeguimiento;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Grupo;
import com.ejie.y42b.model.Item;
import com.ejie.y42b.model.Y42bFormAccionesMasivas;
import com.ejie.y42b.model.Y42bFormSobres;
import com.ejie.y42b.model.Y42bFormSobres.DatosEtiquetas;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.service.AdjuntoService;
import com.ejie.y42b.service.ContactoService;
import com.ejie.y42b.service.EntidadService;
import com.ejie.y42b.service.EnvioService;
import com.ejie.y42b.service.ItemService;
import com.ejie.y42b.service.Y42bGruposService;
import com.ejie.y42b.utils.Y42bUtils;
import com.ejie.y42b.utils.jms.Y42bClientEnvioMailJMS;

/**
 * * EnvioController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/envio")
public class EnvioController {

	private static final Logger logger = LoggerFactory
			.getLogger(EnvioController.class);

	/**
    *
    */
	@Autowired()
	private EnvioService envioService;

	/**
    *
    */
	@Autowired()
	private EntidadService entidadService;

	/**
    *
    */
	@Autowired()
	private ContactoService contactoService;

	/**
     *
     */
	@Autowired()
	private ItemService itemService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y42bGruposService gruposService;

	@Autowired()
	private AdjuntoService adjuntoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bTestWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bTestWar.default.layout"));
		model.addAttribute("URL_ENVIO_CONFIRMACION",
				this.appConfiguration.get("URL_ENVIO_CONFIRMACION"));

		return new ModelAndView("envio", "model", model);
	}

	/**
	 * 
	 * @param mySession
	 *            HttpSession
	 * @param model
	 *            Model
	 * @return Model
	 */
	@RequestMapping(value = "/seguimiento", method = RequestMethod.GET)
	public ModelAndView getCreateFormSeguimientos(HttpSession mySession,
			Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bTestWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bTestWar.default.layout"));
		model.addAttribute("URL_ENVIO_CONFIRMACION",
				this.appConfiguration.get("URL_ENVIO_CONFIRMACION"));

		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		UserPreferences userPreferences = (UserPreferences) mySession
				.getAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE);
		Y42bFormArbol arbolForm = new Y42bFormArbol();

		if (userPreferences == null) {
			// FIXME Migracion UDA V.2.4.4 (201504) - Cambio para dejar en
			// session atributo UserName
			String userID = (String) mySession.getAttribute("UserName");
			if (userID == null || "".equals(userID)) {
				Authentication authentication = SecurityContextHolder
						.getContext().getAuthentication();
				Credentials credentials = (Credentials) authentication
						.getCredentials();
				userID = credentials.getUserName();
				mySession.setAttribute("UserName", userID);
			}

			userPreferences = new UserPreferences();
			userPreferences.setUserId(userID);
			userPreferences.setUserNombreCompleto(userID);
			userPreferences.setMostrarEntidadesNoActivas(false);
			userPreferences.setNodeActive("G_ROOT");
			mySession.setAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE,
					userPreferences);

			arbolForm.setChkShowEntidadesNoActivas(userPreferences
					.isMostrarEntidadesNoActivas());
			arbolForm
					.setUrlTree("/y42bVistaWar/arbol/ajaxTree?mostrarEntidadesNoActivas=0");

		} else {
			arbolForm.setChkShowEntidadesNoActivas(userPreferences
					.isMostrarEntidadesNoActivas());
			if (userPreferences.isMostrarEntidadesNoActivas()) {
				arbolForm
						.setUrlTree("/y42bVistaWar/arbol/ajaxTree?mostrarEntidadesNoActivas=1");
			} else {
				arbolForm
						.setUrlTree("/y42bVistaWar/arbol/ajaxTree?mostrarEntidadesNoActivas=0");
			}

		}
		EnvioController.logger.debug("Nodo en session: "
				+ userPreferences.getNodeActive());

		arbolForm.setNodeId(userPreferences.getNodeActive());
		model.addAttribute("arbolForm", arbolForm);
		model.addAttribute("userPrefs", userPreferences);

		return new ModelAndView("seguimiento", "model", model);
	}

	/**
	 * Method 'loadMassiveAction'.
	 * 
	 * @param envioId
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "accionesmasivas/{envioId}", method = RequestMethod.GET)
	public ModelAndView loadMassiveAction(@PathVariable() String envioId,
			Model model) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		Y42bFormAccionesMasivas formAccMasivas = new Y42bFormAccionesMasivas();
		formAccMasivas.setIdEnvio(envioId);
		model.addAttribute("accionesForm", formAccMasivas);
		return new ModelAndView("massiveAction", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param envioId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{envioId}", method = RequestMethod.GET)
	public @ResponseBody()
	Envio getById(@PathVariable() String envioId) {
		try {
			Envio envio = new Envio();
			envio.setEnvioId(envioId);
			envio = this.envioService.find(envio);
			if (envio == null) {
				throw new Exception(envioId.toString());
			}

			if (envio.getDireccionOrigen() == null) {
				Properties prop = Y42bUtils
						.loadProperties(Y42bAgendaConstantes.CONFIG_PATH);
				String direccionOrigen = prop.getProperty("mail_fromAddress");
				envio.setDireccionOrigen(direccionOrigen);
			}

			return envio;
		} catch (Exception e) {
			throw new ResourceNotFoundException(envioId.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param envioId
	 *            String
	 * @param sessionOid
	 *            String
	 * @param tipo
	 *            String
	 * @param xmlimportado
	 *            String
	 * @param mailingTemplate
	 *            String
	 * @param mailingAsunto
	 *            String
	 * @param fechaOperacion
	 *            Date
	 * @param tipoOperacion
	 *            String
	 * @param xmlnombrecampo1
	 *            String
	 * @param xmlnombrecampo2
	 *            String
	 * @param xmlnombrecampo3
	 *            String
	 * @param xmlnombrecampo4
	 *            String
	 * @param xmlnombrecampo5
	 *            String
	 * @param xmlnombrecampo6
	 *            String
	 * @param xmlnombrecampo7
	 *            String
	 * @param xmlnombrecampo8
	 *            String
	 * @param xmlnombrecampo9
	 *            String
	 * @param xmlnombrecampo10
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "envioId", required = false) String envioId,
			@RequestParam(value = "sessionOid", required = false) String sessionOid,
			@RequestParam(value = "tipo", required = false) String tipo,
			@RequestParam(value = "xmlimportado", required = false) String xmlimportado,
			@RequestParam(value = "mailingTemplate", required = false) String mailingTemplate,
			@RequestParam(value = "mailingAsunto", required = false) String mailingAsunto,
			@RequestParam(value = "fechaOperacion", required = false) Date fechaOperacion,
			@RequestParam(value = "tipoOperacion", required = false) String tipoOperacion,
			@RequestParam(value = "xmlnombrecampo1", required = false) String xmlnombrecampo1,
			@RequestParam(value = "xmlnombrecampo2", required = false) String xmlnombrecampo2,
			@RequestParam(value = "xmlnombrecampo3", required = false) String xmlnombrecampo3,
			@RequestParam(value = "xmlnombrecampo4", required = false) String xmlnombrecampo4,
			@RequestParam(value = "xmlnombrecampo5", required = false) String xmlnombrecampo5,
			@RequestParam(value = "xmlnombrecampo6", required = false) String xmlnombrecampo6,
			@RequestParam(value = "xmlnombrecampo7", required = false) String xmlnombrecampo7,
			@RequestParam(value = "xmlnombrecampo8", required = false) String xmlnombrecampo8,
			@RequestParam(value = "xmlnombrecampo9", required = false) String xmlnombrecampo9,
			@RequestParam(value = "xmlnombrecampo10", required = false) String xmlnombrecampo10,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			HttpServletRequest request) {
		try {
			Envio filterEnvio = new Envio(envioId, sessionOid, tipo,
					xmlimportado, mailingTemplate, mailingAsunto,
					fechaOperacion, tipoOperacion, xmlnombrecampo1,
					xmlnombrecampo2, xmlnombrecampo3, xmlnombrecampo4,
					xmlnombrecampo5, xmlnombrecampo6, xmlnombrecampo7,
					xmlnombrecampo8, xmlnombrecampo9, xmlnombrecampo10,
					usuultmod, fecultmod, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Envio> envios = this.envioService.findAll(filterEnvio,
						pagination);

				if (envios == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.getAllCount(filterEnvio, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(envios);
				return data;
			} else {
				List<Envio> envios = this.envioService.findAll(filterEnvio,
						pagination);
				if (envios == null) {
					throw new Exception("No data Found.");
				}
				return envios;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param envioId
	 *            String
	 * @param sessionOid
	 *            String
	 * @param tipo
	 *            String
	 * @param xmlimportado
	 *            String
	 * @param mailingTemplate
	 *            String
	 * @param mailingAsunto_
	 *            String
	 * @param fechaOperacion
	 *            Date
	 * @param tipoOperacion
	 *            String
	 * @param xmlnombrecampo1
	 *            String
	 * @param xmlnombrecampo2
	 *            String
	 * @param xmlnombrecampo3
	 *            String
	 * @param xmlnombrecampo4
	 *            String
	 * @param xmlnombrecampo5
	 *            String
	 * @param xmlnombrecampo6
	 *            String
	 * @param xmlnombrecampo7
	 *            String
	 * @param xmlnombrecampo8
	 *            String
	 * @param xmlnombrecampo9
	 *            String
	 * @param xmlnombrecampo10
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param y42SeguimientoDesde
	 *            Date
	 * @param y42SeguimientoHasta
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "segui", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllSeguimiento(
			@RequestParam(value = "envioId", required = false) String envioId,
			@RequestParam(value = "sessionOid", required = false) String sessionOid,
			@RequestParam(value = "tipo", required = false) String tipo,
			@RequestParam(value = "xmlimportado", required = false) String xmlimportado,
			@RequestParam(value = "mailingTemplate", required = false) String mailingTemplate,
			@RequestParam(value = "mailingAsunto", required = false) String mailingAsunto_,
			@RequestParam(value = "fechaOperacion", required = false) Date fechaOperacion,
			@RequestParam(value = "tipoOperacion", required = false) String tipoOperacion,
			@RequestParam(value = "xmlnombrecampo1", required = false) String xmlnombrecampo1,
			@RequestParam(value = "xmlnombrecampo2", required = false) String xmlnombrecampo2,
			@RequestParam(value = "xmlnombrecampo3", required = false) String xmlnombrecampo3,
			@RequestParam(value = "xmlnombrecampo4", required = false) String xmlnombrecampo4,
			@RequestParam(value = "xmlnombrecampo5", required = false) String xmlnombrecampo5,
			@RequestParam(value = "xmlnombrecampo6", required = false) String xmlnombrecampo6,
			@RequestParam(value = "xmlnombrecampo7", required = false) String xmlnombrecampo7,
			@RequestParam(value = "xmlnombrecampo8", required = false) String xmlnombrecampo8,
			@RequestParam(value = "xmlnombrecampo9", required = false) String xmlnombrecampo9,
			@RequestParam(value = "xmlnombrecampo10", required = false) String xmlnombrecampo10,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			@RequestParam(value = "y42SeguimientoDesde", required = false) String y42SeguimientoDesde,
			@RequestParam(value = "y42SeguimientoHasta", required = false) String y42SeguimientoHasta,

			HttpServletRequest request) {
		try {

			// normalizacion de mailingAsunto y fechas para BBDD
			Locale locale = LocaleContextHolder.getLocale();

			String mailingAsunto = ("".equals(mailingAsunto_)) ? null
					: mailingAsunto_;

			Date dateFrom = Y42bUtils.parseDate(y42SeguimientoDesde, locale);
			Date dateTo = Y42bUtils.parseDate(y42SeguimientoHasta, locale);

			Calendar dateDesde = Calendar.getInstance();
			Calendar dateHasta = Calendar.getInstance();

			if (dateFrom != null) {
				dateDesde.setTime(dateFrom);
			}
			if (dateTo != null) {
				dateHasta.setTime(dateTo);
				dateHasta.set(Calendar.HOUR_OF_DAY, 23);
				dateHasta.set(Calendar.MINUTE, 59);
				dateHasta.set(Calendar.SECOND, 59);
				dateHasta.set(Calendar.MILLISECOND, 999); // credit to f1sh
			}

			Envio filterEnvio = new Envio(envioId, sessionOid, tipo,
					xmlimportado, mailingTemplate, mailingAsunto,
					fechaOperacion, tipoOperacion, xmlnombrecampo1,
					xmlnombrecampo2, xmlnombrecampo3, xmlnombrecampo4,
					xmlnombrecampo5, xmlnombrecampo6, xmlnombrecampo7,
					xmlnombrecampo8, xmlnombrecampo9, xmlnombrecampo10,
					usuultmod, fecultmod, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EnvioSeguimiento> envios = this.envioService
						.findAllLikeSeguimiento(filterEnvio, pagination, false,
								dateDesde.getTime(), dateHasta.getTime());

				if (envios == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.envioService.findAllLikeSeguimientoCount(
						filterEnvio, null, false, dateDesde.getTime(),
						dateHasta.getTime());
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(envios);
				return data;
			} else {
				List<EnvioSeguimiento> envios = this.envioService
						.findAllLikeSeguimiento(filterEnvio, pagination, false,
								dateDesde.getTime(), dateHasta.getTime());
				if (envios == null) {
					throw new Exception("No data Found.");
				}
				return envios;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEnvio
	 *            Envio
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "envio", required = false) Envio filterEnvio,
			HttpServletRequest request) {
		try {
			return this.envioService
					.findAllCount(filterEnvio != null ? filterEnvio
							: new Envio());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * 
	 * @param envioId
	 *            envioId
	 * @return getItemCount
	 */
	@RequestMapping(value = "/{envioId}/itemsCount", method = RequestMethod.GET)
	public @ResponseBody()
	long getItemsCount(@PathVariable() String envioId) {

		EnvioController.logger.debug("**************** envioId::: " + envioId);
		Envio envio = new Envio();

		if (envioId != null) {

			envio.setEnvioId(envioId);
		}
		Item item = new Item();
		item.setEnvio(envio);
		item.setSeleccionado(Y42bAgendaConstantes.SI);

		// this.logger.debug("**************** OUTPUT::: " +
		// this.itemService.findAllCount(item);
		// /System.out.println("lg: " + this.itemService.findAllCount(item));
		return this.itemService.findAllCount(item);

	}

	/**
	 * Method 'edit'.
	 * 
	 * @param envio
	 *            Envio
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return Envio
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Envio edit(@RequestBody() Envio envio, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			// Cambio para meter horas/minutos/segundos en fecha operacion
			envio.setFechaOperacion(Calendar.getInstance().getTime());

			// ///////////////////////////////////////////////////////////////////
			// recuperar contactos asociados a las entidades y agregarlos como
			// items
			if (envio.getEnvioAContactos().equalsIgnoreCase(
					Y42bAgendaConstantes.SI)) {

				Item item = new Item();
				item.setEnvio(envio);

				List<Item> listaItems = this.itemService.findAllLike(item,
						null, false);

				// 1.- Recuperar las entidades seleccionadas que son items del
				// envio
				List<Entidad> entidades = new ArrayList<Entidad>();
				if (listaItems.size() > 0) {
					for (int i = 0; i < listaItems.size(); i++) {
						Item itemTemp = (Item) listaItems.get(i);

						if (itemTemp.getSeleccionado().equalsIgnoreCase(
								Y42bAgendaConstantes.SI)) {
							Entidad entidad = new Entidad();
							entidad.setEntidadId(itemTemp.getItemRef());
							entidades.add(entidad);
						}

					}
					// 2.- Recuperar sus contactos y agregarlos como items al
					// envio
					this.searchAndAddContactItems(entidades, null, null, null,
							null, null, envio);
				}
			}
			// ///////////////////////////////////////////////////////////////////

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			String usuarioConectado = (String) httpSession
					.getAttribute(Y42bAgendaConstantes.SESSIONOMBREUSUARIOCONECTADO);

			envio.setRemitenteEnvio(usuarioConectado);
			Envio envioAux = this.envioService.update(envio);
			EnvioController.logger.info("Entity correctly inserted!");

			// Enviar un mensaje a la cola por cada destinatario
			Item itemAux = new Item();
			itemAux.setEnvio(envio);
			List<Item> lstItems = this.itemService.findAllMailsPendientes(
					itemAux, null);

			StringBuffer strMensaje = new StringBuffer();
			if (lstItems.size() > 0) {
				for (int i = 0; i < lstItems.size(); i++) {
					Item itemTemp = (Item) lstItems.get(i);
					strMensaje = new StringBuffer();
					strMensaje.append(itemTemp.getItemRef()).append("###")
							.append(itemTemp.getEnvio().getEnvioId());
					Y42bClientEnvioMailJMS.sendMessage(strMensaje.toString());
				}
			}

			return envioAux;
		} catch (ResourceNotFoundException er) {
			throw new ResourceNotFoundException(er.getMessage());
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Envio add(@RequestBody() Envio envio) {
		try {
			Envio envioAux = this.envioService.add(envio);
			EnvioController.logger.info("Entity correctly inserted!");
			return envioAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param envioId
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{envioId}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String envioId,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Envio envio = new Envio();
			envio.setEnvioId(envioId);
			this.envioService.remove(envio);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			EnvioController.logger.error("Unable to delete " + envioId);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param envioIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> envioIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Envio> envioList = new ArrayList<Envio>();
		try {
			Envio envio = new Envio();
			for (ArrayList<String> envioId : envioIds) {
				Iterator<String> iterator = envioId.iterator();

				envio.setEnvioId(ObjectConversionManager.convert(
						iterator.next(), String.class));
				envioList.add(envio);
			}
			this.envioService.removeMultiple(envioList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'changeAppAccess'.
	 * 
	 * @param envioId
	 *            envioId
	 * @param kontsumoGest
	 *            kontsumoGest
	 * @param ofertaFormativa
	 *            ofertaFormativa
	 * @param kontsumoNet
	 *            kontsumoNet
	 * @param consultaWeb
	 *            consultaWeb
	 * @param response
	 *            Response
	 */
	@RequestMapping(value = "changeAppAccess", method = RequestMethod.GET)
	public void changeAppAccess(
			@RequestParam(value = "envioId", required = true) String envioId,
			@RequestParam(value = "kontsumoGest", required = false) String kontsumoGest,
			@RequestParam(value = "ofertaFormativa", required = false) String ofertaFormativa,
			@RequestParam(value = "kontsumoNet", required = false) String kontsumoNet,
			@RequestParam(value = "consultaWeb", required = false) String consultaWeb,
			HttpServletResponse response) {
		try {
			// this.getIdList(entityIdList);

			Envio envio = new Envio();
			envio.setEnvioId(envioId);

			envio = this.envioService.find(envio);

			String tipoItem = envio.getTipo();

			Item item = new Item();
			item.setEnvio(envio);
			item.setSeleccionado(Y42bAgendaConstantes.SI);

			List<Item> lstItems = this.itemService.findAll(item, null);
			String id = "";
			Entidad entidad = new Entidad();
			for (Item itemloop : lstItems) {
				id = itemloop.getItemRef();
				if (Y42bAgendaConstantes.ENTIDAD.equals(tipoItem)) {
					// Busca datos entidad

					entidad.setEntidadId(id);
					entidad = this.entidadService.find(entidad);
					entidad.setIsconsultasweb(consultaWeb);
					entidad.setIskontsumogest(kontsumoGest);
					entidad.setIskontsumonet(kontsumoNet);
					entidad.setIsofertaform(ofertaFormativa);
					// Actualiza datos entidad
					this.entidadService.updateEntidadSinValidacion(entidad);
				}
			}
			envio.setFechaOperacion(Calendar.getInstance().getTime());
			envio.setTipoOperacion(Y42bAgendaConstantes.TIPO_OP_MASIVA_1);
			envio.setMailingAsunto(" ");
			this.envioService.update(envio);

			response.setStatus(HttpServletResponse.SC_OK);
			EnvioController.logger
					.info("changeEntityStatus execution completed.");
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(e.getMessage());
		}
	}

	/**
	 * Method 'changeEntityStatus'.
	 * 
	 * @param envioId
	 *            envioId
	 * @param active
	 *            Activas
	 * @param response
	 *            Response
	 */
	@RequestMapping(value = "changeEntityStatus", method = RequestMethod.GET)
	public void changeEntityStatus(
			@RequestParam(value = "envioId", required = true) String envioId,
			@RequestParam(value = "active", required = false) String active,
			HttpServletResponse response) {
		try {
			Envio envio = new Envio();
			envio.setEnvioId(envioId);
			envio = this.envioService.find(envio);

			String tipoItem = envio.getTipo();

			Item item = new Item();
			item.setEnvio(envio);
			item.setSeleccionado(Y42bAgendaConstantes.SI);

			List<Item> lstItems = this.itemService.findAll(item, null);
			String id = "";
			Entidad entidad = new Entidad();
			for (Item itemloop : lstItems) {
				id = itemloop.getItemRef();
				if (Y42bAgendaConstantes.ENTIDAD.equals(tipoItem)) {
					// Busca datos entidad
					entidad.setEntidadId(id);
					entidad = this.entidadService.find(entidad);
					entidad.setActiva(active);
					// Actualiza datos entidad
					this.entidadService.updateEntidadSinValidacion(entidad);
				}
			}
			envio.setFechaOperacion(Calendar.getInstance().getTime());
			envio.setTipoOperacion(Y42bAgendaConstantes.TIPO_OP_MASIVA_2);
			envio.setMailingAsunto(" ");
			this.envioService.update(envio);

			response.setStatus(HttpServletResponse.SC_OK);
			EnvioController.logger
					.info("changeEntityStatus execution completed.");
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(e.getMessage());
		}
	}

	/**
	 * Method 'loadMassiveAction'.
	 * 
	 * @param envioId
	 *            envioId
	 * @param tipoImpresion
	 *            tipoImpression
	 * @param model
	 *            Model
	 * 
	 * @return String
	 */
	@RequestMapping(value = "etiquetas/{envioId}/{tipoImpresion}", method = RequestMethod.GET)
	public ModelAndView loadEtiquetas(@PathVariable() String envioId,
			@PathVariable() String tipoImpresion, Model model) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		Locale locale = LocaleContextHolder.getLocale();

		Envio envio = new Envio();
		envio.setEnvioId(envioId);
		envio = this.envioService.find(envio);

		String tipoDatos = envio.getTipo(); // E- Entidad, C- Contacto

		// M - MAILING ESTATICO, D - MAILING DINAMICO, E - EXCEL, L - ETIQUETAS,
		// O - OPERACION MASIVA 1, B - OPERACION MASIVA 2

		// String tipo_operacion = envio.getTipoOperacion();

		Item item = new Item();
		item.setSeleccionado(Y42bAgendaConstantes.SI);
		item.setEnvio(envio);

		List<Item> lstItems = this.itemService.findAll(item, null);

		Y42bFormSobres sobres = new Y42bFormSobres();
		sobres.setTipoEtiquetas(tipoImpresion);

		if (Y42bAgendaConstantes.TIPO_ETIQUETAS_3X8.equals(tipoImpresion)) {
			sobres.setFilasEtiquetas(Y42bAgendaConstantes.NUM_8);
			sobres.setColumnasEtiquetas(Y42bAgendaConstantes.NUM_3);
		} else if (Y42bAgendaConstantes.TIPO_ETIQUETAS_2X8
				.equals(tipoImpresion)) {
			sobres.setFilasEtiquetas(Y42bAgendaConstantes.NUM_8);
			sobres.setColumnasEtiquetas(Y42bAgendaConstantes.NUM_2);
		} else {
			throw new ResourceNotFoundException("Error en el tipo de etiqueta");
		}

		DatosEtiquetas dt = null;
		String nombre = "";
		String direccion = "";
		String localidad = "";
		String codigopostal = "";
		Entidad entidad = new Entidad();
		Contacto contacto = new Contacto();

		for (Item itemEtiq : lstItems) {

			if (Y42bAgendaConstantes.ENTIDAD.equals(tipoDatos)) {

				entidad.setEntidadId(itemEtiq.getItemRef());
				entidad = this.entidadService.find(entidad);

				if (Y42bAgendaConstantes.EUSKERA.equals(locale.getLanguage())) {
					nombre = entidad.getNombreEu();
				} else {
					nombre = entidad.getNombreEs();
				}

				if (Y42bAgendaConstantes.SI.equals(entidad.getIsnacional())) {
					direccion = (entidad.getNombreCalle() != null ? entidad
							.getNombreCalle() : "")
							+ " "
							+ (entidad.getNombrePortal() != null ? entidad
									.getNombrePortal() : "");
				} else {
					direccion = (entidad.getNombreCalle() != null ? entidad
							.getNombreCalle() : "");
				}

				localidad = (entidad.getNombreLocalidad() != null ? entidad
						.getNombreLocalidad() : "");
				codigopostal = (entidad.getNombreCp() != null ? entidad
						.getNombreCp() : "");

			}

			if (Y42bAgendaConstantes.CONTACTO.equals(tipoDatos)) {

				contacto.setContactoId(itemEtiq.getItemRef());
				contacto = this.contactoService.find(contacto);

				nombre = contacto.getNombre();
				if (Y42bAgendaConstantes.SI.equals(contacto.getIsnacional())) {
					direccion = (contacto.getNombreCalle() != null ? contacto
							.getNombreCalle() : "")
							+ " "
							+ (contacto.getNombrePortal() != null ? contacto
									.getNombrePortal() : "");
				} else {
					direccion = contacto.getNombreCalle();
				}
				localidad = (contacto.getNombreLocalidad() != null ? contacto
						.getNombreLocalidad() : "");
				codigopostal = (contacto.getNombreCp() != null ? contacto
						.getNombreCp() : "");

			}

			dt = null;
			dt = sobres.datosEtiquetas();
			dt.setNombre(nombre);
			dt.setDireccion(direccion);
			dt.setLocalidad(localidad);
			dt.setCodigopostal(codigopostal);
			sobres.addDatos(dt);

		}
		model.addAttribute("sobresForm", sobres);

		return new ModelAndView("sobres", "model", model);
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		EnvioController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEnvioService'.
	 * 
	 * @return EnvioService
	 */
	protected EnvioService getEnvioService() {
		return this.envioService;
	}

	/**
	 * Method 'setEnvioService'.
	 * 
	 * @param envioService
	 *            EnvioService
	 * @return
	 */
	public void setEnvioService(EnvioService envioService) {
		this.envioService = envioService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'changeEntityStatus'.
	 * 
	 * @param envioId
	 *            envioId
	 * @param listaGrupos
	 *            String
	 * @param response
	 *            Response
	 */
	@RequestMapping(value = "changeAsociarEntidadesAGrupo", method = RequestMethod.GET)
	public void changeAsociarEntidadesAGrupo(
			@RequestParam(value = "envioId", required = true) String envioId,
			@RequestParam(value = "listaGrupos", required = false) String listaGrupos,
			HttpServletResponse response) {
		try {
			Envio envio = new Envio();
			envio.setEnvioId(envioId);
			envio = this.envioService.find(envio);

			String tipoItem = envio.getTipo();

			Item item = new Item();
			item.setEnvio(envio);
			item.setSeleccionado(Y42bAgendaConstantes.SI);

			// Y42bGrupo grupoAux = new Y42bGrupo();
			List<String> lstGrupos = Arrays.asList(listaGrupos
					.split("\\s*,\\s*"));
			List<Item> lstItems = this.itemService.findAll(item, null);
			for (String idGrupo : lstGrupos) {
				Y42bGrupo grupo = new Y42bGrupo();
				grupo.setGrupoId(idGrupo);

				String id = "";
				Entidad entidad = new Entidad();
				for (Item itemloop : lstItems) {
					entidad = new Entidad();
					id = itemloop.getItemRef();
					if (Y42bAgendaConstantes.ENTIDAD.equals(tipoItem)) {
						// Busca datos entidad
						entidad.setEntidadId(id);

						// Actualiza datos grupo
						grupo = new Y42bGrupo();
						grupo.setGrupoId(idGrupo);
						grupo.getEntidads().add(entidad);
						long grupos_cnt = this.gruposService
								.findGrupoEntidadCount(grupo, entidad);
						if (grupos_cnt <= 0) {
							this.gruposService.addGrupoEntidad(grupo);
						}
						//
						// // Comprueba si esta entidad esta asignada a grupo
						// raiz
						// // (Sin grupo
						// // definido), y lo elimina
						// grupoAux.setGrupoId(Y42bAgendaConstantes.GRUPO_RAIZ_ID);
						//
						// grupos_cnt =
						// this.gruposService.findGrupoEntidadCount(
						// grupoAux, entidad);
						// if (grupos_cnt > 0) {
						// entidad = this.entidadService.find(entidad);
						// entidad.setActiva(Y42bAgendaConstantes.SI);
						// this.entidadService
						// .updateEntidadSinValidacion(entidad);
						// grupoAux = new Y42bGrupo();
						// grupoAux.setGrupoId(Y42bAgendaConstantes.GRUPO_RAIZ_ID);
						// grupoAux.getEntidads().add(entidad);
						// this.gruposService.removeGrupoEntidad(grupoAux);
						// }
					}
				}
			}

			envio.setFechaOperacion(Calendar.getInstance().getTime());
			envio.setTipoOperacion(Y42bAgendaConstantes.TIPO_OP_MASIVA_3);
			envio.setMailingAsunto(" ");
			this.envioService.update(envio);

			response.setStatus(HttpServletResponse.SC_OK);
			EnvioController.logger
					.info("changeEntityStatus execution completed.");
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(e.getMessage());
		}
	}

	/**
	 * Method 'duplicaEnvio'. Duplica el envio tablas 7 y 8 cambiando el id a
	 * uno nuevo generado
	 * 
	 * @param envioId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/duplicaEnvio/{envioId}", method = RequestMethod.GET)
	public @ResponseBody()
	Envio duplicaEnvio(@PathVariable() String envioId,
			HttpServletRequest request) {
		try {

			// String newEnvioId =
			// Y42bUIDGenerator32.getInstance().generateId();

			// envio e item con el idEnvio del que se quiere duplicar
			Envio envio = new Envio();
			envio.setEnvioId(envioId);

			Item item = new Item();
			item.setEnvio(envio);

			Adjunto adjunto = new Adjunto();
			adjunto.setEnvio(envio);

			// recupero el envio original que se quiere duplicar
			envio = this.envioService.find(envio);
			if (envio == null) {
				throw new Exception(envioId.toString());
			} else {
				// le cambio el id y se agrega
				// envio.setEnvioId(newEnvioId); el add ya hace esto
				envio.setFechaOperacion(null); // fecha de operacion a null para
												// que no se lance (el send le
												// pone valor y es cuando se
												// lanza)
				envio = this.envioService.add(envio);

				// recupero la lista de items del original
				List<Item> items = this.itemService.findAll(item, null);
				for (Item i : items) {

					// de la que no se copian los contactos si es mezcla
					if (!(envio.getEnvioAContactos().equalsIgnoreCase(
							Y42bAgendaConstantes.SI) && i.getItemRef()
							.substring(0, 1)
							.equalsIgnoreCase(Y42bAgendaConstantes.CONTACTO))) {

						i.setEnvio(envio);
						i.setFechaMailingEnvio(null); // si se dejan a null lo
														// va a
														// enviar
						i.setMailingResponseCode(null);
						i.setFechaMailingRecepcion(null);
						this.itemService.add(i);

					}

				}

				// recupero la lista de adjuntos del original y se los añado al
				// nuevo
				List<Adjunto> adjuntos = this.adjuntoService.findAll(adjunto,
						null);
				for (Adjunto a : adjuntos) {
					a.setEnvio(envio);
					this.adjuntoService.add(a);
				}

			}

			return envio;
		} catch (Exception e) {
			throw new ResourceNotFoundException(envioId.toString());
		}
	}

	// generar id envio nuevo

	// duplicar entrada en tabla envios (id nuevo por el viejo)

	// duplicar entrada en tabla items (id nuevo por el viejo)

	// TEST INICIO
	/**
	 * Method 'envioMail'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "testEnvioMail", method = RequestMethod.GET)
	public ModelAndView envioMailPre(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("envioMail. Test prepare begin.");
		logger.info("envioMail. Test prepare end.");
		return new ModelAndView("test_envioMail", "model", model);
	}

	/**
	 * Method 'envioMail'.
	 * 
	 * @param model
	 *            Model
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "testEnvioMail", method = RequestMethod.POST)
	public ModelAndView envioMailPost(Model model, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		logger.info("envioMail. Test execute begin.");
		try {
			String idEnvio = (String) request.getParameter("idEnvio");
			Y42bClientEnvioMailJMS.sendMessage(idEnvio);
			response.setContentType("text/html;charset=UTF-8");
			response.setHeader("Cache-Control", "no-cache");
			response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());
			response.setStatus(HttpServletResponse.SC_OK);
			response.getWriter().write("envioMail -> OK");
			logger.info("envioMail -> OK");
		} catch (Throwable th) {
			response.setContentType("text/html;charset=UTF-8");
			response.setHeader("Cache-Control", "no-cache");
			response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());
			response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			response.getWriter().write(
					"ERROR:" + th.getMessage()
							+ StackTraceManager.getStackTrace(th));
			logger.info("envioMail -> ERROR");
		} finally {
			logger.info("The request is a test. Test end.");
		}
		return null;
	}

	// TEST FIN

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param envioId
	 *            String
	 * 
	 * @return Long
	 */
	@RequestMapping(value = "/compruebaEnvioKontsumonet/{envioId}", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCountKontsumonet(@PathVariable() String envioId) {
		try {
			return this.envioService.findAllCountKontsumonet(envioId);
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Lleva a cabo la búsqueda y puebla la tabla de items con los resultados.
	 * 
	 * @param entidades
	 *            List<Entidad>
	 * @param contactFilter
	 *            Contacto
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @param grupos
	 *            List<Grupo>
	 * @param etiquetas
	 *            List<Etiqueta>
	 * @param envio
	 *            Envio
	 */
	private void searchAndAddContactItems(List<Entidad> entidades,
			Contacto contactFilter, Date fechaDesde, Date fechaHasta,
			List<Grupo> grupos, List<Etiqueta> etiquetas, Envio envio) {

		List<Contacto> results = new ArrayList<Contacto>();

		// Verificamos si tenemos entidad a la que debe pertenecer los
		// contactos.
		if (!entidades.isEmpty()) {
			results = this.contactoService.advancedSearch(contactFilter,
					entidades, etiquetas, fechaDesde, fechaHasta, null);
		}

		// else {
		// /*
		// * Solo buscamos sin entidades, si no se pasan criterios de grupos y
		// * etiquetas de las entidades.
		// */
		// results = this.contactService.advancedSearch(contactFilter, null,
		// etiquetas, fechaDesde, fechaHasta, null);
		// }

		if (!results.isEmpty()) {
			// Generación de items de contactos
			Item item = new Item();
			for (Contacto contact : results) {
				// item = new Item();
				item.setEnvio(envio);
				item.setItemRef(contact.getContactoId());
				item.setNombre(contact.getNombre());
				this.setLocation(item, contact.getIsnacional(),
						contact.getNombreLocalidad(),
						contact.getNombreProvincia(), contact.getNombrePais());
				String provincia = contact.getNombreProvincia();
				String localidad = contact.getNombreLocalidad();
				String nombreLocalizacion = "";

				if (!(null == localidad || "".equals(localidad) || "null"
						.equals(localidad))) {
					if (!(null == provincia || "".equals(provincia) || "null"
							.equals(provincia))) {
						nombreLocalizacion = localidad + "(" + provincia + ")";
					} else {
						nombreLocalizacion = localidad;
					}
				}

				item.setNombreLocalizacion(nombreLocalizacion);
				item.setEmail(contact.getEmail());
				item.setTelefono(contact.getTelefono());
				item.setSeleccionado(Y42bAgendaConstantes.DB_TRUE);
				item.setActiva(Y42bAgendaConstantes.SI);

				// obtener entidades del contacto
				Contacto contactoAux = new Contacto();
				contactoAux = this.contactoService.findEntidadContacto(contact,
						new Entidad(), null);
				boolean valorActivo = false;

				// si alguna es activa el contacto sera activo
				List<Entidad> listaEntidades = contactoAux.getEntidads();
				if (!listaEntidades.isEmpty()) {
					for (Entidad entidad : listaEntidades) {
						if (entidad.getActiva().equalsIgnoreCase(
								Y42bAgendaConstantes.SI)) {
							valorActivo = true;
						}
					}
				}

				if (valorActivo) {
					item.setActiva(Y42bAgendaConstantes.SI);
				} else {
					item.setActiva(Y42bAgendaConstantes.NO);
				}

				this.itemService.add(item);
			}
		}
	}

	/**
	 * Establece el parametro de localizacion del item, con la informacion
	 * correspondiente.
	 * 
	 * @param item
	 *            Item
	 * @param isnacional
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param nombrePais
	 *            String
	 */
	private void setLocation(Item item, String isnacional,
			String nombreLocalidad, String nombreProvincia, String nombrePais) {
		if (Y42bAgendaConstantes.DB_TRUE.equals(isnacional)) {
			if (this.isValid(nombreProvincia) && this.isValid(nombreLocalidad)) {
				item.setNombreLocalizacion(nombreLocalidad + "\n"
						+ nombreProvincia);
			} else if (this.isValid(nombreProvincia)) {
				item.setNombreLocalizacion(nombreProvincia);
			} else if (this.isValid(nombreLocalidad)) {
				item.setNombreLocalizacion(nombreLocalidad);
			}
		} else {
			if (this.isValid(nombreLocalidad) && this.isValid(nombrePais)) {
				item.setNombreLocalizacion(nombreLocalidad + "\n" + nombrePais);
			} else if (this.isValid(nombreLocalidad)) {
				item.setNombreLocalizacion(nombreLocalidad);
			} else if (this.isValid(nombrePais)) {
				item.setNombreLocalizacion(nombrePais);
			}
		}
	}

	/**
	 * 
	 * @param string
	 *            String
	 * @return ""
	 */
	private boolean isValid(String string) {
		return (string != null && !"".equals(string));
	}
}
