package com.ejie.y42b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y42b.UserPreferences;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Grupo;
import com.ejie.y42b.model.Y42bFormEntidad;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.model.Y42bTree;
import com.ejie.y42b.service.EntidadService;
import com.ejie.y42b.service.EtiquetaService;
import com.ejie.y42b.service.Y42bArbolService;
import com.ejie.y42b.utils.Y42bEntityGroupTree;
import com.ejie.y42b.utils.Y42bEtiquetasTree;
import com.ejie.y42b.utils.Y42bUtils;
import com.ejie.y42b.utils.exception.Y42bUDAErrorManager;
import com.ejie.y42b.utils.exception.Y42bUDAException;

/**
 * * EntidadController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/entidad")
public class EntidadController {

	private static final Logger logger = LoggerFactory
			.getLogger(EntidadController.class);

	@Autowired()
	private EntidadService entidadService;

	@Autowired()
	private EtiquetaService etiquetaService;

	@Autowired()
	private Y42bArbolService arbolService;

	@Autowired()
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y42bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y42bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y42bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("aaaVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("aaaVistaWar.default.layout"));
		return new ModelAndView("entidad", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param entidadId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody()
	Entidad getById(@PathVariable() String entidadId) {
		try {
			Entidad entidad = new Entidad();
			entidad.setEntidadId(entidadId);
			// Y42bEntidad entidad = (Y42bEntidad)entidad;
			entidad = this.entidadService.find(entidad);
			if (entidad == null) {
				throw new Exception(entidadId.toString());
			}
			return entidad;
		} catch (Exception e) {
			throw new ResourceNotFoundException(entidadId.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param entidadId
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param activa
	 *            String
	 * @param iskontsumogest
	 *            String
	 * @param iskontsumonet
	 *            String
	 * @param isofertaform
	 *            String
	 * @param isconsultasweb
	 *            String
	 * @param isnacional
	 *            String
	 * @param observaciones
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param usuario
	 *            String
	 * @param password
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param codOrg
	 *            String
	 * @param compleDirec
	 *            String
	 * @param tipoOrganismo
	 *            String
	 * @param ambitoGeografico
	 *            String
	 * @param cif
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "nombreEs", required = false) String nombreEs,
			@RequestParam(value = "nombreEu", required = false) String nombreEu,
			@RequestParam(value = "activa", required = false) String activa,
			@RequestParam(value = "iskontsumogest", required = false) String iskontsumogest,
			@RequestParam(value = "iskontsumonet", required = false) String iskontsumonet,
			@RequestParam(value = "isofertaform", required = false) String isofertaform,
			@RequestParam(value = "isconsultasweb", required = false) String isconsultasweb,
			@RequestParam(value = "isnacional", required = false) String isnacional,
			@RequestParam(value = "observaciones", required = false) String observaciones,
			@RequestParam(value = "telefono", required = false) String telefono,
			@RequestParam(value = "fax", required = false) String fax,
			@RequestParam(value = "email", required = false) String email,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "usuario", required = false) String usuario,
			@RequestParam(value = "password", required = false) String password,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "noraProvinciaId", required = false) String noraProvinciaId,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "noraMunicipioId", required = false) String noraMunicipioId,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "noraLocalidadId", required = false) String noraLocalidadId,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "codOrg", required = false) String codOrg,
			@RequestParam(value = "compleDirec", required = false) String compleDirec,
			@RequestParam(value = "tipoOrganismo", required = false) String tipoOrganismo,
			@RequestParam(value = "ambitoGeografico", required = false) String ambitoGeografico,
			@RequestParam(value = "cif", required = false) String cif,

			HttpServletRequest request) {
		try {
			Entidad filterEntidad = new Entidad(entidadId, nombreEs, nombreEu,
					activa, iskontsumogest, iskontsumonet, isofertaform,
					isconsultasweb, isnacional, observaciones, telefono, fax,
					email, url, usuario, password, usuultmod, fecultmod,
					noraPaisId, nombrePais, noraProvinciaId, nombreProvincia,
					noraMunicipioId, nombreMunicipio, noraLocalidadId,
					nombreLocalidad, noraCalleId, nombreCalle, noraCpId,
					nombreCp, noraPortalId, nombrePortal, codOrg, compleDirec,
					tipoOrganismo, ambitoGeografico, cif);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Entidad> entidads = this.entidadService.findAll(
						filterEntidad, pagination);

				if (entidads == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.getAllCount(filterEntidad, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(entidads);
				return data;
			} else {
				List<Entidad> entidads = this.entidadService.findAll(
						filterEntidad, pagination);
				if (entidads == null) {
					throw new Exception("No data Found.");
				}
				return entidads;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEntidad
	 *            Entidad
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "entidad", required = false) Entidad filterEntidad,
			HttpServletRequest request) {
		try {
			return this.entidadService
					.findAllCount(filterEntidad != null ? filterEntidad
							: new Entidad());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param req
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Entidad
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Entidad edit(@RequestBody() Entidad entidad, HttpServletRequest req,
			HttpServletResponse response) {
		try {
			if (null != entidad.getCodOrg()
					&& ("null").equals(entidad.getCodOrg())) {
				entidad.setCodOrg(null);
			}
			UserPreferences userPreferences = (UserPreferences) req
					.getSession().getAttribute(
							Y42bAgendaConstantes.SESSIONBEAN_NODE);
			String usuario = "";
			if (userPreferences != null) {
				usuario = userPreferences.getUserId();
			}
			entidad.setUsuultmod(usuario);

			entidad.setNombreEs(Y42bUtils.unescapeHTML(entidad.getNombreEs(), 0));
			entidad.setNombreEu(Y42bUtils.unescapeHTML(entidad.getNombreEu(), 0));

			Entidad entidadAux = this.entidadService.update(entidad);
			EntidadController.logger.info("Entity correctly inserted!");
			return entidadAux;
		} catch (Y42bUDAException e) {
			throw e;
		} catch (Exception e) {

			// if (e instanceof org.springframework.dao.DuplicateKeyException) {
			// response.setStatus(HttpServletResponse.SC_CONFLICT);
			// throw new ResourceNotFoundException("Registro duplicado");
			// }

			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param req
	 *            HttpServletRequest
	 * @return Entidad
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Entidad add(@RequestBody() Entidad entidad, HttpServletRequest req) {
		try {
			if (null != entidad.getCodOrg()
					&& ("null").equals(entidad.getCodOrg())) {
				entidad.setCodOrg(null);
			}
			UserPreferences userPreferences = (UserPreferences) req
					.getSession().getAttribute(
							Y42bAgendaConstantes.SESSIONBEAN_NODE);
			String usuario = "";
			if (userPreferences != null) {
				usuario = userPreferences.getUserId();
			}
			entidad.setUsuultmod(usuario);

			entidad.setNombreEs(Y42bUtils.unescapeHTML(entidad.getNombreEs(), 0));
			entidad.setNombreEu(Y42bUtils.unescapeHTML(entidad.getNombreEu(), 0));

			Entidad entidadAux = this.entidadService.add(entidad);

			EntidadController.logger.info("Entity correctly inserted!");
			return entidadAux;
		} catch (Y42bUDAException e) {
			throw e;
		} catch (ResourceNotFoundException er) {
			// response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(er.getMessage());

		} catch (Exception e) {

			// if (e instanceof org.springframework.dao.DuplicateKeyException) {
			// // response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			// throw new ResourceNotFoundException("Registro duplicado");
			// }

			// response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param mySession
	 *            mySession
	 * @return Entidad
	 */

	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody()
	Entidad addEntidadGupo(@RequestBody() Entidad entidad, HttpSession mySession) {

		// @RequestMapping(value = "/{grupoId}/{etiquetasIds}", method =
		// RequestMethod.POST)
		// public @ResponseBody()
		// Entidad addEntidadGupo(@PathVariable() String grupoId,
		// @PathVariable() String etiquetasIds,
		// @RequestBody() Entidad entidad, HttpSession mySession) {
		try {

			List<Grupo> grLst = new ArrayList<Grupo>();
			if (!(entidad.getListaGruposIds().equalsIgnoreCase(""))) {
				String[] grList = entidad.getListaGruposIds().split(",");
				for (int g = 0; g < grList.length; g++) {
					Grupo grupo = new Grupo();
					grupo.setGrupoId(grList[g]);
					grLst.add(grupo);
				}
			}
			Entidad entidadAux = new Entidad();

			entidadAux = entidad;
			entidadAux.setGrupos(grLst);

			// if
			// (Y42bAgendaConstantes.GRUPO_RAIZ_ID.equals(grupo.getGrupoId())) {
			// entidadAux.setActiva("N");
			// }

			List<Etiqueta> etiqLst = new ArrayList<Etiqueta>();
			if (!(entidad.getListaEtiquetasIds().equalsIgnoreCase(""))) {
				// la lista de etiquetas de la entidad
				String[] etiqList = entidad.getListaEtiquetasIds().split(",");
				for (int g = 0; g < etiqList.length; g++) {
					Etiqueta etiqueta = new Etiqueta();
					etiqueta.setEtiquetaId(etiqList[g]);
					etiqLst.add(etiqueta);
				}
			}
			entidad.setEtiquetas(etiqLst);

			if (null != entidad.getCodOrg()
					&& ("null").equals(entidad.getCodOrg())) {
				entidad.setCodOrg(null);
			}

			UserPreferences userPreferences = (UserPreferences) mySession
					.getAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE);
			String usuario = "";
			if (userPreferences != null) {
				usuario = userPreferences.getUserId();
			}
			entidadAux.setUsuultmod(usuario);

			Entidad entidadRetorno = this.entidadService.add(entidadAux);

			if (userPreferences != null) {
				String nodoActivo = "";
				nodoActivo = "G_" + entidad.getListaGruposIds() + "#" + "E_"
						+ entidadRetorno.getEntidadId();
				userPreferences.setNodeActive(nodoActivo);
				mySession.setAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE,
						userPreferences);
			}

			EntidadController.logger.debug("Set Node info: "
					+ userPreferences.getNodeActive());
			EntidadController.logger.info("Entity correctly inserted!");
			return entidadRetorno;
		} catch (Y42bUDAException e) {
			throw e;
		} catch (ResourceNotFoundException er) {
			// response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException(er.getMessage());

		} catch (Exception e) {

			if (e instanceof org.springframework.dao.DuplicateKeyException) {
				// response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
				throw new ResourceNotFoundException("Registro duplicado");
			}

			// response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param entidadId
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @throws ResourceNotFoundException
	 *             Exception
	 */
	@RequestMapping(value = "/{entidadId}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String entidadId,
			HttpServletResponse response) throws ResourceNotFoundException {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");

		Entidad entidad = new Entidad();
		entidad.setEntidadId(entidadId);

		long cnt_ontactos = this.entidadService.findEntidadContactoCount(
				entidad, new Contacto());
		if (cnt_ontactos == 0) {
			entidad = this.entidadService.find(entidad);
			entidad.setActiva(Y42bAgendaConstantes.NO);
			try {
				this.entidadService.update(entidad);
			} catch (Exception e) {
				response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
				throw new ResourceNotFoundException("Method failed");
			}
			response.setStatus(HttpServletResponse.SC_OK);
		} else {
			response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
			throw new ResourceNotFoundException("Method failed");
		}

	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param entidadIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> entidadIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Entidad> entidadList = new ArrayList<Entidad>();
		try {
			Entidad entidad = new Entidad();
			for (ArrayList<String> entidadId : entidadIds) {
				Iterator<String> iterator = entidadId.iterator();

				entidad.setEntidadId(ObjectConversionManager.convert(
						iterator.next(), String.class));
				entidadList.add(entidad);
			}
			this.entidadService.removeMultiple(entidadList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		EntidadController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEntidadService'.
	 * 
	 * @return EntidadService
	 */
	protected EntidadService getEntidadService() {
		return this.entidadService;
	}

	/**
	 * Method 'setEntidadService'.
	 * 
	 * @param entidadService
	 *            EntidadService
	 * @return
	 */
	public void setEntidadService(EntidadService entidadService) {
		this.entidadService = entidadService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' EtiquetaEntidad
	 * 
	 * @param entidadId
	 *            String
	 * @param etiquetaEtiquetaId
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindEtiquetaEntidad", method = RequestMethod.POST)
	public void unBindEtiquetaEntidad(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "etiquetaEtiquetaId", required = false) String etiquetaEtiquetaId) {
		Entidad entidad = new Entidad();
		Etiqueta etiqueta = new Etiqueta();
		if (entidadId != null) {
			entidad.setEntidadId(entidadId);
		}
		if (etiquetaEtiquetaId != null) {
			etiqueta.setEtiquetaId(etiquetaEtiquetaId);
		}
		entidad.getEtiquetas().add(etiqueta);
		this.entidadService.removeEtiquetaEntidad(entidad);
	}

	/**
	 * Method 'bind' EtiquetaEntidad
	 * 
	 * @param entidadId
	 *            String
	 * @param etiquetaEtiquetaId
	 *            String
	 */
	@RequestMapping(value = "/bindEtiquetaEntidad", method = RequestMethod.POST)
	public void bindEtiquetaEntidad(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "etiquetaEtiquetaId", required = false) String etiquetaEtiquetaId) {
		Entidad entidad = new Entidad();
		Etiqueta etiqueta = new Etiqueta();
		if (entidadId != null) {
			entidad.setEntidadId(entidadId);
		}
		if (etiquetaEtiquetaId != null) {
			etiqueta.setEtiquetaId(etiquetaEtiquetaId);
		}
		entidad.getEtiquetas().add(etiqueta);
		this.entidadService.addEtiquetaEntidad(entidad);
	}

	/**
	 * Method 'unBind' EntidadContacto
	 * 
	 * @param entidadId
	 *            String
	 * @param contactoContactoId
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/unbindEntidadContacto", method = RequestMethod.POST)
	public void unBindEntidadContacto(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "contactoContactoId", required = false) String contactoContactoId,
			HttpServletResponse response) {
		Entidad entidad = new Entidad();
		Contacto contacto = new Contacto();
		if (entidadId != null) {
			entidad.setEntidadId(entidadId);
		}
		if (contactoContactoId != null) {
			contacto.setContactoId(contactoContactoId);
		}
		entidad.getContactos().add(contacto);
		this.entidadService.removeEntidadContacto(entidad);

		// Conmprueba si este contacto pertenece a alguna entidad
		entidad.setEntidadId(null);
		long entidades_cnt = this.entidadService.findEntidadContactoCount(
				entidad, contacto);
		try {
			if (entidades_cnt == 0) {
				throw new Exception("Method failed");
			}
			response.setStatus(HttpServletResponse.SC_OK);

		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'bind' EntidadContacto
	 * 
	 * @param entidadId
	 *            String
	 * @param contactoContactoId
	 *            String
	 */
	@RequestMapping(value = "/bindEntidadContacto", method = RequestMethod.POST)
	public void bindEntidadContacto(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "contactoContactoId", required = false) String contactoContactoId) {
		Entidad entidad = new Entidad();
		Contacto contacto = new Contacto();
		if (entidadId != null) {
			entidad.setEntidadId(entidadId);
		}
		if (contactoContactoId != null) {
			contacto.setContactoId(contactoContactoId);
		}
		entidad.getContactos().add(contacto);
		this.entidadService.addEntidadContacto(entidad);
	}

	/**************************/
	/* METODOS AÑADIDOS * */
	/****************************/

	/**
	 * Loading entity group tree
	 * 
	 * @param entidadId
	 *            entidadId
	 * @param grupos
	 *            Grupos
	 * @param response
	 *            Response
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/groupTree", method = RequestMethod.GET)
	public void getGroupTree(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "grupos", required = false) String grupos,
			HttpServletResponse response) throws IOException {
		response.setHeader("Cache-Control", "no-cache");
		response.setCharacterEncoding("ISO-8859-1");
		response.setContentType("text/html;charset=utf-8");

		// Obtiene lista de grupos de la entidad
		List<String> grupoIdList = new ArrayList<String>();

		if (!"".equals(entidadId)) {
			if (!"0".equals(entidadId)) {
				try {
					Entidad entidad = new Entidad();
					entidad.setEntidadId(entidadId);
					entidad = this.entidadService.find(entidad);
					entidad = this.entidadService.findGrupoEntidad(entidad,
							new Y42bGrupo(), null);

					for (Grupo grupo : entidad.getGrupos()) {
						grupoIdList.add(grupo.getGrupoId());
						// this.logger.debug("GrupoId: " + grupo.getGrupoId());
					}

				} catch (Exception e) {
					throw new ResourceNotFoundException(entidadId.toString());
				}
			} else {
				String[] grList = grupos.split(",");
				for (int g = 0; g < grList.length; g++) {
					grupoIdList.add(grList[g]);
				}
			}
		}

		// Y42bTree arbol = this.arbolService.obtenerArbol(false);
		Y42bTree arbol = this.arbolService
				.obtenerArbol(Y42bAgendaConstantes.ESTADO_ACTIVAS);

		// Quita el grup raiz de la lista de grupos
		List<Y42bGrupo> grList = arbol.getLstGrupos();
		for (Y42bGrupo gr : grList) {
			if (Y42bAgendaConstantes.GRUPO_RAIZ_ID.equals(gr.getGrupoId())) {
				grList.remove(gr);
				break;
			}
		}

		String json = Y42bEntityGroupTree.obtieneJsonArbol(arbol, grupoIdList);
		EntidadController.logger.debug("Json:  " + json);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param entidadId
	 *            entidadId
	 * @param grupos
	 *            Grupos
	 * @param response
	 *            Response
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/groupTreeDetalle", method = RequestMethod.GET)
	public void getGroupTreeDetalle(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "grupos", required = false) String grupos,
			HttpServletResponse response) throws IOException {
		response.setHeader("Cache-Control", "no-cache");
		response.setCharacterEncoding("ISO-8859-1");
		response.setContentType("text/html;charset=utf-8");

		// Obtiene lista de grupos de la entidad
		List<String> grupoIdList = new ArrayList<String>();

		if (!"".equals(entidadId)) {
			if (!"0".equals(entidadId)) {
				try {
					Entidad entidad = new Entidad();
					entidad.setEntidadId(entidadId);
					entidad = this.entidadService.find(entidad);
					entidad = this.entidadService.findGrupoEntidad(entidad,
							new Y42bGrupo(), null);

					for (Grupo grupo : entidad.getGrupos()) {
						grupoIdList.add(grupo.getGrupoId());
						// this.logger.debug("GrupoId: " + grupo.getGrupoId());
					}

				} catch (Exception e) {
					throw new ResourceNotFoundException(entidadId.toString());
				}
			} else {
				String[] grList = grupos.split(",");
				for (int g = 0; g < grList.length; g++) {
					grupoIdList.add(grList[g]);
				}
			}
		}

		Y42bTree arbol = this.arbolService
				.obtenerArbolDetalle(false, entidadId);

		// Quita el grup raiz de la lista de grupos
		List<Y42bGrupo> grList = arbol.getLstGrupos();
		for (Y42bGrupo gr : grList) {
			if (Y42bAgendaConstantes.GRUPO_RAIZ_ID.equals(gr.getGrupoId())) {
				grList.remove(gr);
				break;
			}
		}

		String json = Y42bEntityGroupTree.obtieneJsonArbol(arbol, grupoIdList);
		EntidadController.logger.debug("Json:  " + json);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Loading contact grid
	 * 
	 * @param request
	 *            request
	 * @return Object
	 * @throws IOException
	 *             IOException
	 */
	@ResponseBody()
	@RequestMapping(value = "/contactGrid", method = RequestMethod.GET)
	public Object getContactGrid(HttpServletRequest request) throws IOException {

		String entidadId = "";
		if (request.getParameter("entidadId") == null) {
			entidadId = "";
		} else {
			entidadId = (String) request.getParameter("entidadId");
		}

		if (request.getHeader("JQGridModel") == null
				|| !request.getHeader("JQGridModel").equals("true")) {
			return null;
		}

		Pagination pagination = new Pagination();
		pagination.setPage(Long.valueOf(request.getParameter("page")));
		pagination.setRows(Long.valueOf(request.getParameter("rows")));
		pagination.setSort(request.getParameter("sidx"));
		pagination.setAscDsc(request.getParameter("sord"));

		Entidad entidad = new Entidad();
		entidad.setEntidadId(entidadId);
		entidad = this.entidadService.find(entidad);
		Contacto cnt = new Contacto();
		entidad = this.entidadService.findEntidadContacto(entidad, cnt,
				pagination);

		List<Contacto> contactos = entidad.getContactos();

		Long total = this.entidadService.findEntidadContactoCount(entidad,
				new Contacto());

		JQGridJSONModel data = new JQGridJSONModel();
		data.setPage(request.getParameter("page"));
		data.setRecords(total.intValue());
		data.setTotal(total, pagination.getRows());
		data.setRows(contactos);

		return data;
	}

	/**
	 * /** Method 'newEntidad'.
	 * 
	 * @param grupoId
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/nuevo", method = RequestMethod.GET)
	public ModelAndView addShow(
			@RequestParam(value = "grupoId", required = false) String grupoId,
			Model model) {

		EntidadController.logger.debug("/entidades/nuevo GET");

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		Y42bFormEntidad formEntidad = new Y42bFormEntidad();
		formEntidad.setEntidadId("0");
		formEntidad.setActiva(Y42bAgendaConstantes.SI);
		formEntidad.setLocalizacionInternacional("0");
		formEntidad.setPaisId("");
		formEntidad.setProvinciaId("0");
		formEntidad.setMunicipioId("0");
		formEntidad.setLocalidadId("0");
		formEntidad.setLocalidad("");
		formEntidad.setCalle("");
		formEntidad.setCalleId("0");
		formEntidad.setNombreEs("");
		formEntidad.setNombreEu("");
		formEntidad.setTelefono("");
		formEntidad.setFax("");
		formEntidad.setUrl("");
		formEntidad.setPortal("");
		formEntidad.setCodigoPostal("");
		formEntidad.setPostCode("");
		formEntidad.setUsuario("");
		formEntidad.setPassword("");
		formEntidad.setObservaciones("");
		formEntidad.setEmail("");
		formEntidad.setGrupoId(grupoId);
		formEntidad.setCodOrg("");
		formEntidad.setCompleDirec("");

		// nuevos
		formEntidad.setTorcodigo("");
		formEntidad.setTagcodigo("");
		formEntidad.setCif("");

		// List<String> grupoIdList = new ArrayList<String>();
		// grupoIdList.add(grupoId);
		// grupoIdList.add(grupoId);
		formEntidad.setGrupos(grupoId);

		model.addAttribute("entidadForm", formEntidad);
		return new ModelAndView("mantenimientos_entidades", "model", model);
	}

	/**
	 * Loading Main tree de la lista de etiquetas para una determinada entidad
	 * 
	 * @param entidadId
	 *            String
	 * @param etiquetasIdList
	 *            String
	 * @param response
	 *            Response
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "lista", method = RequestMethod.GET)
	public void showListaEtiquetas(
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "etiquetasIdList", required = false) String etiquetasIdList,
			HttpServletResponse response) throws IOException {
		response.setHeader("Cache-Control", "no-cache");
		PrintWriter out = response.getWriter();
		// String node = "";
		// List<Etiqueta> lstEtiquetasEntidad = null;
		List<String> selectedIdList = new ArrayList<String>();

		// Si entidadId = 0 se trata de un mantenimiento
		// Obtiene lista de etiquetas del sistema

		Pagination pagination = new Pagination();
		pagination.setSort("NOMBRE");
		pagination.setAscDsc("ASC");

		List<Etiqueta> lstEtiquetasCompletas = this.etiquetaService.findAll(
				null, pagination);
		// if (!"0".equals(entidadId)) {
		// Entidad entidad = new Entidad();
		//
		// if (!"-1".equals(entidadId) && !"-2".equals(entidadId)) {
		// entidad.setEntidadId(entidadId);
		// entidad = this.entidadService.find(entidad);
		// }
		//
		// this.entidadService.findEtiquetaEntidad(entidad, new Etiqueta(),
		// null);
		//
		// // rellenar la lista de etiquetas con las que ya vienen
		// // seleccionadas
		// if (!etiquetasIdList.equalsIgnoreCase("")) {
		// String[] arrIdsEtiquetasSeleccionadas;
		// String strDelimitador = ",";
		// arrIdsEtiquetasSeleccionadas = etiquetasIdList
		// .split(strDelimitador);
		// for (int i = 0; i < arrIdsEtiquetasSeleccionadas.length; i++)
		// selectedIdList.add(arrIdsEtiquetasSeleccionadas[i]);
		// }
		//
		// // Obtiene lista de etiquetas de la entidad
		// lstEtiquetasEntidad = entidad.getEtiquetas();
		// for (Etiqueta etiqueta : lstEtiquetasEntidad) {
		// selectedIdList.add(etiqueta.getEtiquetaId());
		// }
		// } else {
		if (!etiquetasIdList.equalsIgnoreCase("")) {
			String[] arrIdsEtiquetasSeleccionadas;
			String strDelimitador = ",";
			arrIdsEtiquetasSeleccionadas = etiquetasIdList
					.split(strDelimitador);
			for (int i = 0; i < arrIdsEtiquetasSeleccionadas.length; i++)
				selectedIdList.add(arrIdsEtiquetasSeleccionadas[i]);
		}

		// }

		String json = Y42bEtiquetasTree.obtieneJsonArbol(lstEtiquetasCompletas,
				selectedIdList);
		out.println(json);

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param nodeId
	 *            node
	 * @param session
	 *            HttpSession
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/node", method = RequestMethod.GET)
	public ModelAndView getByNode(
			@RequestParam(value = "nodeId", required = false) String nodeId,
			HttpSession session, Model model) {

		String entidadId = this.getEntidadId(nodeId, session);

		return this.getByIdorig(entidadId, session, model);

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param entidadId
	 *            String
	 * @param session
	 *            HttpSession
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/old_/{entidadId}", method = RequestMethod.GET)
	public ModelAndView getByIdorig(@PathVariable() String entidadId,
			HttpSession session, Model model) {

		EntidadController.logger.debug("/entidades GET");
		EntidadController.logger.debug("Node entidad: " + entidadId);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y42bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y42bVistaWar.default.layout"));

		Locale locale = LocaleContextHolder.getLocale();
		// String entidadId = this.getEntidadId(nodeId, session);
		EntidadController.logger.debug("Node entidadId: " + entidadId);

		Entidad entidad = new Entidad();
		entidad.setEntidadId(entidadId);

		entidad = this.entidadService.find(entidad);
		Etiqueta etiqueta = new Etiqueta();
		entidad = this.entidadService.findEtiquetaEntidad(entidad, etiqueta,
				null);
		entidad = this.entidadService.findGrupoEntidad(entidad,
				new Y42bGrupo(), null);

		Y42bFormEntidad entidadForm = this.getY42bFormEntidad(entidad, locale);

		model.addAttribute("entidadForm", entidadForm);

		return new ModelAndView("mantenimientos_entidades", "model", model);
	}

	// PRIVATE METHODS //
	/**
	 * @param nodeId
	 *            String
	 * @param session
	 *            HttpSession
	 * @return ""
	 */
	private String getEntidadId(String nodeId, HttpSession session) {
		String entidadId = "";
		if (nodeId == null) {
			EntidadController.logger
					.warn("nodeId = null - Coger parametros de session");
		}
		if (nodeId == null || "".equals(nodeId)) {
			UserPreferences userPreferences = (UserPreferences) session
					.getAttribute(Y42bAgendaConstantes.SESSIONBEAN_NODE);
			String nodos = userPreferences.getNodeActive();
			entidadId = (nodos.split("#")[1]).substring(2);
		} else {
			entidadId = (nodeId.split("#")[1]).substring(2);
		}
		return entidadId;
	}

	/**
	 * Transformer de salida en Base de datos
	 * 
	 * @param entidadBean
	 *            EntidadBean
	 * @param locale
	 *            Locale
	 * @return Y42bFormEntidad
	 */
	private Y42bFormEntidad getY42bFormEntidad(final Entidad entidadBean,
			final Locale locale) {
		Y42bFormEntidad formEntidad = new Y42bFormEntidad();

		if (entidadBean != null) {
			formEntidad.setEntidadId(entidadBean.getEntidadId());
			formEntidad.setNombreEs(Y42bUtils.encodeHtmlTag(entidadBean
					.getNombreEs()));
			formEntidad.setNombreEu(Y42bUtils.encodeHtmlTag(entidadBean
					.getNombreEu()));
			formEntidad.setKontsumoGest(Y42bAgendaConstantes.SI
					.equals(entidadBean.getIskontsumogest()));
			formEntidad.setFormativa(Y42bAgendaConstantes.SI.equals(entidadBean
					.getIsofertaform()));
			formEntidad.setKontsumoNet(Y42bAgendaConstantes.SI
					.equals(entidadBean.getIskontsumonet()));
			formEntidad.setConsultaWeb(Y42bAgendaConstantes.SI
					.equals(entidadBean.getIsconsultasweb()));
			formEntidad.setActiva(entidadBean.getActiva());
			formEntidad.setObservaciones(Y42bUtils.normalizarVacio(entidadBean
					.getObservaciones()));

			formEntidad.setCompleDirec(Y42bUtils.normalizarVacio(entidadBean
					.getCompleDirec()));

			formEntidad.setTelefono(Y42bUtils.normalizarVacio(entidadBean
					.getTelefono()));
			formEntidad.setFax(Y42bUtils.normalizarVacio(entidadBean.getFax()));
			formEntidad.setEmail(Y42bUtils.normalizarVacio(entidadBean
					.getEmail()));
			formEntidad.setUrl(Y42bUtils.normalizarVacio(entidadBean.getUrl()));

			formEntidad.setFechaActualizacion(Y42bUtils.parseDateToString(
					entidadBean.getFecultmod(), locale.getLanguage()));
			formEntidad.setUsuarioActualizacion(entidadBean.getUsuultmod());

			if (null != entidadBean.getUsuario()
					&& !("null").equals(entidadBean.getUsuario())) {
				formEntidad.setUsuario(entidadBean.getUsuario());
			} else {
				formEntidad.setUsuario("");
			}
			if (null != entidadBean.getPassword()
					&& !("null").equals(entidadBean.getPassword())) {
				formEntidad.setPassword(entidadBean.getPassword());
			} else {
				formEntidad.setPassword("");
			}
			// Grupos
			StringBuffer lstGr = new StringBuffer(
					Y42bAgendaConstantes.BUFFER_50);
			String grupos = "";
			for (Grupo grupo : entidadBean.getGrupos()) {
				lstGr.append(grupo.getGrupoId());
				lstGr.append(",");
			}
			grupos = lstGr.toString();
			if (grupos.length() > 0) {
				grupos = grupos.substring(0, grupos.length() - 1);
			}

			formEntidad.setGrupos(lstGr.toString());

			formEntidad
					.setLocalizacionInternacional((Y42bAgendaConstantes.SI
							.equals(entidadBean.getIsnacional()) ? Y42bAgendaConstantes.NO
							: Y42bAgendaConstantes.SI));
			formEntidad.setPaisId((entidadBean.getNoraPaisId() == null ? ""
					: entidadBean.getNoraPaisId()));
			formEntidad.setLocalidad(Y42bUtils.normalizarVacio(entidadBean
					.getNombreLocalidad()));
			formEntidad.setPostCode(Y42bUtils.normalizarVacio(entidadBean
					.getNombreCp()));
			formEntidad.setCalle(Y42bUtils.normalizarVacio(entidadBean
					.getNombreCalle()));
			formEntidad
					.setProvinciaId((entidadBean.getNoraProvinciaId() == null ? ""
							: entidadBean.getNoraProvinciaId()));
			formEntidad
					.setMunicipioId((entidadBean.getNoraMunicipioId() == null ? ""
							: entidadBean.getNoraMunicipioId()));
			formEntidad
					.setLocalidadId((entidadBean.getNoraLocalidadId() == null ? ""
							: entidadBean.getNoraLocalidadId()));
			formEntidad.setCodigoPostal(Y42bUtils.normalizarVacio(entidadBean
					.getNombreCp()));
			formEntidad.setCalleId((entidadBean.getNoraCalleId() == null ? ""
					: entidadBean.getNoraCalleId()));

			formEntidad.setPortalId(Y42bUtils.normalizarVacio(entidadBean
					.getNoraPortalId()));
			formEntidad.setPortal(Y42bUtils.normalizarVacio(entidadBean
					.getNombrePortal()));

			formEntidad.setCodOrg(Y42bUtils.normalizarVacio(entidadBean
					.getCodOrg()));

			formEntidad.setCompleDirec(Y42bUtils.normalizarVacio(entidadBean
					.getCompleDirec()));

			// nuevos
			formEntidad.setTorcodigo(entidadBean.getTipoOrganismo());
			formEntidad.setTagcodigo(entidadBean.getAmbitoGeografico());

			if (null != entidadBean.getCif()
					&& !("null").equals(entidadBean.getCif())) {
				formEntidad.setCif(entidadBean.getCif());
			} else {
				formEntidad.setCif("");
			}

			// }

			// Etiquetas
			StringBuffer lstEt = new StringBuffer(
					Y42bAgendaConstantes.BUFFER_50);
			StringBuffer lstEtIds = new StringBuffer(
					Y42bAgendaConstantes.BUFFER_50);

			for (Etiqueta et : entidadBean.getEtiquetas()) {
				lstEt.append(et.getNombre());
				lstEt.append(",");

				lstEtIds.append(et.getEtiquetaId());
				lstEtIds.append(",");
			}
			StringBuffer etiquetasBuff = new StringBuffer("");
			String etiquetas = lstEt.toString();
			if (etiquetas.length() > 0) {
				etiquetas = etiquetas.substring(0, etiquetas.length() - 1);
			} else {
				etiquetas = "";
			}

			etiquetasBuff.append("[");
			etiquetasBuff.append(etiquetas);
			etiquetasBuff.append("]");

			formEntidad.setEtiquetas(etiquetasBuff.toString());

			String idsEtiquetas = lstEtIds.toString();
			if (idsEtiquetas.length() > 0) {
				idsEtiquetas = idsEtiquetas.substring(0,
						idsEtiquetas.length() - 1);
			} else {
				idsEtiquetas = "";
			}

			formEntidad.setEtiquetasIds(idsEtiquetas);

			// if (idsEtiquetas.equals("")) {
			// formEntidad.setEtiquetasIds("");
			// // formEntidad.setEtiquetasIds(",");
			// } else {
			// formEntidad.setEtiquetasIds(idsEtiquetas);
			// }

		}

		return formEntidad;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tipoOrganismo_
	 *            String
	 * @param noraProvinciaId_
	 *            String
	 * @param ambitoGeografico_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return String
	 */
	@RequestMapping(value = "/generateCodOrg", method = RequestMethod.GET)
	public @ResponseBody
	String generateCodOrg(
			@RequestParam(value = "ambitoGeografico", required = false) String ambitoGeografico_,
			@RequestParam(value = "tipoOrganismo", required = false) String tipoOrganismo_,
			@RequestParam(value = "noraProvinciaId", required = false) String noraProvinciaId_,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			HttpServletResponse response) {

		// control de los campos susceptibles de llegar a "" desde el filtro
		String ambitoGeografico = ("".equals(ambitoGeografico_)) ? null
				: ambitoGeografico_;
		String tipoOrganismo = ("".equals(tipoOrganismo_)) ? null
				: tipoOrganismo_;
		String noraProvinciaId = ("".equals(noraProvinciaId_)) ? null
				: noraProvinciaId_;
		String noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;

		Entidad entidad = new Entidad();
		entidad.setTipoOrganismo(tipoOrganismo);
		entidad.setNoraProvinciaId(noraProvinciaId);
		entidad.setAmbitoGeografico(ambitoGeografico);
		entidad.setNoraPaisId(noraPaisId);

		String codOrg = "";
		codOrg = this.entidadService.obtenerCodigoOrganismo(entidad);
		return codOrg;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param req
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Entidad
	 */

	@RequestMapping(value = "/edicion", method = RequestMethod.PUT)
	public @ResponseBody()
	Entidad editEntidadGrupo(@RequestBody() Entidad entidad,
			HttpServletRequest req, HttpServletResponse response) {

		// @RequestMapping(value = "/{gruposIds}/{etiquetasIds}", method =
		// RequestMethod.PUT)
		// public @ResponseBody()
		// Entidad editEntidadGrupo(@PathVariable() String gruposIds,
		// @PathVariable() String etiquetasIds,
		// @RequestBody() Entidad entidad, HttpServletRequest req,
		// HttpServletResponse response) {
		try {

			List<Grupo> grLst = new ArrayList<Grupo>();
			if (!(entidad.getListaGruposIds().equalsIgnoreCase(""))) {
				// la lista de grupos de la entidad
				String[] grList = entidad.getListaGruposIds().split(",");
				for (int g = 0; g < grList.length; g++) {
					Grupo grupo = new Grupo();
					grupo.setGrupoId(grList[g]);
					grLst.add(grupo);
				}
			}
			entidad.setGrupos(grLst);

			List<Etiqueta> etiqLst = new ArrayList<Etiqueta>();
			if (!(entidad.getListaEtiquetasIds().equalsIgnoreCase(""))) {
				// la lista de etiquetas de la entidad
				String[] etiqList = entidad.getListaEtiquetasIds().split(",");
				for (int g = 0; g < etiqList.length; g++) {
					Etiqueta etiqueta = new Etiqueta();
					etiqueta.setEtiquetaId(etiqList[g]);
					etiqLst.add(etiqueta);
				}
			}
			entidad.setEtiquetas(etiqLst);

			if (null != entidad.getCodOrg()
					&& ("null").equals(entidad.getCodOrg())) {
				entidad.setCodOrg(null);
			}
			UserPreferences userPreferences = (UserPreferences) req
					.getSession().getAttribute(
							Y42bAgendaConstantes.SESSIONBEAN_NODE);
			String usuario = "";
			if (userPreferences != null) {
				usuario = userPreferences.getUserId();
			}
			entidad.setUsuultmod(usuario);

			entidad.setNombreEs(Y42bUtils.unescapeHTML(entidad.getNombreEs(), 0));
			entidad.setNombreEu(Y42bUtils.unescapeHTML(entidad.getNombreEu(), 0));

			Entidad entidadAux = this.entidadService.update(entidad);
			EntidadController.logger.info("Entity correctly inserted!");
			return entidadAux;
		} catch (Y42bUDAException e) {
			throw e;
		} catch (Exception e) {

			// if (e instanceof org.springframework.dao.DuplicateKeyException) {
			// response.setStatus(HttpServletResponse.SC_CONFLICT);
			// throw new ResourceNotFoundException("Registro duplicado");
			// }

			throw new MethodFailureException("Method failed");
		}
	}

}