package com.ejie.y42b.control;

import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.AmbitoGeografico;
import com.ejie.y42b.service.AmbitoGeograficoService;

/**
 * * TipoOrganismoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/ambitogeografico")
public class AmbitoGeograficoController {

	private static final Logger logger = LoggerFactory
			.getLogger(AmbitoGeograficoController.class);

	@Autowired()
	private AmbitoGeograficoService ambitoGeograficoService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getAll'.
	 * 
	 * @param tagcodigo
	 *            String
	 * @param tagnombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "tagcodigo", required = false) String tagcodigo,
			@RequestParam(value = "tagnombre", required = false) String tagnombre,
			HttpServletRequest request) {
		try {
			AmbitoGeografico filterAmbitoGeografico = new AmbitoGeografico(
					tagcodigo, tagnombre);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AmbitoGeografico> listAmbitoGeografico = this.ambitoGeograficoService
						.findAll(filterAmbitoGeografico, pagination);

				if (listAmbitoGeografico == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.ambitoGeograficoService
						.findAllCount(filterAmbitoGeografico);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAmbitoGeografico);
				return data;
			} else {
				List<AmbitoGeografico> listAmbitoGeografico = this.ambitoGeograficoService
						.findAll(filterAmbitoGeografico, pagination);
				if (listAmbitoGeografico == null) {
					throw new Exception("No data Found.");
				}
				return listAmbitoGeografico;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tagcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tagcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	AmbitoGeografico getById(@PathVariable() String tagcodigo) {
		try {
			AmbitoGeografico ambitoGeografico = new AmbitoGeografico();
			ambitoGeografico.setTagcodigo(tagcodigo);

			ambitoGeografico = this.ambitoGeograficoService
					.find(ambitoGeografico);
			if (ambitoGeografico == null) {
				throw new Exception(tagcodigo.toString());
			}
			return ambitoGeografico;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tagcodigo.toString());
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		AmbitoGeograficoController.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
