package com.ejie.y42b.jmsModule;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import com.ejie.y42b.jms.Y42bEnvioMailJMSService;

/**
 * Message-Driven Bean implementation class for: Y42bEnvioMailJMSModuleEJB
 *
 */
@MessageDriven(
		activationConfig = { @ActivationConfigProperty(
				propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, mappedName = "y42b.y42bEnvioMailQueue")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class Y42bEnvioMailJMSModuleEJB implements MessageListener {

	private static final Logger logger = LoggerFactory.getLogger(Y42bEnvioMailJMSModuleEJB.class);
	
	@Autowired
	private Y42bEnvioMailJMSService y42bEnvioMailJMSService;
	
    /**
     * Default constructor. 
     */
    public Y42bEnvioMailJMSModuleEJB() {
        // TODO Auto-generated constructor stub
    }
	
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message message) {
    	try {
    		Thread.sleep(1000);
    		y42bEnvioMailJMSService.onMessage(message);
		} catch(Throwable e_onMessage){
			logger.error("Y42bEnvioMailJMSModuleEJB.onMessage",
					e_onMessage);
		}
        
    }

}
