package com.ejie.y42b.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class Y42bTelefonoValidator implements
		ConstraintValidator<Y42bTelefono, String> {

	private static Pattern mask = Pattern.compile("[0-9]{9}");
	private static final int longitudCero = 0;

	@Override
	public void initialize(Y42bTelefono constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {

		if (value == null
				|| value.length() == Y42bTelefonoValidator.longitudCero) {
			return true;
		} else {
			Matcher matcher = mask.matcher(value);

			if (!matcher.matches()) {
				// No cumple el patrón
				return false;
			}

			return true;
		}

	}

}