package com.ejie.y42b.utils.jms;

import java.util.Hashtable;
import java.util.Properties;

import javax.jms.DeliveryMode;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.utils.config.Y42bConfig;

/**
 * Y42bClientEnvioMailJMS Cliente para cola JMS
 * 
 *  
 * 
 */
public class Y42bClientEnvioMailJMS {

	private static final Logger logger = LoggerFactory
			.getLogger(Y42bClientEnvioMailJMS.class);

	public static void sendMessage(String messageText) {
		InitialContext ctx = null;
		QueueConnectionFactory qcf = null;
		QueueConnection qc = null;
		QueueSession qsess = null;
		Queue q = null;
		QueueSender qsndr = null;
		TextMessage message = null;
		// NOTE: The next two lines set the name of the Queue Connection Factory
		// and the Queue that we want to use.
		Properties prop = Y42bConfig
				.loadProperties(Y42bAgendaConstantes.CONFIG_PATH);
		// SE especifica la ruta temporal de las remesas

		String QCF_NAME = prop.getProperty("jndi.jms.envioMailFactory");
		String QUEUE_NAME = prop.getProperty("jndi.jms.envioMailQueue");

		// create InitialContext
		Hashtable properties = new Hashtable();
		properties.put(Context.INITIAL_CONTEXT_FACTORY,
				"weblogic.jndi.WLInitialContextFactory");
		try {
			ctx = new InitialContext(properties);
		} catch (NamingException ne) {
			logger.error("Error JMS:" + ne.getMessage());
		}
		logger.debug("Got InitialContext " + ctx.toString());
		try {
			qcf = (QueueConnectionFactory) ctx.lookup(QCF_NAME);
		} catch (NamingException ne) {
			logger.error("Error JMS:" + ne.getMessage());
		}
		logger.debug("Got QueueConnectionFactory " + qcf.toString());
		try {
			qc = qcf.createQueueConnection();
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Got QueueConnection " + qc.toString());
		try {
			qsess = qc.createQueueSession(true, 0);
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Got QueueSession " + qsess.toString());
		try {
			q = (Queue) ctx.lookup(QUEUE_NAME);
		} catch (NamingException ne) {
			logger.error("Error JMS:" + ne.getMessage());
		}
		logger.debug("Got Queue " + q.toString());
		try {
			qsndr = qsess.createSender(q);
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Got QueueSender " + qsndr.toString());
		try {
			message = qsess.createTextMessage();
			message.setJMSExpiration(100000);
			message.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT);
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Got TextMessage " + message.toString());
		try {
			message.setText(messageText);
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Set text in TextMessage " + message.toString());
		try {
			qsndr.send(message);
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Sent message ");
		try {
			message = null;
			qsndr.close();
			qsndr = null;
			q = null;
			qsess.commit();
			qsess.close();
			qsess = null;
			qc.close();
			qc = null;
			qcf = null;
			ctx = null;
		} catch (JMSException jmse) {
			logger.error("Error JMS:" + jmse.getMessage());
		}
		logger.debug("Cleaned up and done.");
	}

}
