package com.ejie.y42b.utils.jdbc;

import java.sql.Blob;
import java.sql.SQLException;

public class Y42bJdbcUtils {
	private static Y42bJdbcUtils INSTANCE = null;

	// Private constructor suppresses
	private Y42bJdbcUtils() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y42bJdbcUtils();
		}
	}

	public static Y42bJdbcUtils getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Convierto un Blob a un byte[]
	 * 
	 * @param blob
	 * @return byte[]
	 */
	public static byte[] ConvertBlobToByte(Blob blob) {
		byte[] raw = null;

		try {

			raw = blob.getBytes(1, (int) blob.length());

		} catch (SQLException e) {
			return null;
		}

		return raw;
	}
}
