package com.ejie.y42b.utils.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;

public class Y42bConfig {

	private Y42bConfig() {
	}

	/**
	 * Static method to obtain properties
	 * 
	 * @param nombreFichero
	 * @return properties
	 */
	public static Properties loadProperties(String nombreFichero) {
		return getProperties(nombreFichero);

	}

	/**
	 * Método que carga el fichero de propiedades
	 * 
	 * @param nombreFichero
	 *            String
	 * @return Properties
	 */
	public static Properties getProperties(String nombreFichero) {

		String propertiesLog = nombreFichero;
		InputStream configLog = Y42bConfig.class
				.getResourceAsStream(propertiesLog);
		Properties pLog = new Properties();

		try {
			pLog.load(configLog);
		} catch (IOException e) {
			e.printStackTrace();
		}

		return pLog;
	}

	/**
	 * Devuelve el properties pasado por parametro del fichero de configuracion
	 * de la aplicacion (Y41bConstantes.CONFIG_PATH)
	 * 
	 * @param strPfClave
	 *            the strPfClave
	 * @return configAplication
	 */
	public static String getConfigAplicacion(final String strPfClave) {
		String resultado = null;
		if (strPfClave != null) {
			final Properties dokusiProp = loadProperties(Y42bAgendaConstantes.CONFIG_PATH);
			if (dokusiProp.containsKey(strPfClave)) {
				resultado = dokusiProp.getProperty(strPfClave);
			}
		}
		return resultado;
	}
}
