package com.ejie.y42b.utils;

import java.util.Iterator;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.model.Y42bTree;
import com.ejie.y42b.utils.beans.EntidadBean;

/**
 * 
 *  
 *
 */
public class Y42bProcessTree {

    /**
     * 
     */
    private String _activeNode = "";

    	/**
    	 * Nodo Activo
    	 * @param key String
    	 */
       public void setActiveNode(String key) {
	   this._activeNode = key;
         }
       
       /**
        * Nodo Activo
        * @return String
        */
       public String getActiveNode(){
	   return this._activeNode;
       }

    /**
     * Preseleccionar un nodo
     * 
     * @param key String
     * @return String
     */
    private String printNodeKey(String key) {
	if (this._activeNode.equals(key)) {
	    return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
		    + key + "\"";

	    // activate: false, // Initial active status.
	    // focus: false, // Initial focused status.
	    // expand: false, // Initial expanded status.
	    // select: false,

	} else {
	    if (this._activeNode.startsWith(key)) {
		// return "\"activate\": false, \"key\": \"" + key + "\"";
		return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
			+ key + "\"";
	    } else {
		return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
			+ key + "\"";
	    }

	}

    }

   // public static void main(String[] args) {

	// String json = getTestTree();
	// String sch = "\"key\": \"2.1\"";
	//
	// ObjectMapper mapper = new ObjectMapper();
	// Map<String, String> nameStruct = new HashMap<String, String>();
	// nameStruct.put("first", "Joe");
	// nameStruct.put("last", "Sixpack");
	// Map<String, Object> userData = new HashMap<String, Object>();
	// userData.put("name", nameStruct);
	// userData.put("gender", "MALE");
	// userData.put("verified", Boolean.FALSE);
	// userData.put("userImage", "Rm9vYmFyIQ==");
	// String jsonString = "";
	// try {
	// jsonString = mapper.writeValueAsString(userData);
	//
	// } catch (JsonGenerationException e) {
	// e.printStackTrace();
	// } catch (JsonMappingException e) {
	// e.printStackTrace();
	// } catch (IOException e) {
	// e.printStackTrace();
	// }
	// System.out.println("JSon: " + jsonString);
	//
	// if (json.indexOf(sch) > -1) {
	// System.out.println("OK");
	// } else {
	// System.out.println("Fail");
	// }

    //}

    /**
     * Obtiene estructura Json
     * @param _tree Y42bTree
     * @return String
     */
    public static String obtieneJsonArbol(Y42bTree _tree) {
	Y42bProcessTree t = new Y42bProcessTree();
	t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
		: "");

	return t.getTreeStructureStr(_tree);
    }

    /**
     * Obtiene estructura Json
     * @param tree Y42bTree
     * @return json tree
     */
    private String getTreeStructureStr(Y42bTree tree) {

	// Pintar arbolito
	StringBuffer aux = new StringBuffer();
	
	try {
	    aux.append("["); // [

	    Iterator<Y42bGrupo> itGr = tree.getLstGrupos().iterator();
	    Y42bGrupo grupo = null;
	    while (itGr.hasNext()) {
		grupo = itGr.next();
		aux.append(this.bloqueGrupos(grupo));
		if (itGr.hasNext()) {
		    aux.append(",");
		}
	    }
	    aux.append("]");
	} catch (Exception e1) {
	    e1.printStackTrace();
	}

	return aux.toString();
    }

    /**
     * BloqueGrupos
     * @param grupo Y42bGrupo
     * @return String
     */
    private String bloqueGrupos(Y42bGrupo grupo) {
	StringBuffer aux = new StringBuffer(Y42bAgendaConstantes.BUFFER_300);

	String key = "G_" + grupo.getGrupoId();
	if ((Y42bAgendaConstantes.NODO_RAIZ.equals(key))) {
	    aux.append("{\"title\": \""
		    + "<span class='arbol_grupo_root'>"
		    + Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(grupo.getNombreEs()),
		    		Y42bUtils.encodeHtmlTag(grupo.getNombreEu())) + "</span>" + "\", ");
	} else {
	    aux.append("{\"title\": \""
		    + Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(grupo.getNombreEs()),
		    		Y42bUtils.encodeHtmlTag(grupo.getNombreEu())) + "\", ");
	}

	aux.append("\"isFolder\": false, ");

	if ((Y42bAgendaConstantes.NODO_RAIZ.equals(key))) {
	    aux.append("\"addClass\": \"arbol_grupo_root\", ");
	} else {
	    aux.append("\"addClass\": \"arbol_grupo\", ");
	}

	aux.append(this.printNodeKey(key));

	if (grupo.getLstChildren().size() > 0) {
	    aux.append(",");
	    aux.append("\"children\": [");

	    Iterator<?> itGr = grupo.getLstChildren().iterator();
	    Object child = null;
	    while (itGr.hasNext()) {
		child = itGr.next();
		if (child instanceof Y42bGrupo) {
		    aux.append(this.bloqueGrupos((Y42bGrupo) child));
		} else {
		    aux.append(this.addChild(child));
		}
		if (itGr.hasNext()){aux.append(",");}
	    }
	    aux.append("]");

	}
	aux.append("}");

	return aux.toString();
    }

    /**
     * Añadir hijos
     * @param child Object
     * @return String
     */
    private String addChild(Object child) {
	EntidadBean entidad = null;
	StringBuffer aux = new StringBuffer();

	if (child instanceof Y42bGrupo) {

	    aux.append("{\"title\": \""
		    + Y42bUtils.printTreeLabel(
		    		Y42bUtils.encodeHtmlTag(((Y42bGrupo) child).getNombreEs()),
		    		Y42bUtils.encodeHtmlTag(((Y42bGrupo) child).getNombreEu())) + "\",");
	    aux.append("\"isFolder\": false, ");
	    String key = "G_" + ((Y42bGrupo) child).getGrupoId();
	    aux.append("\"addClass\": \"arbol_grupo\", ");
	    aux.append(this.printNodeKey(key));
	    aux.append("}");

	} else if (child instanceof EntidadBean) {

	    entidad = (EntidadBean) child;

	    if (Y42bAgendaConstantes.NO.equals(entidad.getActiva())) {
		aux.append("{\"title\": \""
			+ "<span class='arbol_entidad_noActiva'>"
			+ Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(entidad.getNombreEs()),
					Y42bUtils.encodeHtmlTag(entidad.getNombreEu())) + "</span>" + "\", ");
	    } else {
		aux.append("{\"title\": \""
			+ "<span class='arbol_entidad'>"				
			+ Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(entidad.getNombreEs()),
					Y42bUtils.encodeHtmlTag(entidad.getNombreEu())) + "</span>" + "\",");
	    }

	    StringBuffer key = new StringBuffer(Y42bAgendaConstantes.NUM_128);
	    key.append("G_");
	    key.append(entidad.getGrupoId());
	    key.append("#");
	    key.append("E_");
	    key.append(entidad.getEntidadId());


	    aux.append(this.printNodeKey(key.toString()));
	    aux.append(this.addChild(entidad));

	    aux.append("}");

	}

	return aux.toString();
    }

    /**
     * 
     * @param entidad EntidadBean
     * @return addChild
     */
    private String addChild(EntidadBean entidad) {

	StringBuffer aux = new StringBuffer(Y42bAgendaConstantes.NUM_128);
	if (entidad.getContactos() != null) {
	    if (entidad.getContactos().size() > 0) {
		aux.append(",");
		aux.append("\"children\": [");
		Iterator<Contacto> itGr = entidad.getContactos().iterator();
		Contacto contacto = null;
		while (itGr.hasNext()) {
		    contacto = (Contacto) itGr.next();
		    aux.append("{\"title\": \""
			    + Y42bUtils.printTreeLabel(contacto.getNombre(),
				    contacto.getNombre()) + "\",");
		    aux.append("\"isFolder\": false, ");
		    StringBuffer key = new StringBuffer(Y42bAgendaConstantes.NUM_128);//NOPMD 2012/02/29 (IDA) 
		    key.append("G_");
		    key.append(entidad.getGrupoId());
		    key.append("#");
		    key.append("E_");
		    key.append(contacto.getEntidadId());
		    key.append("#");
		    key.append("C_");
		    key.append(contacto.getContactoId());
		    aux.append(this.printNodeKey(key.toString()));
		    aux.append("}");

		    if (itGr.hasNext()){aux.append(",");}
			
		}
		aux.append("]");
	    }
	}
	return aux.toString();
    }

  
}
