package com.ejie.y42b.utils;

import com.ejie.y42b.model.Localizacion;
import com.ejie.y42b.model.T17Calle;
import com.ejie.y42b.model.T17Localidad;
import com.ejie.y42b.model.T17Municipio;
import com.ejie.y42b.model.T17Pais;
import com.ejie.y42b.model.T17Provincia;
import com.ejie.y42b.service.T17CalleService;
import com.ejie.y42b.service.T17LocalidadService;
import com.ejie.y42b.service.T17MunicipioService;
import com.ejie.y42b.service.T17PaisService;
import com.ejie.y42b.service.T17ProvinciaService;

/**
 * 
 *  
 *
 */
public class Y42bLocalizacion {
    	
    	private static T17PaisService paisService;
	private static T17ProvinciaService provinciaService;
	private static T17MunicipioService municipioService;
	private static T17LocalidadService localidadService;
	private static T17CalleService calleService;
    
    
	/**
	 * @return the paisService
	 */
	public static T17PaisService getPaisService() {
	    return Y42bLocalizacion.paisService;
	}

	/**
	 * @param paisService the paisService to set
	 */
	public static void setPaisService(T17PaisService paisService) {
	    Y42bLocalizacion.paisService = paisService;
	}

	/**
	 * @return the provinciaService
	 */
	public static T17ProvinciaService getProvinciaService() {
	    return Y42bLocalizacion.provinciaService;
	}

	/**
	 * @param provinciaService the provinciaService to set
	 */
	public static void setProvinciaService(T17ProvinciaService provinciaService) {
	    Y42bLocalizacion.provinciaService = provinciaService;
	}

	/**
	 * @return the municipioService
	 */
	public static T17MunicipioService getMunicipioService() {
	    return Y42bLocalizacion.municipioService;
	}

	/**
	 * @param municipioService the municipioService to set
	 */
	public static void setMunicipioService(T17MunicipioService municipioService) {
	    Y42bLocalizacion.municipioService = municipioService;
	}

	/**
	 * @return the localidadService
	 */
	public static T17LocalidadService getLocalidadService() {
	    return Y42bLocalizacion.localidadService;
	}

	/**
	 * @param localidadService the localidadService to set
	 */
	public static void setLocalidadService(T17LocalidadService localidadService) {
	    Y42bLocalizacion.localidadService = localidadService;
	}

	/**
	 * @return the calleService
	 */
	public static T17CalleService getCalleService() {
	    return Y42bLocalizacion.calleService;
	}

	/**
	 * @param calleService the calleService to set
	 */
	public static void setCalleService(T17CalleService calleService) {
	    Y42bLocalizacion.calleService = calleService;
	}

	/**
	 * Constructor.
	 * @param pPaisService T17PaisService
	 * @param pProvinciaService T17ProvinciaService
	 * @param pMunicipioService T17MunicipioService
	 * @param pLocalidadService T17LocalidadService
	 * @param pCalleService T17CalleService
	 */
	public Y42bLocalizacion(
		T17PaisService pPaisService,
		T17ProvinciaService pProvinciaService,
		T17MunicipioService pMunicipioService,
		T17LocalidadService pLocalidadService,
		T17CalleService pCalleService
		) {
	    
	    super();
	    Y42bLocalizacion.setPaisService(pPaisService);
	    Y42bLocalizacion.setProvinciaService(pProvinciaService);
	    Y42bLocalizacion.setMunicipioService(pMunicipioService);
	    Y42bLocalizacion.setLocalidadService(pLocalidadService);
	    Y42bLocalizacion.setCalleService(pCalleService);
	    //Y42bLocalizacion.paisService = pPaisService;
	    //Y42bLocalizacion.provinciaService=pProvinciaService;
	    //Y42bLocalizacion.municipioService=pMunicipioService;
	    //Y42bLocalizacion.localidadService=pLocalidadService;
	    ///Y42bLocalizacion.calleService=pCalleService;
	}

    	/**
	 * Localización completa
	 * @param localizacion loclaizacion
	 * @return localizacion
	 */
	public Localizacion setLocalizacion(Localizacion localizacion){ 
	
	  
	    	
    	T17Pais t17Pais = new T17Pais();
    	try {
    	    t17Pais.setId(localizacion.getPaisId());
    	    t17Pais = Y42bLocalizacion.paisService.find(t17Pais);
    	    localizacion.setPaisNombre(t17Pais.getDsO());
    	} catch (Exception e) {
    	    localizacion.setPaisNombre("");
    	    
    	}
    	
    	T17Provincia t17Provincia = new T17Provincia();
    	try {
    	    t17Provincia.setId(localizacion.getProvinciaId());
    	    t17Provincia = Y42bLocalizacion.provinciaService.find(t17Provincia);
    	    localizacion.setProvinciaNombre(t17Provincia.getDsO());	
    	} catch (Exception e1) {
    	    	localizacion.setProvinciaNombre("");
    	}
    	
    	T17Municipio t17Municipio = new T17Municipio();
    	try {
    	    t17Municipio.setId(localizacion.getMunicipioId());
    	    t17Municipio.setProvinciaId(t17Provincia.getId());
    	    t17Municipio = Y42bLocalizacion.municipioService.find(t17Municipio);
    	    localizacion.setMunicipioNombre(t17Municipio.getDsO());
    	    
    	} catch (Exception e){
    	    	localizacion.setMunicipioNombre("");
    	}
    	
    	T17Localidad t17Localidad = new T17Localidad();
    	try { 
    	    t17Localidad.setId(localizacion.getLocalidadId());
    	    t17Localidad = Y42bLocalizacion.localidadService.find(t17Localidad);
    	    localizacion.setLocalidadNombre(t17Localidad.getDsO());
    	 } catch(Exception e){
    	     	localizacion.setLocalidadNombre("");
    	    }
    	
    	T17Calle t17Calle = new T17Calle();
    	try{
    	    t17Calle.setId(Long.parseLong(localizacion.getCalleId()));
    	    t17Calle = Y42bLocalizacion.calleService.find(t17Calle);
    	    localizacion.setCalleNombre(t17Calle.getDsO());
    	  } catch (Exception e){
    		localizacion.setCalleNombre("");
    	  }
    	    
    	    
    	    
    	    return localizacion;
    	
	}	

}
