package com.ejie.y42b.utils;

import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Envio;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Grupo;
import com.ejie.y42b.model.Item;
import com.ejie.y42b.model.Localizacion;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.service.ContactoService;
import com.ejie.y42b.service.EntidadService;
import com.ejie.y42b.service.T17CalleService;
import com.ejie.y42b.service.T17LocalidadService;
import com.ejie.y42b.service.T17MunicipioService;
import com.ejie.y42b.service.T17PaisService;
import com.ejie.y42b.service.T17ProvinciaService;
import com.ejie.y42b.service.Y42bGruposService;

/**
 *  
 */
public class Y42bExcelGenerator {

	// @Autowired
	private Y42bGruposService groupService;

	// @Autowired
	private EntidadService entityService;

	// @Autowired
	private ContactoService contactService;

	private T17PaisService paisService;
	private T17ProvinciaService provinciaService;
	private T17MunicipioService municipioService;
	private T17LocalidadService localidadService;
	private T17CalleService calleService;

	private static final Logger logger = LoggerFactory
			.getLogger(Y42bExcelGenerator.class);

	/**
	 * Constructor
	 * 
	 * @param groupService
	 *            Y42bGruposService
	 * @param entityService
	 *            EntidadService
	 * @param contactService
	 *            ContactoService
	 * @param paisService
	 *            T17PaisService
	 * @param provinciaService
	 *            T17ProvinciaService
	 * @param municipioService
	 *            T17MunicipioService
	 * @param localidadService
	 *            T17LocalidadService
	 * @param calleService
	 *            T17CalleService
	 */
	public Y42bExcelGenerator(Y42bGruposService groupService,
			EntidadService entityService, ContactoService contactService,
			T17PaisService paisService, T17ProvinciaService provinciaService,
			T17MunicipioService municipioService,
			T17LocalidadService localidadService, T17CalleService calleService) {

		super();
		this.groupService = groupService;
		this.entityService = entityService;
		this.contactService = contactService;
		this.paisService = paisService;
		this.provinciaService = provinciaService;
		this.municipioService = municipioService;
		this.localidadService = localidadService;
		this.calleService = calleService;
	}

	/**
	 * Genera un tabla html para devolver como excel con los items seleccionados
	 * del envio.
	 * 
	 * @param envio
	 *            Envio
	 * @param items
	 *            List<Item>
	 * @param tipoExcel
	 *            String
	 * @return String
	 */
	public String getExcel(Envio envio, List<Item> items, String tipoExcel) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table>");

		if (Y42bAgendaConstantes.AVD_SEARCH_TYPE_ENTITY.equals(envio.getTipo())) {
			if (tipoExcel.equalsIgnoreCase("EG")) {
				xslString.append(this.getEntityListTable(items));
			} else if (tipoExcel.equalsIgnoreCase("E")) {
				xslString.append(this.getEntityListTableSinGrupos(items));
			}
		} else {
			xslString.append(this.getContactListTable(items));
		}
		xslString.append("</table>");
		Y42bExcelGenerator.logger
				.debug("****************************************");
		Y42bExcelGenerator.logger.debug(xslString.toString());
		Y42bExcelGenerator.logger
				.debug("****************************************");
		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param items
	 *            List<Item> items
	 * @return String
	 */
	private String getEntityListTable(final List<Item> items) {
		StringBuffer xslString = new StringBuffer();
		// add header
		xslString.append(Y42bExcelGenerator.getEntityHeaderRow());

		// add entities
		String grupo_es = "";
		String grupo_eu = "";
		Y42bGrupo gNew = new Y42bGrupo();
		// gNew.setActiva(Y42bAgendaConstantes.SI);
		Entidad entity = new Entidad();
		Etiqueta newEtiqueta = new Etiqueta();
		Localizacion localizacion = null;
		Y42bLocalizacion loc = new Y42bLocalizacion(this.paisService,
				this.provinciaService, this.municipioService,
				this.localidadService, this.calleService);
		localizacion = new Localizacion();
		for (Item item : items) {
			entity.setEntidadId(item.getItemRef());
			entity = this.entityService.find(entity);
			entity = this.entityService.findGrupoEntidad(entity, gNew, null);
			entity = this.entityService.findEtiquetaEntidad(entity,
					newEtiqueta, null);

			localizacion.setPaisId(entity.getNoraPaisId());
			localizacion.setProvinciaId(entity.getNoraProvinciaId());
			localizacion.setMunicipioId(entity.getNoraMunicipioId());
			localizacion.setLocalidadId(entity.getNoraLocalidadId());
			localizacion.setCalleId(entity.getNoraCalleId());

			localizacion = loc.setLocalizacion(localizacion);

			entity.setNombrePais(localizacion.getPaisNombre());
			entity.setNombreProvincia(localizacion.getProvinciaNombre());
			entity.setNombreMunicipio(localizacion.getMunicipioNombre());
			entity.setNombreLocalidad(localizacion.getLocalidadNombre());
			if (entity.getNoraCalleId() != null) {
				entity.setNombreCalle(localizacion.getCalleNombre());
			}

			for (Grupo grupo : entity.getGrupos()) {
				Y42bGrupo compGr = this.getCompositeGroup(grupo);

				grupo_es = compGr.getNombreEs();
				grupo_eu = compGr.getNombreEu();
				if (grupo_es.startsWith(" >> ")) {
					grupo_es = grupo_es.substring(Y42bAgendaConstantes.NUM_3); // Quita
																				// los
																				// caracteres
																				// >>
																				// del
																				// comienzo
				}
				if (grupo_eu.startsWith(" >> ")) {
					grupo_eu = grupo_eu.substring(Y42bAgendaConstantes.NUM_3); // Quita
																				// los
																				// caracteres
																				// >>
																				// del
																				// comienzo
				}

				grupo.setNombreEs(grupo_es);
				grupo.setNombreEu(grupo_eu);

				xslString
						.append(Y42bExcelGenerator.getEntityRow(grupo, entity));

			}
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param items
	 *            List<Item>
	 * @return String
	 */
	private String getContactListTable(final List<Item> items) {
		StringBuffer xslString = new StringBuffer();
		// add header
		xslString.append(Y42bExcelGenerator.getContactHeaderRow());
		// add contacts
		Etiqueta newEtiqueta = new Etiqueta();
		Contacto contact = new Contacto();
		Entidad newEntidad = new Entidad();
		Y42bGrupo newGrupo = new Y42bGrupo();

		Y42bLocalizacion loc = new Y42bLocalizacion(this.paisService,
				this.provinciaService, this.municipioService,
				this.localidadService, this.calleService);
		Localizacion localizacion = new Localizacion();
		for (Item item : items) {

			contact.setContactoId(item.getItemRef());
			contact = this.contactService.find(contact);
			contact = this.contactService.findEntidadContacto(contact,
					newEntidad, null);

			localizacion.setPaisId(contact.getNoraPaisId());
			localizacion.setProvinciaId(contact.getNoraProvinciaId());
			localizacion.setMunicipioId(contact.getNoraMunicipioId());
			localizacion.setLocalidadId(contact.getNoraLocalidadId());
			localizacion.setCalleId(contact.getNoraCalleId());

			localizacion = loc.setLocalizacion(localizacion);

			contact.setNombrePais(localizacion.getPaisNombre());
			contact.setNombreProvincia(localizacion.getProvinciaNombre());
			contact.setNombreMunicipio(localizacion.getMunicipioNombre());
			contact.setNombreLocalidad(localizacion.getLocalidadNombre());
			if (contact.getNoraCalleId() != null) {
				contact.setNombreCalle(localizacion.getCalleNombre());
			}

			for (Entidad entity : contact.getEntidads()) {
				entity = this.entityService.findGrupoEntidad(entity, newGrupo,
						null);
				entity = this.entityService.findEtiquetaEntidad(entity,
						newEtiqueta, null);

				for (Grupo grupo : entity.getGrupos()) {
					Y42bGrupo compGr = this.getCompositeGroup(grupo);
					grupo.setNombreEs(compGr.getNombreEs());
					grupo.setNombreEu(compGr.getNombreEu());

					xslString.append(Y42bExcelGenerator.getContactRow(grupo,
							entity, contact));
				}
			}
		}

		return xslString.toString();
	}

	/**
	 * Compone datos de grupo con jerarquia completa.
	 * 
	 * @param pGrupo
	 *            grupo
	 * @return grupo
	 */
	private Y42bGrupo getCompositeGroup(final Grupo pGrupo) {
		// Añade a grupo.nombre la jerarquia correspondiente si la tiene
		// Solo devuelve informados los campos de nombre
		Y42bGrupo grupo = new Y42bGrupo();
		grupo.setGrupoId(pGrupo.getGrupoId());
		grupo.setPadreId(pGrupo.getGrupoPadreId());
		return this.groupService.findJerarquia(grupo);

	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private static String getEntityHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr>");
		header.append(Y42bExcelGenerator.getGroupHeaderRowFields());
		header.append(Y42bExcelGenerator.getEntityHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * 
	 * @return String
	 */
	private static String getContactHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr>");
		header.append(Y42bExcelGenerator.getContactHeaderRowFields());
		header.append(Y42bExcelGenerator.getGroupHeaderRowFields());
		header.append(Y42bExcelGenerator.getEntityHeaderRowFields());
		// header.append(Y42bExcelGenerator.getContactHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera cabecera para grupos
	 * 
	 * @return fields
	 */
	private static String getGroupHeaderRowFields() {
		StringBuffer fields = new StringBuffer();
		// TODO cabeceras segun idioma????
		// Locale locale = LocaleContextHolder.getLocale();

		// fields.append(Y42bExcelGenerator.getHeaderField("grupoId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombre"));

		return fields.toString();
	}

	/**
	 * Genera cebeceras para entidades
	 * 
	 * @return fields
	 */
	private static String getEntityHeaderRowFields() {
		StringBuffer fields = new StringBuffer();
		// TODO cabeceras segun idioma????
		// Locale locale = LocaleContextHolder.getLocale();

		fields.append(Y42bExcelGenerator.getHeaderField("codOrg"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreEs"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreEu"));
		fields.append(Y42bExcelGenerator.getHeaderField("activa"));
		fields.append(Y42bExcelGenerator.getHeaderField("iskontsumogest"));
		fields.append(Y42bExcelGenerator.getHeaderField("iskontsumonet"));
		fields.append(Y42bExcelGenerator.getHeaderField("isofertaform"));
		fields.append(Y42bExcelGenerator.getHeaderField("isconsultasweb"));
		fields.append(Y42bExcelGenerator.getHeaderField("observaciones"));
		fields.append(Y42bExcelGenerator.getHeaderField("telefono"));
		fields.append(Y42bExcelGenerator.getHeaderField("fax"));
		fields.append(Y42bExcelGenerator.getHeaderField("email"));
		fields.append(Y42bExcelGenerator.getHeaderField("url"));
		fields.append(Y42bExcelGenerator.getHeaderField("usuario"));
		fields.append(Y42bExcelGenerator.getHeaderField("password"));
		fields.append(Y42bExcelGenerator.getHeaderField("isnacional"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraPaisId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombrePais"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraProvinciaId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreProvincia"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraMunicipioId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreMunicipio"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraLocalidadId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreLocalidad"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraCalleId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreCalle"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraCpId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreCp"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraPortalId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombrePortal"));
		fields.append(Y42bExcelGenerator.getHeaderField("usuultmod"));
		fields.append(Y42bExcelGenerator.getHeaderField("fecultmod"));
		fields.append(Y42bExcelGenerator.getHeaderField("etiquetas"));
		fields.append(Y42bExcelGenerator.getHeaderField("entidadId"));

		return fields.toString();
	}

	/**
	 * Generar cabeceras de contactos.
	 * 
	 * @return getContacts
	 */
	private static String getContactHeaderRowFields() {
		StringBuffer fields = new StringBuffer();
		// TODO cabeceras segun idioma????
		// Locale locale = LocaleContextHolder.getLocale();

		fields.append(Y42bExcelGenerator.getHeaderField("contactoId"));

		fields.append(Y42bExcelGenerator.getHeaderField("nombre"));
		fields.append(Y42bExcelGenerator.getHeaderField("cargo"));
		fields.append(Y42bExcelGenerator.getHeaderField("telefono"));
		fields.append(Y42bExcelGenerator.getHeaderField("fax"));
		fields.append(Y42bExcelGenerator.getHeaderField("email"));
		fields.append(Y42bExcelGenerator.getHeaderField("url"));
		fields.append(Y42bExcelGenerator.getHeaderField("isnacional"));
		fields.append(Y42bExcelGenerator.getHeaderField("usuultmod"));
		fields.append(Y42bExcelGenerator.getHeaderField("fecultmod"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombrePais"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraProvinciaId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreProvincia"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraMunicipioId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreMunicipio"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraLocalidadId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreLocalidad"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraCalleId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreCalle"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraCpId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombreCp"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraPortalId"));
		fields.append(Y42bExcelGenerator.getHeaderField("nombrePortal"));
		// fields.append(Y42bExcelGenerator.getHeaderField("noraPaisId"));

		// fields.append(Y42bExcelGenerator.getHeaderField("entidadId"));
		return fields.toString();
	}

	/**
	 * Generar cabeceras.
	 * 
	 * @param fieldName
	 *            String
	 * @return String
	 */
	private static String getHeaderField(String fieldName) {
		StringBuffer field = new StringBuffer();
		field.append("<th>");
		field.append(Y42bUtils.normalizarVacio(fieldName));
		field.append("</th>");
		return field.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param group
	 *            Grupo
	 * @param entity
	 *            Entidad
	 * @return String
	 */
	private static String getEntityRow(Grupo group, Entidad entity) {
		StringBuffer row = new StringBuffer();
		if (entity.getActiva().equalsIgnoreCase(Y42bAgendaConstantes.NO)) {
			row.append("<tr style='color: #ff0000'>");
		} else {
			row.append("<tr>");
		}
		row.append(Y42bExcelGenerator.getGroup(group));
		row.append(Y42bExcelGenerator.getEntity(group.getGrupoId(), entity));
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param group
	 *            Grupo
	 * @param entity
	 *            Entidad
	 * @param contact
	 *            Contacto
	 * @return getContactsRow
	 */
	private static String getContactRow(Grupo group, Entidad entity,
			Contacto contact) {
		StringBuffer row = new StringBuffer();
		if (entity.getActiva().equalsIgnoreCase(Y42bAgendaConstantes.NO)) {
			row.append("<tr style='color: #ff0000'>");
		} else {
			row.append("<tr>");
		}
		row.append(Y42bExcelGenerator.getContact(contact));
		row.append(Y42bExcelGenerator.getGroup(group));
		row.append(Y42bExcelGenerator.getEntity(group.getGrupoId(), entity));
		// row.append(Y42bExcelGenerator.getContact(contact));
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * 
	 * @param group
	 *            Grupo
	 * @return String
	 */
	private static String getGroup(Grupo group) {
		StringBuffer fields = new StringBuffer();

		Locale locale = LocaleContextHolder.getLocale();
		String name = null;
		if (Y42bAgendaConstantes.CASTELLANO.equals(locale.getLanguage())) {
			name = group.getNombreEs();
		} else {
			name = group.getNombreEu();
		}

		// fields.append(Y42bExcelGenerator.getField(group.getGrupoId()));
		fields.append(Y42bExcelGenerator.getField(name));

		return fields.toString();
	}

	/**
	 * @param grupoId
	 *            String
	 * @param entity
	 *            Entidad
	 * @return String
	 */
	private static String getEntity(String grupoId, Entidad entity) {
		StringBuffer fields = new StringBuffer();

		String isNacional = Y42bAgendaConstantes.DB_TRUE.equals(entity
				.getIsnacional()) ? "Si" : "No";
		String isKontsumoGest = Y42bAgendaConstantes.DB_TRUE.equals(entity
				.getIskontsumogest()) ? "Si" : "No";
		String isKontsumoNet = Y42bAgendaConstantes.DB_TRUE.equals(entity
				.getIskontsumonet()) ? "Si" : "No";
		String isOfertaFormativa = Y42bAgendaConstantes.DB_TRUE.equals(entity
				.getIsofertaform()) ? "Si" : "No";
		String isConsultaWeb = Y42bAgendaConstantes.DB_TRUE.equals(entity
				.getIsconsultasweb()) ? "Si" : "No";

		String connector = "";
		StringBuffer labels = new StringBuffer();
		for (Etiqueta label : entity.getEtiquetas()) {
			labels.append((connector + label.getNombre()));
			if ("".equals(connector)) {
				connector = ",";
			}
		}

		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getCodOrg())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombreEs())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombreEu())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getActiva())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(isKontsumoGest)));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(isKontsumoNet)));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(isOfertaFormativa)));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(isConsultaWeb)));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getObservaciones())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getTelefono())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getFax())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getEmail())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getUrl())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getUsuario())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getPassword())));
		fields.append(Y42bExcelGenerator.getField(isNacional));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(entity.getNoraPaisId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombrePais())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(entity.getNoraProvinciaId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombreProvincia())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(entity.getNoraMunicipioId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombreMunicipio())));
		// fields.append(Y42bExcelGenerator.getField("'"
		// + Y42bUtils.normalizarVacio(entity.getNoraLocalidadId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombreLocalidad())));
		// fields.append(Y42bExcelGenerator.getField("'"
		// + Y42bUtils.normalizarVacio(entity.getNoraCalleId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombreCalle())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(entity.getNoraCpId+())));
		fields.append(Y42bExcelGenerator.getFieldTexto(Y42bUtils
				.normalizarVacio(entity.getNombreCp())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(entity.getNoraPortalId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getNombrePortal())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getUsuultmod())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getFecultmod() + "")));
		fields.append(Y42bExcelGenerator.getField(labels.toString()));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(entity.getEntidadId())));

		return fields.toString();
	}

	/**
	 * 
	 * @param contact
	 *            Contacto
	 * @return String
	 */
	private static String getContact(Contacto contact) {
		StringBuffer fields = new StringBuffer();
		String isNacional = Y42bAgendaConstantes.DB_TRUE.equals(contact
				.getIsnacional()) ? "Si" : "No";

		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getContactoId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombre())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getCargo())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getTelefono())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getFax())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getEmail())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getUrl())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(isNacional)));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getUsuultmod())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getFecultmod() + "")));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombrePais())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(contact.getNoraProvinciaId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombreProvincia())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(contact.getNoraMunicipioId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombreMunicipio())));
		// fields.append(Y42bExcelGenerator.getField("'"
		// + Y42bUtils.normalizarVacio(contact.getNoraLocalidadId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombreLocalidad())));
		// fields.append(Y42bExcelGenerator.getField("'"
		// + Y42bUtils.normalizarVacio(contact.getNoraCalleId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombreCalle())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(contact.getNoraCpId())));
		fields.append(Y42bExcelGenerator.getFieldTexto(Y42bUtils
				.normalizarVacio(contact.getNombreCp())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(contact.getNoraPortalId())));
		fields.append(Y42bExcelGenerator.getField(Y42bUtils
				.normalizarVacio(contact.getNombrePortal())));
		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(contact.getNoraPaisId())));

		// fields.append(Y42bExcelGenerator.getField(Y42bUtils
		// .normalizarVacio(contact.getEntidadId())));

		return fields.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getField(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		// field.append("'"); // Añade comilla para convertir todos los valores
		// a
		// formato de texto en Excel
		// field.append(Y42bUtils.ConvertToISO(Y42bUtils.normalizarVacio(fieldValue)));
		field.append(Y42bUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldTexto(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>=ESPACIOS(\"");
		field.append(Y42bUtils.normalizarVacio(fieldValue));
		field.append("\")</td>");
		return field.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param items
	 *            List<Item> items
	 * @return String
	 */
	private String getEntityListTableSinGrupos(final List<Item> items) {
		StringBuffer xslString = new StringBuffer();
		// add header
		xslString.append(Y42bExcelGenerator.getEntitySinGruposHeaderRow());

		Entidad entity = new Entidad();
		Etiqueta newEtiqueta = new Etiqueta();
		Localizacion localizacion = null;
		Y42bLocalizacion loc = new Y42bLocalizacion(this.paisService,
				this.provinciaService, this.municipioService,
				this.localidadService, this.calleService);
		localizacion = new Localizacion();
		for (Item item : items) {
			entity.setEntidadId(item.getItemRef());
			entity = this.entityService.find(entity);
			// entity = this.entityService.findGrupoEntidad(entity, gNew, null);
			entity = this.entityService.findEtiquetaEntidad(entity,
					newEtiqueta, null);

			localizacion.setPaisId(entity.getNoraPaisId());
			localizacion.setProvinciaId(entity.getNoraProvinciaId());
			localizacion.setMunicipioId(entity.getNoraMunicipioId());
			localizacion.setLocalidadId(entity.getNoraLocalidadId());
			localizacion.setCalleId(entity.getNoraCalleId());

			localizacion = loc.setLocalizacion(localizacion);

			entity.setNombrePais(localizacion.getPaisNombre());
			entity.setNombreProvincia(localizacion.getProvinciaNombre());
			entity.setNombreMunicipio(localizacion.getMunicipioNombre());
			entity.setNombreLocalidad(localizacion.getLocalidadNombre());
			if (entity.getNoraCalleId() != null) {
				entity.setNombreCalle(localizacion.getCalleNombre());
			}

			xslString.append(Y42bExcelGenerator.getEntitySinGruposRow(entity));

		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private static String getEntitySinGruposHeaderRow() {
		StringBuffer header = new StringBuffer();
		header.append("<tr>");
		header.append(Y42bExcelGenerator.getEntityHeaderRowFields());
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param entity
	 *            Entidad
	 * @return String
	 */
	private static String getEntitySinGruposRow(Entidad entity) {
		StringBuffer row = new StringBuffer();
		if (entity.getActiva().equalsIgnoreCase(Y42bAgendaConstantes.NO)) {
			row.append("<tr style='color: #ff0000'>");
		} else {
			row.append("<tr>");
		}
		row.append(Y42bExcelGenerator.getEntity(null, entity));
		row.append("</tr>");
		return row.toString();
	}

}
