package com.ejie.y42b.utils;

import java.util.List;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Etiqueta;

/**
 * 
 *  
 * 
 */
public class Y42bEtiquetasTree {

	/**
         * 
         */
	private Y42bEtiquetasTree() {

	}

	/**
	 * Obtiene estructura Json para el arbol
	 * 
	 * @param lstEtiquetas
	 *            List<Etiqueta>
	 * @param selectedIdList
	 *            List<String>
	 * @return sb
	 */
	public static String obtieneJsonArbol(List<Etiqueta> lstEtiquetas,
			List<String> selectedIdList) {
		StringBuffer sb = new StringBuffer(Y42bAgendaConstantes.BUFFER_300);

		String key = "";

		sb.append("[");

		for (Etiqueta etiqueta : lstEtiquetas) {
			key = etiqueta.getEtiquetaId();

			sb.append("{\"title\": \""
					+ Y42bUtils.encodeHtmlTag(etiqueta.getNombre()) + "\",");
			if (selectedIdList.contains(key)) {
				sb.append("\"select\": true, ");
			}
			sb.append("\"key\": \"" + key + "\"");
			sb.append("}");

			if (!etiqueta.equals(lstEtiquetas.get(lstEtiquetas.size() - 1))) {
				sb.append(",");
			}
		}
		sb.append("]");

		return sb.toString();
	}

}
