package com.ejie.y42b.utils;

import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.model.Y42bTree;

/**
 * 
 *  
 *
 */
public class Y42bEntityGroupTree {
    
    private static final Logger logger = LoggerFactory
    .getLogger(Y42bEntityGroupTree.class);
    
    /**
     * 
     */
    private String activeNode = "";


    /**
     * @return the _activeNode
     */
    public String getActiveNode() {
        return this.activeNode;
    }


    /**
     * @param activeNode the _activeNode to set
     */
    public void setActiveNode(String activeNode) {
        this.activeNode = activeNode;
    }


    /**
     * Preseleccionar un nodo
     * 
     * @param key String
     * @param selectedIdList List<String> selectedIdList
     * @return ""
     */
    private String printNodeKey(String key, List<String> selectedIdList) {

	if (selectedIdList.contains(key)) {
	    return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": true, \"key\": \""
		    + key + "\"";

	    // activate: false, // Initial active status.
	    // focus: false, // Initial focused status.
	    // expand: false, // Initial expanded status.
	    // select: false,

	} else {
	    return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
		    + key + "\"";

	}

    }


    /**
     * Obtiene Json
     * @param _tree Y42bTree
     * @param selectedList List<String>
     * @return String
     */
    public static String obtieneJsonArbol(Y42bTree _tree, List<String> selectedList) {
	Y42bEntityGroupTree t = new Y42bEntityGroupTree();
	t.activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
		: "");

	return t.getTreeStructureStr(_tree,selectedList);
    }

    /**
     * 
     * @param tree Y42bTree
     * @param selectedList List<String>
     * @return json
     */
    private String getTreeStructureStr(Y42bTree tree,List<String> selectedList) {

	// Pintar arbolito
	StringBuffer aux = new StringBuffer();
	
	try {
	    aux.append("["); // [

	    Iterator<Y42bGrupo> itGr = tree.getLstGrupos().iterator();
	    Y42bGrupo grupo = null;
	    while (itGr.hasNext()) {
		grupo = itGr.next();
		aux.append(this.bloqueGrupos(grupo,selectedList));
		if (itGr.hasNext()) {
		    aux.append(",");
		}
	    }
	    aux.append("]");
	} catch (Exception e1) {
	    e1.printStackTrace();
	}
	//System.out.println("Arbol: " + aux.toString());
	
	return aux.toString();
    }

    /**
     * 
     * @param grupo y42bGrupo
     * @param selectedList List<String> 
     * @return String
     */
    private String bloqueGrupos(Y42bGrupo grupo,List<String> selectedList) {
	StringBuffer aux = new StringBuffer(Y42bAgendaConstantes.BUFFER_300);

	String key = grupo.getGrupoId();
	aux.append("{\"title\": \""
		    + Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(grupo.getNombreEs()),
		    		Y42bUtils.encodeHtmlTag(grupo.getNombreEu())) + "\", ");
		aux.append("\"isFolder\": false, ");

	aux.append("\"addClass\": \"arbol_grupo\", ");
	aux.append(this.printNodeKey(key,selectedList));

	StringBuffer auxChild=new StringBuffer();
	boolean bChildren=false;
	String childJson="";
	if (grupo.getLstChildren().size() > 0) {
	    auxChild.append(",");
	    auxChild.append("\"children\": [");

	    Iterator<?> itGr = grupo.getLstChildren().iterator();
	    Object child = null;
	    
	    while (itGr.hasNext()) {
		child = itGr.next();
		if (child instanceof Y42bGrupo) {
		    
		    auxChild.append(this.bloqueGrupos(((Y42bGrupo) child),selectedList));
		    auxChild.append(",");
		    bChildren = true;
		}
		    
	    }
	    
	    childJson=auxChild.toString();
	    
	    

	}
	if (bChildren){
	    //Quita último caracter
	    StringBuffer jsonaux=new StringBuffer(Y42bAgendaConstantes.NUM_128);
	    childJson = childJson.substring(0,childJson.length()-1);
	    jsonaux.append(childJson);
	    jsonaux.append("]");
	    aux.append(jsonaux.toString());
	  
	    
	}
	aux.append("}");
	
	Y42bEntityGroupTree.logger.debug(aux.toString());
	
	return aux.toString();
    }

  
}
