package com.ejie.y42b.utils;

import java.util.List;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.model.Y42bTree;
import com.ejie.y42b.utils.beans.EntidadBean;

/**
 * 
 *  
 *
 */
public class Y42bContactEntityTree {

    /**
     * 
     */
    private Y42bContactEntityTree(){
	
    }
    /**
     * Obtiene estructura Json para el arbol
     * 
     * @param tree Y42bTree
     * @param selectedList List<String>
     * @return String
     */
    public static String obtieneJsonArbol(Y42bTree tree,
	    List<String> selectedList) {
	Y42bContactEntityTree contactTree = new Y42bContactEntityTree();
	StringBuffer sb = new StringBuffer();

	sb.append("[");

	for (Y42bGrupo grupo : tree.getLstGrupos()) {
	    sb.append(contactTree.bloqueGrupos(grupo, selectedList));

	    if (!grupo.equals(tree.getLstGrupos().get(
		    tree.getLstGrupos().size() - 1))) {
		sb.append(",");
	    }
	}
	sb.append("]");

	return sb.toString();
    }

    /**
     * BloqueGrupos
     * @param grupo Grupo
     * @param selectedList List<String>
     * @return String
     */
    private String bloqueGrupos(Y42bGrupo grupo, List<String> selectedList) {
	StringBuffer sb = new StringBuffer(Y42bAgendaConstantes.BUFFER_50);

	String key = grupo.getGrupoId();
	sb.append("{\"title\": \""
		+ Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(grupo.getNombreEs()),
				Y42bUtils.encodeHtmlTag(grupo.getNombreEu())) + "\", ");
	sb.append("\"isFolder\": false, ");
	sb.append("\"addClass\": \"arbol_grupo\", ");
	sb.append("\"hideCheckbox\": true, ");
	sb.append("\"unselectable\": true, ");
	//sb.append("\"key\": \"G_" + grupo.getGrupoId() + "\"");
	sb.append(this.printNodeKey(key,selectedList));
	
	if (!grupo.getLstChildren().isEmpty()) {
	    sb.append(",");
	    sb.append("\"children\": [");

	    for (Object child : grupo.getLstChildren()) {
		if (child instanceof Y42bGrupo) {
		    sb.append(this.bloqueGrupos((Y42bGrupo) child, selectedList));
		} else {
		    sb.append(this.addChild(child, selectedList));
		}

		if (!child.equals(grupo.getLstChildren().get(
			grupo.getLstChildren().size() - 1))) {
		    sb.append(",");
		}
	    }
	    sb.append("]");
	}
	sb.append("}");

	return sb.toString();
    }

    /**
     * 
     * @param child Object
     * @param selectedList List<String>
     * @return String
     */
    private String addChild(Object child, List<String> selectedList) {
	StringBuffer sb = new StringBuffer();

	if (child instanceof Y42bGrupo) {

	    String key = "G_" + ((Y42bGrupo) child).getGrupoId();
	    key = ((Y42bGrupo) child).getGrupoId();
	    
	    sb.append("{\"title\": \""
		    + Y42bUtils.printTreeLabel(
		    		Y42bUtils.encodeHtmlTag(((Y42bGrupo) child).getNombreEs()),
		    		Y42bUtils.encodeHtmlTag(((Y42bGrupo) child).getNombreEu())) + "\",");
	    sb.append("\"isFolder\": false, ");
	    sb.append("\"addClass\": \"arbol_grupo\", ");
	    sb.append("\"hideCheckbox\": true, ");
	    sb.append("\"unselectable\": true, ");
	    sb.append(this.printNodeKey(key, selectedList));
	    sb.append("}");
	} else if (child instanceof EntidadBean) {

	    EntidadBean entidad = (EntidadBean) child;
	    
		
	    String key = "E_" + entidad.getEntidadId();
	    key = entidad.getEntidadId();
	    
	    sb.append("{\"title\": \""
		    + Y42bUtils.printTreeLabel(Y42bUtils.encodeHtmlTag(entidad.getNombreEs()),
		    		Y42bUtils.encodeHtmlTag(entidad.getNombreEu())) + "\",");
	    sb.append("\"addClass\": \"arbol_entidad\", ");
	    sb.append(this.printNodeKey(key, selectedList));
	    sb.append("}");
	}
	return sb.toString();
    }

    /**
     * Preseleccionar un nodo
     * 
     * @param key String
     * @param selectedIdList List<String>
     * @return String
     */
    private String printNodeKey(String key, List<String> selectedIdList) {

	if (selectedIdList.contains(key)) {
	    return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": true, \"key\": \""
		    + key + "\"";

	    // activate: false, // Initial active status.
	    // focus: false, // Initial focused status.
	    // expand: false, // Initial expanded status.
	    // select: false,

	} else {
	    return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
		    + key + "\"";

	}

    }
}
