package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Y42bGrupo;

/**
 * GruposService  
 * 
 *  
 */
public interface Y42bGruposService {

	/**
	 * Inserts a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Grupos
	 */
	Y42bGrupo add(Y42bGrupo grupos);

	/**
	 * Updates a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Grupos
	 */
	Y42bGrupo update(Y42bGrupo grupos);

	/**
	 * Finds a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Grupos
	 */
	Y42bGrupo find(Y42bGrupo grupos);

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Y42bGrupo> findAll(Y42bGrupo grupos, Pagination pagination);

	/**
	 * Finds a List of rows in the Grupos table.Padres
	 * 
	 * @param grupos
	 *            Grupos
	 * @return List
	 */
	List<Y42bGrupo> findGruposPadreAll(Y42bGrupo grupos);

	/**
	 * Counts rows in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Long
	 */
	Long findAllCount(Y42bGrupo grupos);

	/**
	 * Finds rows in the Grupos table using like.
	 * 
	 * @param grupos
	 *            Grupos
	 * @param pagination Pagination            
	 * @param startsWith Boolean
	 * @return List
	 */
	List<Y42bGrupo> findAllLike(Y42bGrupo grupos, Pagination pagination, Boolean startsWith);

	/**
	 * Finds Numero de entidades activas
	 * 
	 * @param grupos
	 *            Grupos
	 * @return int
	 */
	int findEntidadesActivas(Y42bGrupo grupos);

	/**
	 * Finds primer grupo activo para seleccionar por defecto
	 * 
	 * @return Y42bGrupo
	 */
	Y42bGrupo findPrimerGrupoActivo();

	/**
	 * Deletes a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 */
	void remove(Y42bGrupo grupos);

	/**
	 * Deletes multiple rows in the Grupos table.
	 * 
	 * @param gruposList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<Y42bGrupo> gruposList);

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Y42Grupo
	 * @return Y42Grupo
	 */
	Y42bGrupo addGrupoEntidad(Y42bGrupo grupo);

	/**
	 * Deletes a single row in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Y42Grupo
	 */
	void removeGrupoEntidad(Y42bGrupo grupo);

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param grupo
	 *            Y42Grupo
	 * @param entidad
	 *            Y42Entidad
	 * @param pagination
	 *            Pagination
	 * @return Y42Grupo
	 */
	Y42bGrupo findGrupoEntidad(Y42bGrupo grupo, Entidad entidad, Pagination pagination);

	 /**
     * Finds Numero de hijos
     * 
     * @param grupos
     *            Grupos
     * @return Long
     */
    int findHijos(Y42bGrupo grupos);

    /**
     * Finds Numero de hijos
     * 
     * @param grupos
     *            Grupos
     * @return Long
     */
    public int findEntidadesHijasTotales(Y42bGrupo grupos);
	 /**
     * Finds Numero de hijos que son grupos a su vez
     * 
     * @param grupos
     *            Grupos
     * @return Long
     */
    int countGruposHijo(Y42bGrupo grupos);
    
    
    
	/**
	 * Counts rows in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Y42Grupo
	 * @param entidad
	 *            Y42Entidad
	 * @return List
	 */
	Long findGrupoEntidadCount(Y42bGrupo grupo, Entidad entidad);
	
	/**
	 * Añade jerarquia a los grupos raices
	 * @param grupo
	 *        Y42Grupo
	 * 
	 * 
	 * @return y42bGrupo
	 */
	Y42bGrupo findJerarquia(Y42bGrupo grupo);

	
	/**
	 * Buscar grupo por su id
	 * @param grupo
	 *        Y42Grupo
	 * 
	 * 
	 * @return y42bGrupo
	 */
	Y42bGrupo findGrupo(Y42bGrupo grupo);

	
	/**
	 * Counts rows in the GrupoEntidad table with that entityId.
	 *
	 * @param entidadId String
	 * @return Long
	 */
    Long countByEntidadId(String entidadId);
	
}
