package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.dao.Y42bGruposDao;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.model.Y42bTree;
import com.ejie.y42b.utils.beans.EntidadBean;

/**
 * GruposServiceImpl  
 * 
 *  
 */
@Service(value = "arbolService")
public class Y42bArbolServiceImpl implements Y42bArbolService {

	@Autowired()
	private Y42bGruposDao gruposDao;

	@Override()
	// public Y42bTree obtenerArbol(boolean mostrarNoActivas) {
	public Y42bTree obtenerArbol(String estadoActivas) {
		List<Y42bGrupo> lstArbolGrupos = new ArrayList<Y42bGrupo>();

		Y42bGrupo grupoFiltro = new Y42bGrupo();
		grupoFiltro.setGrupoId(Y42bAgendaConstantes.GRUPO_RAIZ_ID);
		grupoFiltro.setPadreId(null);

		// Get root
		Y42bGrupo rootGrupo = this.gruposDao.find(grupoFiltro);

		// get the rest of the elements
		grupoFiltro.setGrupoId(null);
		grupoFiltro.setPadreId(null);
		grupoFiltro.setActiva(Y42bAgendaConstantes.SI);

		Locale locale = LocaleContextHolder.getLocale();
		Pagination pagination = new Pagination();
		if (Y42bAgendaConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBRE_ES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBRE_EU");
			pagination.setAscDsc("ASC");
		}

		List<Y42bGrupo> lstGrupo = this.gruposDao.findAll(grupoFiltro,
				pagination);
		lstGrupo.add(rootGrupo);

		for (Y42bGrupo gr : lstGrupo) {
			gr.setActiva(Y42bAgendaConstantes.SI);
			// gr = this.obtieneGrupo(gr, mostrarNoActivas);
			gr = this.obtieneGrupo(gr, estadoActivas);

			lstArbolGrupos.add(gr);
		}

		Y42bTree tree = new Y42bTree();
		tree.setLstGrupos(lstArbolGrupos);

		return tree;
	}

	/**
	 * 
	 * @param grupoFiltro
	 *            grupoFiltro
	 * @param estadoActivas
	 *            String
	 * @return Y42bGrupo
	 */
	private Y42bGrupo obtieneGrupo(Y42bGrupo grupoFiltro,
	// boolean mostrarNoActivas) {
			String estadoActivas) {

		Locale locale = LocaleContextHolder.getLocale();
		Pagination pagination = new Pagination();
		if (Y42bAgendaConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBRE_ES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBRE_EU");
			pagination.setAscDsc("ASC");
		}

		List<Y42bGrupo> lstGrupoChildren = this.gruposDao.findAllChildren(
				grupoFiltro, pagination);

		if (lstGrupoChildren.size() > 0) {
			List<Object> lstGrupos = new ArrayList();

			for (Y42bGrupo gr : lstGrupoChildren) {
				gr.setActiva(Y42bAgendaConstantes.SI);
				// gr = this.obtieneGrupo(gr, mostrarNoActivas);
				gr = this.obtieneGrupo(gr, estadoActivas);
				lstGrupos.add(gr);

			}

			List<Entidad> lstEntidad = this.obtieneEntidades(grupoFiltro,
					estadoActivas);// mostrarNoActivas);

			for (Entidad ent : lstEntidad) {
				lstGrupos.add(ent);
			}

			grupoFiltro.setLstChildren(lstGrupos);
		} else {
			grupoFiltro.setLstChildren(this.obtieneEntidades(grupoFiltro,
					estadoActivas)); // mostrarNoActivas);
		}

		return grupoFiltro;
	}

	/**
	 * 
	 * @param gr
	 *            Y42bGrupo
	 * @param mostrarNoActivas
	 *            boolean
	 * @return List<Entidad>
	 */
	private List<Entidad> obtieneEntidades(Y42bGrupo gr,
	// boolean mostrarNoActivas) {
			String estadoActivas) {
		List<Entidad> lstArbolEntidades = null;

		Entidad entidadKey = new Entidad();
		// if (mostrarNoActivas) {
		// entidadKey.setActiva(null); // Muestra todas
		// } else {
		// entidadKey.setActiva(Y42bAgendaConstantes.SI);
		// }

		if (estadoActivas.equalsIgnoreCase(Y42bAgendaConstantes.ESTADO_ACTIVAS)) {
			entidadKey.setActiva(Y42bAgendaConstantes.SI);
		} else if (estadoActivas
				.equalsIgnoreCase(Y42bAgendaConstantes.ESTADO_INACTIVAS)) {
			entidadKey.setActiva(Y42bAgendaConstantes.NO);
		} else {
			entidadKey.setActiva(null);
		}

		Locale locale = LocaleContextHolder.getLocale();
		Pagination pagination = new Pagination();
		if (Y42bAgendaConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBREES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBREEU");
			pagination.setAscDsc("ASC");
		}
		Y42bGrupo fGr = this.gruposDao.findGrupoEntidad(gr, entidadKey,
				pagination);
		List<Entidad> lstEntidades = fGr.getEntidads();

		// Entidades
		// activas
		// unicamente
		lstArbolEntidades = new ArrayList<Entidad>();
		Contacto contactoKey = new Contacto();
		EntidadBean eBean = null;
		for (Entidad entidad : lstEntidades) {
			contactoKey.setEntidadId(entidad.getEntidadId());

			eBean = new EntidadBean();// NOPMD 2012/02/29 (IDA)
			eBean.setGrupoId(fGr.getGrupoId());
			eBean.setEntidadId(entidad.getEntidadId());
			eBean.setNombreEs(entidad.getNombreEs());
			eBean.setNombreEu(entidad.getNombreEu());
			eBean.setActiva(entidad.getActiva());

			entidad.setEtiquetas(null);

			lstArbolEntidades.add(eBean);
		}
		return lstArbolEntidades;
	}

	// ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * 
	 * 
	 * @param mostrarNoActivas
	 *            boolean
	 * @param entidadId
	 *            String
	 * @return Y42bTree
	 */
	public Y42bTree obtenerArbolDetalle(boolean mostrarNoActivas,
			String entidadId) {

		// Get root
		List<Y42bGrupo> lstArbolGrupos = new ArrayList<Y42bGrupo>();
		Y42bGrupo grupoFiltro = new Y42bGrupo();
		grupoFiltro.setGrupoId(Y42bAgendaConstantes.GRUPO_RAIZ_ID);
		grupoFiltro.setPadreId(null);
		Y42bGrupo rootGrupo = this.gruposDao.find(grupoFiltro);

		// get the rest of the elements
		grupoFiltro.setGrupoId(null);
		grupoFiltro.setPadreId(null);
		grupoFiltro.setActiva(Y42bAgendaConstantes.SI);

		Locale locale = LocaleContextHolder.getLocale();
		Pagination pagination = new Pagination();
		if (Y42bAgendaConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBRE_ES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBRE_EU");
			pagination.setAscDsc("ASC");
		}

		// root + rexz
		List<Y42bGrupo> lstGrupo = this.gruposDao.findAll(grupoFiltro,
				pagination);
		lstGrupo.add(0, rootGrupo);

		for (Y42bGrupo gr : lstGrupo) {
			gr.setActiva(Y42bAgendaConstantes.SI);

			if (this.contieneEntidad(gr, entidadId)) {
				gr = this.obtieneGruposHijo(gr, mostrarNoActivas, entidadId);
				lstArbolGrupos.add(gr);
			}
		}

		Y42bTree tree = new Y42bTree();
		tree.setLstGrupos(lstArbolGrupos);

		return tree;
	}

	/**
	 * 
	 * @param grupoFiltro
	 *            grupoFiltro
	 * @param mostrarNoActivas
	 *            boolean
	 * @param entidadId
	 *            String
	 * @return Y42bGrupo
	 */
	private Y42bGrupo obtieneGruposHijo(Y42bGrupo grupoFiltro,
			boolean mostrarNoActivas, String entidadId) {

		Locale locale = LocaleContextHolder.getLocale();
		Pagination pagination = new Pagination();
		if (Y42bAgendaConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("NOMBRE_ES");
			pagination.setAscDsc("ASC");
		} else {
			pagination.setSort("NOMBRE_EU");
			pagination.setAscDsc("ASC");
		}

		List<Y42bGrupo> lstGrupoChildren = this.gruposDao.findAllChildren(
				grupoFiltro, pagination);

		if (lstGrupoChildren.size() > 0) {
			List<Object> lstGrupos = new ArrayList();

			for (Y42bGrupo gr : lstGrupoChildren) {
				gr.setActiva(Y42bAgendaConstantes.SI);

				if (this.contieneEntidad(gr, entidadId)) {
					gr = this
							.obtieneGruposHijo(gr, mostrarNoActivas, entidadId);
					lstGrupos.add(gr);
				}

			}
			grupoFiltro.setLstChildren(lstGrupos);
		}

		return grupoFiltro;
	}

	/**
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @param entidadId
	 *            String
	 * @return boolean
	 */
	private boolean contieneEntidad(Y42bGrupo grupo, String entidadId) {

		boolean tieneEntidades = false;

		Long numEntidades = this.gruposDao.countByGrupoEntidadIds(
				grupo.getGrupoId(), entidadId);

		if (numEntidades > 0) {
			return true;
		} else {
			Y42bGrupo grupoPadre = new Y42bGrupo();
			grupoPadre.setGrupoId(grupo.getGrupoId());

			List<Y42bGrupo> lstGrupoChildren = this.gruposDao.findAllChildren(
					grupoPadre, null);

			if (lstGrupoChildren.size() > 0) {
				for (Y42bGrupo grupoHijo : lstGrupoChildren) {

					tieneEntidades = this.contieneEntidad(grupoHijo, entidadId);

					if (tieneEntidades) {
						return tieneEntidades;
					}
				}
				return false;
			} else {
				return false;
			}
		}
	}

}
