package com.ejie.y42b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.dao.TipoOrganismoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y42b.model.TipoOrganismo;

/**
 *  * TipoOrganismoServiceImpl  
 *  
 */

@Service(value = "tipoOrganismoService")
public  class TipoOrganismoServiceImpl implements TipoOrganismoService {

	private static final  Logger logger = LoggerFactory.getLogger(TipoOrganismoServiceImpl.class);
	@Autowired
	private TipoOrganismoDao tipoOrganismoDao;

	/**
	 * Inserts a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return TipoOrganismo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoOrganismo add(TipoOrganismo tipoOrganismo) {
		return this.tipoOrganismoDao.add(tipoOrganismo);
	}

	/**
	 * Updates a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return TipoOrganismo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoOrganismo update(TipoOrganismo tipoOrganismo) {
		return this.tipoOrganismoDao.update(tipoOrganismo);
	 }

	/**
	 * Finds a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return TipoOrganismo
	 */
	public TipoOrganismo find(TipoOrganismo tipoOrganismo) {
		return (TipoOrganismo) this.tipoOrganismoDao.find(tipoOrganismo);
	}

	/**
	 * Finds a List of rows in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipoOrganismo> findAll(TipoOrganismo tipoOrganismo, Pagination pagination) {
		return (List<TipoOrganismo>) this.tipoOrganismoDao.findAll(tipoOrganismo, pagination);
	}
    
	/**
	 * Counts rows in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return Long
	 */
	public Long findAllCount(TipoOrganismo tipoOrganismo) {        
		return  this.tipoOrganismoDao.findAllCount(tipoOrganismo);
	}

	/**
	 * Finds rows in the TipoOrganismo table using like.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipoOrganismo> findAllLike(TipoOrganismo tipoOrganismo, Pagination pagination, Boolean startsWith) {
		return (List<TipoOrganismo>) this.tipoOrganismoDao.findAllLike(tipoOrganismo, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoOrganismo tipoOrganismo) {
		this.tipoOrganismoDao.remove(tipoOrganismo);
	}
	
	/**
	 * Deletes multiple rows in the TipoOrganismo table.
	 *
	 * @param tipoOrganismoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipoOrganismo> tipoOrganismoList) {
		for (TipoOrganismo  tipoOrganismoAux:tipoOrganismoList) {
			this.tipoOrganismoDao.remove(tipoOrganismoAux);
		}
	}


	/**
	 * Getter method for TipoOrganismoDao
	 *
	 * @return TipoOrganismoDao
	 */
	public TipoOrganismoDao getTipoOrganismoDao() {
		return this.tipoOrganismoDao;
	}
    
	/**
	 * Setter method for TipoOrganismoDao.
	 *
	 * @param  tipoOrganismoDao TipoOrganismoDao
	 * @return
	 */
	public void setTipoOrganismoDao(TipoOrganismoDao tipoOrganismoDao) {
		logger.info("Setting Dependency "+tipoOrganismoDao);
		this.tipoOrganismoDao = tipoOrganismoDao;
	}
}

