package com.ejie.y42b.service;


import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y42b.model.TipoOrganismo;

/**
 *  * TipoOrganismoService  
 *  
 */

public interface TipoOrganismoService {

	/**
	 * Inserts a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return TipoOrganismo
	 */
    TipoOrganismo add(TipoOrganismo tipoOrganismo);

	/**
	 * Updates a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return TipoOrganismo
	 */
	TipoOrganismo update(TipoOrganismo tipoOrganismo);

	/**
	 * Finds a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return TipoOrganismo
	 */
	TipoOrganismo find(TipoOrganismo tipoOrganismo);

	/**
	 * Finds a List of rows in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @param pagination Pagination
	 * @return List
	 */
	List<TipoOrganismo> findAll(TipoOrganismo tipoOrganismo, Pagination pagination);

	/**
	 * Counts rows in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return Long
	 */
	Long findAllCount(TipoOrganismo tipoOrganismo);
	
	/**
	 * Finds rows in the TipoOrganismo table using like.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<TipoOrganismo> findAllLike(TipoOrganismo tipoOrganismo, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the TipoOrganismo table.
	 *
	 * @param tipoOrganismo TipoOrganismo
	 * @return 
	 */
	void remove(TipoOrganismo tipoOrganismo);
	
	/**
	 * Deletes multiple rows in the TipoOrganismo table.
	 *
	 * @param tipoOrganismoList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<TipoOrganismo> tipoOrganismoList);
    
}


