package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.T17Comarca;

/**
 * T17ComarcaService  
 * 
 *  
 */
public interface T17ComarcaService {

	/**
	 * Inserts a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	T17Comarca add(T17Comarca t17Comarca);

	/**
	 * Updates a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	T17Comarca update(T17Comarca t17Comarca);

	/**
	 * Finds a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return T17Comarca
	 */
	T17Comarca find(T17Comarca t17Comarca);

	/**
	 * Finds a List of rows in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Comarca> findAll(T17Comarca t17Comarca, Pagination pagination);

	/**
	 * Counts rows in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @return Long
	 */
	Long findAllCount(T17Comarca t17Comarca);

	/**
	 * Finds rows in the T17Comarca table using like.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 * @param pagination Pagination            
	 * @param startsWith Boolean
	 * @return List
	 */
	List<T17Comarca> findAllLike(T17Comarca t17Comarca, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the T17Comarca table.
	 * 
	 * @param t17Comarca
	 *            T17Comarca
	 */
	void remove(T17Comarca t17Comarca);

	/**
	 * Deletes multiple rows in the T17Comarca table.
	 * 
	 * @param t17ComarcaList
	 *            ArrayList
	 */
	void removeMultiple(ArrayList<T17Comarca> t17ComarcaList);

}
