package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.dao.T17CalleDao;
import com.ejie.y42b.model.T17Calle;
import com.ejie.y42b.model.T17Portal;

/**
 * T17CalleServiceImpl  
 * 
 *  
 */
@Service(value = "T17CalleService")
public class T17CalleServiceImpl implements T17CalleService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(T17CalleServiceImpl.class);
	@Autowired()
	private T17CalleDao t17CalleDao;

	/**
	 * Inserts a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Calle add(T17Calle T17Calle) {
		return this.t17CalleDao.add(T17Calle);
	}

	/**
	 * Updates a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Calle update(T17Calle T17Calle) {
		return this.t17CalleDao.update(T17Calle);
	}

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	public T17Calle find(T17Calle T17Calle) {
		return (T17Calle) this.t17CalleDao.find(T17Calle);
	}

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Calle> findAll(T17Calle T17Calle, Pagination pagination) {
		return (List<T17Calle>) this.t17CalleDao.findAll(T17Calle, pagination);
	}

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return Long
	 */
	public Long findAllCount(T17Calle T17Calle) {
		return this.t17CalleDao.findAllCount(T17Calle);
	}

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<T17Calle> findAllLike(T17Calle T17Calle, Pagination pagination,
			Boolean startsWith) {
		return (List<T17Calle>) this.t17CalleDao.findAllLike(T17Calle,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Calle T17Calle) {
		this.t17CalleDao.remove(T17Calle);
	}

	/**
	 * Deletes multiple rows in the T17Calle table.
	 * 
	 * @param T17CalleList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Calle> T17CalleList) {
		for (T17Calle T17CalleAux : T17CalleList) {
			this.t17CalleDao.remove(T17CalleAux);
		}
	}

	/**
	 * 
	 * @return T17CalleDao
	 */
	public T17CalleDao getT17CalleDao() {
		return this.t17CalleDao;
	}

	/**
	 * 
	 * @param T17CalleDao
	 *            T17CalleDao
	 */
	public void setT17CalleDao(T17CalleDao T17CalleDao) {
		T17CalleServiceImpl.logger.info("Setting Dependency " + T17CalleDao);
		this.t17CalleDao = T17CalleDao;
	}
	
	/**
	 * Finds a List of distinct prov mun with the given CP
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Calle
	 */
	public T17Calle findProvMun(T17Portal t17Portal) {
		return (T17Calle) this.t17CalleDao.findProvMun(t17Portal);
	}
	
	
	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Calle> findAllCalleLike(T17Calle T17Calle,
			Pagination pagination, Boolean startsWith) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("dsO")) {
				pagination.setSort("DS_O");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("tipoViaId")) {
				pagination.setSort("TIPO_VIA_ID");
			}
		}
		return (List<T17Calle>) this.t17CalleDao.findAllCalleLike(T17Calle,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param T17Calle
	 *            T17Calle
	 * @return Long
	 */
	public Long findAllCalleLikeCount(T17Calle T17Calle, Boolean startsWith) {
		return this.t17CalleDao.findAllCalleLikeCount(T17Calle, startsWith);
	}
}
