package com.ejie.y42b.service;

import java.util.List;
import java.util.Vector;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.y42b.dao.PerfilesXlnetsDao;
import com.ejie.y42b.model.PerfilesXlnets;

/**
 * PerfilesXlnetsServiceImpl  
 * 
 *  
 */

@Service(value = "perfilesXlnetsService")
public class PerfilesXlnetsServiceImpl implements PerfilesXlnetsService {

	@Autowired
	private PerfilesXlnetsDao perfilesXlnetsDao;

	/**
	 * Inserts a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PerfilesXlnets add(PerfilesXlnets perfilesXlnets) {
		return this.perfilesXlnetsDao.add(perfilesXlnets);
	}

	/**
	 * Updates a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PerfilesXlnets update(PerfilesXlnets perfilesXlnets) {
		return this.perfilesXlnetsDao.update(perfilesXlnets);
	}

	/**
	 * Finds a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	public PerfilesXlnets find(PerfilesXlnets perfilesXlnets) {
		return (PerfilesXlnets) this.perfilesXlnetsDao.find(perfilesXlnets);
	}

	/**
	 * Deletes a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(PerfilesXlnets perfilesXlnets) {
		this.perfilesXlnetsDao.remove(perfilesXlnets);
	}

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	public List<PerfilesXlnets> findAll(PerfilesXlnets perfilesXlnets,
			JQGridRequestDto jqGridRequestDto) {
		return (List<PerfilesXlnets>) this.perfilesXlnetsDao.findAll(
				perfilesXlnets, jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfiles
	 *            Vector<String>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	public List<PerfilesXlnets> findAllPerfiles(Vector<String> perfiles,
			JQGridRequestDto jqGridRequestDto) {
		return (List<PerfilesXlnets>) this.perfilesXlnetsDao.findAllPerfiles(
				perfiles, jqGridRequestDto);
	}

	/**
	 * Finds rows in the PerfilesXlnets table using like.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<PerfilesXlnets>
	 */
	public List<PerfilesXlnets> findAllLike(PerfilesXlnets perfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<PerfilesXlnets>) this.perfilesXlnetsDao.findAllLike(
				perfilesXlnets, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.perfilesXlnetsDao.removeMultiple(filterPerfilesXlnets,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<PerfilesXlnets>
	 */
	public JQGridResponseDto<PerfilesXlnets> filter(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<PerfilesXlnets> listaPerfilesXlnets = this.perfilesXlnetsDao
				.findAllLike(filterPerfilesXlnets, jqGridRequestDto, false);
		Long recordNum = this.perfilesXlnetsDao.findAllLikeCount(
				filterPerfilesXlnets != null ? filterPerfilesXlnets
						: new PerfilesXlnets(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<PerfilesXlnets>> reorderSelection = this.perfilesXlnetsDao
					.reorderSelection(filterPerfilesXlnets, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<PerfilesXlnets>(jqGridRequestDto,
					recordNum, listaPerfilesXlnets, reorderSelection);
		}
		return new JQGridResponseDto<PerfilesXlnets>(jqGridRequestDto,
				recordNum, listaPerfilesXlnets);
	}

	/**
	 * Searches rows in the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param searchPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	public List<TableRowDto<PerfilesXlnets>> search(
			PerfilesXlnets filterPerfilesXlnets,
			PerfilesXlnets searchPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.perfilesXlnetsDao.search(filterPerfilesXlnets,
				searchPerfilesXlnets, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.perfilesXlnetsDao.reorderSelection(filterPerfilesXlnets,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<PerfilesXlnets>>
	 */
	public JQGridResponseDto<JerarquiaDto<PerfilesXlnets>> jerarquia(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<PerfilesXlnets>> listaPerfilesXlnets = this.perfilesXlnetsDao
				.findAllLikeJerarquia(filterPerfilesXlnets, jqGridRequestDto);
		Long recordNum = this.perfilesXlnetsDao.findAllLikeCountJerarquia(
				filterPerfilesXlnets, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<PerfilesXlnets>>(
				jqGridRequestDto, recordNum, listaPerfilesXlnets);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the PerfilesXlnets
	 * table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<PerfilesXlnets>>
	 */
	public JQGridResponseDto<JerarquiaDto<PerfilesXlnets>> jerarquiaChildren(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<PerfilesXlnets>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<PerfilesXlnets>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.perfilesXlnetsDao.findAllChild(filterPerfilesXlnets,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
