package com.ejie.y42b.service;

import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.y42b.model.PerfilesXlnets;

/**
 * PerfilesXlnetsService  
 * 
 *  
 */

public interface PerfilesXlnetsService {

	/**
	 * Inserts a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	PerfilesXlnets add(PerfilesXlnets perfilesXlnets);

	/**
	 * Updates a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	PerfilesXlnets update(PerfilesXlnets perfilesXlnets);

	/**
	 * Finds a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	PerfilesXlnets find(PerfilesXlnets perfilesXlnets);

	/**
	 * Deletes a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 */
	void remove(PerfilesXlnets perfilesXlnets);

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	List<PerfilesXlnets> findAll(PerfilesXlnets perfilesXlnets,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfiles
	 *            Vector<String>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	public List<PerfilesXlnets> findAllPerfiles(Vector<String> perfiles,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the PerfilesXlnets table using like.
	 * 
	 * @param perfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<PerfilesXlnets>
	 */
	List<PerfilesXlnets> findAllLike(PerfilesXlnets perfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<PerfilesXlnets>
	 */
	JQGridResponseDto<PerfilesXlnets> filter(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param searchPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	List<TableRowDto<PerfilesXlnets>> search(
			PerfilesXlnets filterPerfilesXlnets,
			PerfilesXlnets searchPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<PerfilesXlnets>>
	 */
	JQGridResponseDto<JerarquiaDto<PerfilesXlnets>> jerarquia(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the PerfilesXlnets
	 * table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<PerfilesXlnets>>
	 */
	JQGridResponseDto<JerarquiaDto<PerfilesXlnets>> jerarquiaChildren(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto);

}
