package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.dao.ItemDao;
import com.ejie.y42b.model.Item;

/**
 * * ItemServiceImpl  
 * 
 *  
 */

@Service(value = "itemService")
public class ItemServiceImpl implements ItemService {

	private static final Logger logger = LoggerFactory
			.getLogger(ItemServiceImpl.class);
	@Autowired()
	private ItemDao itemDao;

	/**
	 * Inserts a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Item add(Item item) {
		return this.itemDao.add(item);
	}

	/**
	 * Updates a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Item update(Item item) {
		return this.itemDao.update(item);
	}

	/**
	 * Finds a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	public Item find(Item item) {
		return (Item) this.itemDao.find(item);
	}

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Item> findAll(Item item, Pagination pagination) {
		return (List<Item>) this.itemDao.findAll(item, pagination);
	}

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Item> findAllMailsPendientes(Item item, Pagination pagination) {
		return (List<Item>) this.itemDao.findAllMailsPendientes(item,
				pagination);
	}

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Long
	 */
	public Long findAllCount(Item item) {
		return this.itemDao.findAllCount(item);
	}

	/**
	 * Finds rows in the Item table using like.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Item> findAllLike(Item item, Pagination pagination,
			Boolean startsWith) {
		return (List<Item>) this.itemDao.findAllLike(item, pagination,
				startsWith);
	}

	/**
	 * Deletes a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Item item) {
		this.itemDao.remove(item);
	}

	/**
	 * Deletes multiple rows in the Item table.
	 * 
	 * @param itemList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Item> itemList) {
		for (Item itemAux : itemList) {
			this.itemDao.remove(itemAux);
		}
	}

	/**
	 * Getter method for ItemDao
	 * 
	 * @return ItemDao
	 */
	public ItemDao getItemDao() {
		return this.itemDao;
	}

	/**
	 * Setter method for ItemDao.
	 * 
	 * @param itemDao
	 *            ItemDao
	 * @return
	 */
	public void setItemDao(ItemDao itemDao) {
		ItemServiceImpl.logger.info("Setting Dependency " + itemDao);
		this.itemDao = itemDao;
	}

	/**
	 * Deletes a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateSeleccion(Item item) {
		this.itemDao.updateSeleccion(item);
	}

}
