package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Item;

/**
 * * ItemService  
 * 
 *  
 */

public interface ItemService {

	/**
	 * Inserts a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	Item add(Item item);

	/**
	 * Updates a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	Item update(Item item);

	/**
	 * Finds a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	Item find(Item item);

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Item> findAll(Item item, Pagination pagination);

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Item> findAllMailsPendientes(Item item, Pagination pagination);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Long
	 */
	Long findAllCount(Item item);

	/**
	 * Finds rows in the Item table using like.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Item> findAllLike(Item item, Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return
	 */
	void remove(Item item);

	/**
	 * Deletes multiple rows in the Item table.
	 * 
	 * @param itemList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Item> itemList);

	/**
	 * Actualiza la seleccion del envio
	 * 
	 * @param itemList
	 *            ArrayList
	 * @return
	 */
	void updateSeleccion(Item item);

}
