package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.dao.EtiquetaDao;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.utils.Y42bUIDGenerator;

/**
 * * EtiquetaServiceImpl  
 * 
 *  
 */

@Service(value = "etiquetaService")
public class EtiquetaServiceImpl implements EtiquetaService {

	private static final Logger logger = LoggerFactory
			.getLogger(EtiquetaServiceImpl.class);
	@Autowired()
	private EtiquetaDao etiquetaDao;

	/**
	 * Inserts a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta add(Etiqueta etiqueta) {
		etiqueta.setEtiquetaId(Y42bUIDGenerator.getInstance().generateId());
		return this.etiquetaDao.add(etiqueta);
	}

	/**
	 * Updates a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta update(Etiqueta etiqueta) {
		return this.etiquetaDao.update(etiqueta);
	}

	/**
	 * Finds a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	public Etiqueta find(Etiqueta etiqueta) {
		return (Etiqueta) this.etiquetaDao.find(etiqueta);
	}

	/**
	 * Finds a List of rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination) {
		return (List<Etiqueta>) this.etiquetaDao.findAll(etiqueta, pagination);
	}

	/**
	 * Counts rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	public Long findAllCount(Etiqueta etiqueta) {
		return this.etiquetaDao.findAllCount(etiqueta);
	}

	/**
	 * Finds rows in the Etiqueta table using like.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination,
			Boolean startsWith) {
		return (List<Etiqueta>) this.etiquetaDao.findAllLike(etiqueta,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Etiqueta etiqueta) {
		this.etiquetaDao.remove(etiqueta);
	}

	/**
	 * Deletes multiple rows in the Etiqueta table.
	 * 
	 * @param etiquetaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Etiqueta> etiquetaList) {
		for (Etiqueta etiquetaAux : etiquetaList) {
			this.etiquetaDao.remove(etiquetaAux);
		}
	}

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta addEtiquetaEntidad(Etiqueta etiqueta) {
		return this.etiquetaDao.addEtiquetaEntidad(etiqueta);
	}

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeEtiquetaEntidad(Etiqueta etiqueta) {
		this.etiquetaDao.removeEtiquetaEntidad(etiqueta);
	}

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta findEtiquetaEntidad(Etiqueta etiqueta, Entidad entidad,
			Pagination pagination) {
		return this.etiquetaDao.findEtiquetaEntidad(etiqueta, entidad,
				pagination);
	}

	/**
	 * Counts rows in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Entidad
	 * @return List
	 */
	public Long findEtiquetaEntidadCount(Etiqueta etiqueta, Entidad entidad) {
		return this.etiquetaDao.findEtiquetaEntidadCount(etiqueta, entidad);
	}

	/**
	 * Getter method for EtiquetaDao
	 * 
	 * @return EtiquetaDao
	 */
	public EtiquetaDao getEtiquetaDao() {
		return this.etiquetaDao;
	}

	/**
	 * Setter method for EtiquetaDao.
	 * 
	 * @param etiquetaDao
	 *            EtiquetaDao
	 * @return
	 */
	public void setEtiquetaDao(EtiquetaDao etiquetaDao) {
		EtiquetaServiceImpl.logger.info("Setting Dependency " + etiquetaDao);
		this.etiquetaDao = etiquetaDao;
	}

	/**
	 * Inserts a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Etiqueta addEtiquetaContacto(Etiqueta etiqueta) {
		return this.etiquetaDao.addEtiquetaContacto(etiqueta);
	}

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeEtiquetaContacto(Etiqueta etiqueta) {
		this.etiquetaDao.removeEtiquetaContacto(etiqueta);
	}

}
