package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;

/**
 * * EtiquetaService  
 * 
 *  
 */

public interface EtiquetaService {

	/**
	 * Inserts a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta add(Etiqueta etiqueta);

	/**
	 * Updates a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta update(Etiqueta etiqueta);

	/**
	 * Finds a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta find(Etiqueta etiqueta);

	/**
	 * Finds a List of rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination);

	/**
	 * Counts rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	Long findAllCount(Etiqueta etiqueta);

	/**
	 * Finds rows in the Etiqueta table using like.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	void remove(Etiqueta etiqueta);

	/**
	 * Deletes multiple rows in the Etiqueta table.
	 * 
	 * @param etiquetaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Etiqueta> etiquetaList);

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta addEtiquetaEntidad(Etiqueta etiqueta);

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 */
	void removeEtiquetaEntidad(Etiqueta etiqueta);

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	Etiqueta findEtiquetaEntidad(Etiqueta etiqueta, Entidad entidad,
			Pagination pagination);

	/**
	 * Counts rows in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Entidad
	 * @return List
	 */
	Long findEtiquetaEntidadCount(Etiqueta etiqueta, Entidad entidad);

	/**
	 * Inserts a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta addEtiquetaContacto(Etiqueta etiqueta);

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 */
	void removeEtiquetaContacto(Etiqueta etiqueta);
}
