package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Envio;
import com.ejie.y42b.model.EnvioSeguimiento;

/**
 * * EnvioService  
 * 
 *  
 */

public interface EnvioService {

	/**
	 * Inserts a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 */
	Envio add(Envio envio);

	/**
	 * Updates a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 * @throws Exception
	 *             Exception
	 */
	Envio update(Envio envio) throws Exception;

	/**
	 * Finds a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 */
	Envio find(Envio envio);

	/**
	 * Finds a List of rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Envio> findAll(Envio envio, Pagination pagination);

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Long
	 */
	Long findAllCount(Envio envio);

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Envio> findAllLike(Envio envio, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EnvioSeguimiento> findAllLikeSeguimiento(Envio envio,
			Pagination pagination, Boolean startsWith, Date fechaDesde,
			Date fechaHasta);

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeSeguimientoCount(Envio envio, Pagination pagination,
			Boolean startsWith, Date fechaDesde, Date fechaHasta);

	/**
	 * Deletes a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return
	 */
	void remove(Envio envio);

	/**
	 * Deletes multiple rows in the Envio table.
	 * 
	 * @param envioList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Envio> envioList);

	/**
	 * JavaMail Procesa los "items" del "envio" para enviar correo electronico
	 * Este proceso se llama desde la cola JMS al recibir el envio a procesar
	 * 
	 * @throws Exception
	 * 
	 */
	public void procesoEnviosMail(String idEnvio) throws Exception;

	/**
	 * JavaMail Procesa los items listas para enviar correo electronico Este
	 * proceso se llama desde Quartz cada x segundos
	 * 
	 * @throws Exception
	 * 
	 */
	// public void procesoEnviosMail() throws Exception;

	/**
	 * Procesa los items listas para limpieza Este proceso se llama desde Quartz
	 * cada x segundos
	 * 
	 * @throws Exception
	 * 
	 */
	public void limpiezaEnviosMail() throws Exception;

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Long
	 */
	Long findAllCountKontsumonet(String envioId);

}
