package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Grupo;
import com.ejie.y42b.model.Y42bGrupo;

/**
 * * EntidadService  
 * 
 *  
 */

public interface EntidadService {

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 * @exception Exception
	 *                Exception
	 */
	Entidad add(Entidad entidad) throws Exception;

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 * @exception Exception
	 *                Exception
	 */
	Entidad update(Entidad entidad) throws Exception;

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad find(Entidad entidad);

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Entidad> findAll(Entidad entidad, Pagination pagination);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findAllCount(Entidad entidad);

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void remove(Entidad entidad);

	/**
	 * Deletes multiple rows in the Entidad table.
	 * 
	 * @param entidadList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Entidad> entidadList);

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad addEtiquetaEntidad(Entidad entidad);

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 */
	void removeEtiquetaEntidad(Entidad entidad);

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findEtiquetaEntidad(Entidad entidad, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param etiqueta
	 *            Etiqueta
	 * @return List
	 */
	Long findEtiquetaEntidadCount(Entidad entidad, Etiqueta etiqueta);

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad addGrupoEntidad(Entidad entidad);

	/**
	 * Deletes a single row in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 */
	void removeGrupoEntidad(Entidad entidad);

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findGrupoEntidad(Entidad entidad, Y42bGrupo grupo,
			Pagination pagination);

	/**
	 * Counts rows in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupo
	 *            Grupo
	 * @return List
	 */
	Long findGrupoEntidadCount(Entidad entidad, Y42bGrupo grupo);

	/**
	 * Inserts a single row in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad addEntidadContacto(Entidad entidad);

	/**
	 * Deletes a single row in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 */
	void removeEntidadContacto(Entidad entidad);

	/**
	 * Find a single row in the findEntidadContacto Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findEntidadContacto(Entidad entidad, Contacto contacto,
			Pagination pagination);

	/**
	 * Counts rows in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param contacto
	 *            Contacto
	 * @return List
	 */
	Long findEntidadContactoCount(Entidad entidad, Contacto contacto);

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupos
	 *            List<Grupo>
	 * @param etiquetas
	 *            Lista<Label>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Entidad> advancedSearchAll(Entidad entidad, List<Grupo> grupos,
			List<Etiqueta> etiquetas, Date fechaDesde, Date fechaHasta,
			Pagination pagination, String tiporb);

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 * @exception Exception
	 *                Exception
	 */
	Entidad updateEntidad(Entidad entidad) throws Exception;

	/**
	 * Updates a single row in the Entidad table. Sin validacion negocio. Para
	 * los masivos
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 * @exception Exception
	 *                Exception
	 */
	Entidad updateEntidadSinValidacion(Entidad entidad) throws Exception;

	/**
	 * Generates a new codigo organismo
	 * 
	 * @param entidad
	 *            Entidad
	 * @return String
	 */
	String obtenerCodigoOrganismo(Entidad entidad);

}